/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hbase;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.io.hbase.HBaseRowMutationsCoder;
import org.apache.beam.sdk.io.hbase.utils.HashUtils;
import org.apache.beam.sdk.io.hbase.utils.TestConstants;
import org.apache.beam.sdk.io.hbase.utils.TestHBaseUtils;
import org.apache.hadoop.hbase.client.RowMutations;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RowMutationsCoderTest {
    private final HBaseRowMutationsCoder coder = HBaseRowMutationsCoder.of();
    private ByteArrayOutputStream outputStream;
    private ByteArrayInputStream inputStream;

    @Before
    public void setUp() {
        this.outputStream = new ByteArrayOutputStream();
    }

    @After
    public void tearDown() throws IOException {
        this.outputStream.close();
    }

    @Test
    public void testEncodePut() throws Exception {
        RowMutations put = new RowMutations(TestConstants.rowKey);
        put.add(TestHBaseUtils.HBaseMutationBuilder.createPut(TestConstants.rowKey, TestConstants.colFamily, TestConstants.colQualifier, TestConstants.value, TestConstants.timeT));
        this.coder.encode(put, (OutputStream)this.outputStream);
        this.inputStream = new ByteArrayInputStream(this.outputStream.toByteArray());
        RowMutations decodedPut = this.coder.decode((InputStream)this.inputStream);
        Assert.assertTrue((this.inputStream.available() == 0 ? 1 : 0) != 0);
        HashUtils.assertRowMutationsEquals(put, decodedPut);
    }

    @Test
    public void testEncodeMultipleMutations() throws Exception {
        RowMutations multipleMutations = new RowMutations(TestConstants.rowKey);
        multipleMutations.add(TestHBaseUtils.HBaseMutationBuilder.createPut(TestConstants.rowKey, TestConstants.colFamily, TestConstants.colQualifier, TestConstants.value, TestConstants.timeT));
        multipleMutations.add(TestHBaseUtils.HBaseMutationBuilder.createDelete(TestConstants.rowKey, TestConstants.colFamily, TestConstants.colQualifier, TestConstants.timeT));
        multipleMutations.add(TestHBaseUtils.HBaseMutationBuilder.createDeleteFamily(TestConstants.rowKey, TestConstants.colFamily, TestConstants.timeT));
        this.coder.encode(multipleMutations, (OutputStream)this.outputStream);
        this.inputStream = new ByteArrayInputStream(this.outputStream.toByteArray());
        RowMutations decodedMultipleMutations = this.coder.decode((InputStream)this.inputStream);
        Assert.assertTrue((this.inputStream.available() == 0 ? 1 : 0) != 0);
        HashUtils.assertRowMutationsEquals(multipleMutations, decodedMultipleMutations);
    }

    @Test
    public void testEncodeMultipleRowMutations() throws Exception {
        RowMutations put = new RowMutations(TestConstants.rowKey);
        put.add(TestHBaseUtils.HBaseMutationBuilder.createPut(TestConstants.rowKey, TestConstants.colFamily, TestConstants.colQualifier, TestConstants.value, TestConstants.timeT));
        RowMutations deleteCols = new RowMutations(TestConstants.rowKey);
        deleteCols.add(TestHBaseUtils.HBaseMutationBuilder.createDelete(TestConstants.rowKey, TestConstants.colFamily, TestConstants.colQualifier, TestConstants.timeT));
        RowMutations deleteFamily = new RowMutations(TestConstants.rowKey);
        deleteFamily.add(TestHBaseUtils.HBaseMutationBuilder.createDeleteFamily(TestConstants.rowKey, TestConstants.colFamily, TestConstants.timeT));
        this.coder.encode(put, (OutputStream)this.outputStream);
        this.coder.encode(deleteCols, (OutputStream)this.outputStream);
        this.coder.encode(deleteFamily, (OutputStream)this.outputStream);
        this.inputStream = new ByteArrayInputStream(this.outputStream.toByteArray());
        RowMutations decodedPut = this.coder.decode((InputStream)this.inputStream);
        RowMutations decodedDeleteCols = this.coder.decode((InputStream)this.inputStream);
        RowMutations decodedDeleteFamily = this.coder.decode((InputStream)this.inputStream);
        Assert.assertTrue((this.inputStream.available() == 0 ? 1 : 0) != 0);
        HashUtils.assertRowMutationsEquals(put, decodedPut);
        HashUtils.assertRowMutationsEquals(deleteCols, decodedDeleteCols);
        HashUtils.assertRowMutationsEquals(deleteFamily, decodedDeleteFamily);
    }

    @Test
    public void testEncodeMultipleComplexRowMutations() throws Exception {
        RowMutations complexMutation = new RowMutations(TestConstants.rowKey);
        complexMutation.add(TestHBaseUtils.HBaseMutationBuilder.createPut(TestConstants.rowKey, TestConstants.colFamily, TestConstants.colQualifier, TestConstants.value, TestConstants.timeT));
        complexMutation.add(TestHBaseUtils.HBaseMutationBuilder.createDelete(TestConstants.rowKey, TestConstants.colFamily2, TestConstants.colQualifier2, TestConstants.timeT + 1L));
        complexMutation.add(TestHBaseUtils.HBaseMutationBuilder.createDeleteFamily(TestConstants.rowKey, TestConstants.colFamily, TestConstants.timeT));
        this.coder.encode(complexMutation, (OutputStream)this.outputStream);
        this.coder.encode(complexMutation, (OutputStream)this.outputStream);
        this.coder.encode(complexMutation, (OutputStream)this.outputStream);
        this.inputStream = new ByteArrayInputStream(this.outputStream.toByteArray());
        RowMutations decodedComplexMutation = this.coder.decode((InputStream)this.inputStream);
        RowMutations decodedComplexMutation2 = this.coder.decode((InputStream)this.inputStream);
        RowMutations decodedComplexMutation3 = this.coder.decode((InputStream)this.inputStream);
        Assert.assertTrue((this.inputStream.available() == 0 ? 1 : 0) != 0);
        HashUtils.assertRowMutationsEquals(complexMutation, decodedComplexMutation);
        HashUtils.assertRowMutationsEquals(complexMutation, decodedComplexMutation2);
        HashUtils.assertRowMutationsEquals(complexMutation, decodedComplexMutation3);
    }
}

