/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hbase.utils;

import java.io.IOException;
import java.util.UUID;
import org.apache.beam.sdk.io.hbase.utils.TestConstants;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;

public class TestHBaseUtils {
    public static byte[] getCell(Table table, byte[] rowKey, byte[] colFamily, byte[] colQualifier) throws IOException {
        return TestHBaseUtils.getRowResult(table, rowKey).getValue(colFamily, colQualifier);
    }

    public static Result getRowResult(Table table, byte[] rowKey) throws IOException {
        return table.get(new Get(rowKey));
    }

    public static Table createTable(HBaseTestingUtility htu) throws IOException {
        return TestHBaseUtils.createTable(htu, UUID.randomUUID().toString());
    }

    public static Table createTable(HBaseTestingUtility htu, String name) throws IOException {
        TableName tableName = TableName.valueOf((String)name);
        return htu.createTable(tableName, new String[]{Bytes.toString((byte[])TestConstants.colFamily), Bytes.toString((byte[])TestConstants.colFamily2)});
    }

    public static class HBaseMutationBuilder {
        public static Put createPut(byte[] rowKey, byte[] colFamily, byte[] colQualifier, byte[] value, long atTimestamp) {
            return new Put(rowKey, atTimestamp).addColumn(colFamily, colQualifier, value);
        }

        public static Delete createDelete(byte[] rowKey, byte[] colFamily, byte[] colQualifier, long atTimestamp) {
            return new Delete(rowKey, atTimestamp).addColumns(colFamily, colQualifier);
        }

        public static Delete createDeleteFamily(byte[] rowKey, byte[] colFamily, long atTimestamp) {
            return new Delete(rowKey, atTimestamp).addFamily(colFamily);
        }
    }
}

