/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.jdbc;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.jdbc.JdbcReadSchemaTransformProvider;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;

final class AutoValue_JdbcReadSchemaTransformProvider_JdbcReadSchemaTransformConfiguration
extends JdbcReadSchemaTransformProvider.JdbcReadSchemaTransformConfiguration {
    private final String jdbcUrl;
    private final List<@org.checkerframework.checker.nullness.qual.Nullable String> connectionInitSql;
    private final String connectionProperties;
    private final Boolean disableAutoCommit;
    private final String driverClassName;
    private final String driverJars;
    private final Integer fetchSize;
    private final String jdbcType;
    private final String location;
    private final String partitionColumn;
    private final Integer numPartitions;
    private final Boolean outputParallelization;
    private final String password;
    private final String readQuery;
    private final String username;

    private AutoValue_JdbcReadSchemaTransformProvider_JdbcReadSchemaTransformConfiguration(String jdbcUrl, @Nullable List<@org.checkerframework.checker.nullness.qual.Nullable String> connectionInitSql, @Nullable String connectionProperties, @Nullable Boolean disableAutoCommit, @Nullable String driverClassName, @Nullable String driverJars, @Nullable Integer fetchSize, @Nullable String jdbcType, @Nullable String location, @Nullable String partitionColumn, @Nullable Integer numPartitions, @Nullable Boolean outputParallelization, @Nullable String password, @Nullable String readQuery, @Nullable String username) {
        this.jdbcUrl = jdbcUrl;
        this.connectionInitSql = connectionInitSql;
        this.connectionProperties = connectionProperties;
        this.disableAutoCommit = disableAutoCommit;
        this.driverClassName = driverClassName;
        this.driverJars = driverJars;
        this.fetchSize = fetchSize;
        this.jdbcType = jdbcType;
        this.location = location;
        this.partitionColumn = partitionColumn;
        this.numPartitions = numPartitions;
        this.outputParallelization = outputParallelization;
        this.password = password;
        this.readQuery = readQuery;
        this.username = username;
    }

    @Override
    @SchemaFieldDescription(value="Connection URL for the JDBC source.")
    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="Sets the connection init sql statements used by the Driver. Only MySQL and MariaDB support this.")
    public List<@org.checkerframework.checker.nullness.qual.Nullable String> getConnectionInitSql() {
        return this.connectionInitSql;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="Used to set connection properties passed to the JDBC driver not already defined as standalone parameter (e.g. username and password can be set using parameters above accordingly). Format of the string must be \"key1=value1;key2=value2;\".")
    public String getConnectionProperties() {
        return this.connectionProperties;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="Whether to disable auto commit on read. Defaults to true if not provided. The need for this config varies depending on the database platform. Informix requires this to be set to false while Postgres requires this to be set to true.")
    public Boolean getDisableAutoCommit() {
        return this.disableAutoCommit;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="Name of a Java Driver class to use to connect to the JDBC source. For example, \"com.mysql.jdbc.Driver\".")
    public String getDriverClassName() {
        return this.driverClassName;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="Comma separated path(s) for the JDBC driver jar(s). This can be a local path or GCS (gs://) path.")
    public String getDriverJars() {
        return this.driverJars;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="This method is used to override the size of the data that is going to be fetched and loaded in memory per every database call. It should ONLY be used if the default value throws memory errors.")
    public Integer getFetchSize() {
        return this.fetchSize;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="Type of JDBC source. When specified, an appropriate default Driver will be packaged with the transform. One of mysql, postgres, oracle, or mssql.")
    public String getJdbcType() {
        return this.jdbcType;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="Name of the table to read from.")
    public String getLocation() {
        return this.location;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="Name of a column of numeric type that will be used for partitioning.")
    public String getPartitionColumn() {
        return this.partitionColumn;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="The number of partitions")
    public Integer getNumPartitions() {
        return this.numPartitions;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="Whether to reshuffle the resulting PCollection so results are distributed to all workers.")
    public Boolean getOutputParallelization() {
        return this.outputParallelization;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="Password for the JDBC source.")
    public String getPassword() {
        return this.password;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="SQL query used to query the JDBC source.")
    public String getReadQuery() {
        return this.readQuery;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="Username for the JDBC source.")
    public String getUsername() {
        return this.username;
    }

    public String toString() {
        return "JdbcReadSchemaTransformConfiguration{jdbcUrl=" + this.jdbcUrl + ", connectionInitSql=" + this.connectionInitSql + ", connectionProperties=" + this.connectionProperties + ", disableAutoCommit=" + this.disableAutoCommit + ", driverClassName=" + this.driverClassName + ", driverJars=" + this.driverJars + ", fetchSize=" + this.fetchSize + ", jdbcType=" + this.jdbcType + ", location=" + this.location + ", partitionColumn=" + this.partitionColumn + ", numPartitions=" + this.numPartitions + ", outputParallelization=" + this.outputParallelization + ", password=" + this.password + ", readQuery=" + this.readQuery + ", username=" + this.username + "}";
    }

    public boolean equals(@org.checkerframework.checker.nullness.qual.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof JdbcReadSchemaTransformProvider.JdbcReadSchemaTransformConfiguration) {
            JdbcReadSchemaTransformProvider.JdbcReadSchemaTransformConfiguration that = (JdbcReadSchemaTransformProvider.JdbcReadSchemaTransformConfiguration)o;
            return this.jdbcUrl.equals(that.getJdbcUrl()) && (this.connectionInitSql == null ? that.getConnectionInitSql() == null : this.connectionInitSql.equals(that.getConnectionInitSql())) && (this.connectionProperties == null ? that.getConnectionProperties() == null : this.connectionProperties.equals(that.getConnectionProperties())) && (this.disableAutoCommit == null ? that.getDisableAutoCommit() == null : this.disableAutoCommit.equals(that.getDisableAutoCommit())) && (this.driverClassName == null ? that.getDriverClassName() == null : this.driverClassName.equals(that.getDriverClassName())) && (this.driverJars == null ? that.getDriverJars() == null : this.driverJars.equals(that.getDriverJars())) && (this.fetchSize == null ? that.getFetchSize() == null : this.fetchSize.equals(that.getFetchSize())) && (this.jdbcType == null ? that.getJdbcType() == null : this.jdbcType.equals(that.getJdbcType())) && (this.location == null ? that.getLocation() == null : this.location.equals(that.getLocation())) && (this.partitionColumn == null ? that.getPartitionColumn() == null : this.partitionColumn.equals(that.getPartitionColumn())) && (this.numPartitions == null ? that.getNumPartitions() == null : this.numPartitions.equals(that.getNumPartitions())) && (this.outputParallelization == null ? that.getOutputParallelization() == null : this.outputParallelization.equals(that.getOutputParallelization())) && (this.password == null ? that.getPassword() == null : this.password.equals(that.getPassword())) && (this.readQuery == null ? that.getReadQuery() == null : this.readQuery.equals(that.getReadQuery())) && (this.username == null ? that.getUsername() == null : this.username.equals(that.getUsername()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.jdbcUrl.hashCode();
        h$ *= 1000003;
        h$ ^= this.connectionInitSql == null ? 0 : this.connectionInitSql.hashCode();
        h$ *= 1000003;
        h$ ^= this.connectionProperties == null ? 0 : this.connectionProperties.hashCode();
        h$ *= 1000003;
        h$ ^= this.disableAutoCommit == null ? 0 : this.disableAutoCommit.hashCode();
        h$ *= 1000003;
        h$ ^= this.driverClassName == null ? 0 : this.driverClassName.hashCode();
        h$ *= 1000003;
        h$ ^= this.driverJars == null ? 0 : this.driverJars.hashCode();
        h$ *= 1000003;
        h$ ^= this.fetchSize == null ? 0 : this.fetchSize.hashCode();
        h$ *= 1000003;
        h$ ^= this.jdbcType == null ? 0 : this.jdbcType.hashCode();
        h$ *= 1000003;
        h$ ^= this.location == null ? 0 : this.location.hashCode();
        h$ *= 1000003;
        h$ ^= this.partitionColumn == null ? 0 : this.partitionColumn.hashCode();
        h$ *= 1000003;
        h$ ^= this.numPartitions == null ? 0 : this.numPartitions.hashCode();
        h$ *= 1000003;
        h$ ^= this.outputParallelization == null ? 0 : this.outputParallelization.hashCode();
        h$ *= 1000003;
        h$ ^= this.password == null ? 0 : this.password.hashCode();
        h$ *= 1000003;
        h$ ^= this.readQuery == null ? 0 : this.readQuery.hashCode();
        h$ *= 1000003;
        return h$ ^= this.username == null ? 0 : this.username.hashCode();
    }

    static final class Builder
    extends JdbcReadSchemaTransformProvider.JdbcReadSchemaTransformConfiguration.Builder {
        private String jdbcUrl;
        private List<@org.checkerframework.checker.nullness.qual.Nullable String> connectionInitSql;
        private String connectionProperties;
        private Boolean disableAutoCommit;
        private String driverClassName;
        private String driverJars;
        private Integer fetchSize;
        private String jdbcType;
        private String location;
        private String partitionColumn;
        private Integer numPartitions;
        private Boolean outputParallelization;
        private String password;
        private String readQuery;
        private String username;

        Builder() {
        }

        @Override
        public JdbcReadSchemaTransformProvider.JdbcReadSchemaTransformConfiguration.Builder setJdbcUrl(String jdbcUrl) {
            if (jdbcUrl == null) {
                throw new NullPointerException("Null jdbcUrl");
            }
            this.jdbcUrl = jdbcUrl;
            return this;
        }

        @Override
        public JdbcReadSchemaTransformProvider.JdbcReadSchemaTransformConfiguration.Builder setConnectionInitSql(List<String> connectionInitSql) {
            this.connectionInitSql = connectionInitSql;
            return this;
        }

        @Override
        public JdbcReadSchemaTransformProvider.JdbcReadSchemaTransformConfiguration.Builder setConnectionProperties(String connectionProperties) {
            this.connectionProperties = connectionProperties;
            return this;
        }

        @Override
        public JdbcReadSchemaTransformProvider.JdbcReadSchemaTransformConfiguration.Builder setDisableAutoCommit(Boolean disableAutoCommit) {
            this.disableAutoCommit = disableAutoCommit;
            return this;
        }

        @Override
        public JdbcReadSchemaTransformProvider.JdbcReadSchemaTransformConfiguration.Builder setDriverClassName(String driverClassName) {
            this.driverClassName = driverClassName;
            return this;
        }

        @Override
        public JdbcReadSchemaTransformProvider.JdbcReadSchemaTransformConfiguration.Builder setDriverJars(String driverJars) {
            this.driverJars = driverJars;
            return this;
        }

        @Override
        public JdbcReadSchemaTransformProvider.JdbcReadSchemaTransformConfiguration.Builder setFetchSize(Integer fetchSize) {
            this.fetchSize = fetchSize;
            return this;
        }

        @Override
        public JdbcReadSchemaTransformProvider.JdbcReadSchemaTransformConfiguration.Builder setJdbcType(String jdbcType) {
            this.jdbcType = jdbcType;
            return this;
        }

        @Override
        public JdbcReadSchemaTransformProvider.JdbcReadSchemaTransformConfiguration.Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        @Override
        public JdbcReadSchemaTransformProvider.JdbcReadSchemaTransformConfiguration.Builder setPartitionColumn(String partitionColumn) {
            this.partitionColumn = partitionColumn;
            return this;
        }

        @Override
        public JdbcReadSchemaTransformProvider.JdbcReadSchemaTransformConfiguration.Builder setNumPartitions(Integer numPartitions) {
            this.numPartitions = numPartitions;
            return this;
        }

        @Override
        public JdbcReadSchemaTransformProvider.JdbcReadSchemaTransformConfiguration.Builder setOutputParallelization(Boolean outputParallelization) {
            this.outputParallelization = outputParallelization;
            return this;
        }

        @Override
        public JdbcReadSchemaTransformProvider.JdbcReadSchemaTransformConfiguration.Builder setPassword(String password) {
            this.password = password;
            return this;
        }

        @Override
        public JdbcReadSchemaTransformProvider.JdbcReadSchemaTransformConfiguration.Builder setReadQuery(String readQuery) {
            this.readQuery = readQuery;
            return this;
        }

        @Override
        public JdbcReadSchemaTransformProvider.JdbcReadSchemaTransformConfiguration.Builder setUsername(String username) {
            this.username = username;
            return this;
        }

        @Override
        public JdbcReadSchemaTransformProvider.JdbcReadSchemaTransformConfiguration build() {
            if (this.jdbcUrl == null) {
                String missing = " jdbcUrl";
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_JdbcReadSchemaTransformProvider_JdbcReadSchemaTransformConfiguration(this.jdbcUrl, this.connectionInitSql, this.connectionProperties, this.disableAutoCommit, this.driverClassName, this.driverJars, this.fetchSize, this.jdbcType, this.location, this.partitionColumn, this.numPartitions, this.outputParallelization, this.password, this.readQuery, this.username);
        }
    }
}

