
package org.apache.beam.sdk.io.jms;

import javax.annotation.Generated;
import javax.jms.ConnectionFactory;
import org.joda.time.Duration;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_JmsIO_Read extends JmsIO.Read {

  private final ConnectionFactory connectionFactory;
  private final String queue;
  private final String topic;
  private final long maxNumRecords;
  private final Duration maxReadTime;

  private AutoValue_JmsIO_Read(
      @javax.annotation.Nullable ConnectionFactory connectionFactory,
      @javax.annotation.Nullable String queue,
      @javax.annotation.Nullable String topic,
      long maxNumRecords,
      @javax.annotation.Nullable Duration maxReadTime) {
    this.connectionFactory = connectionFactory;
    this.queue = queue;
    this.topic = topic;
    this.maxNumRecords = maxNumRecords;
    this.maxReadTime = maxReadTime;
  }

  @javax.annotation.Nullable
  @Override
  ConnectionFactory getConnectionFactory() {
    return connectionFactory;
  }

  @javax.annotation.Nullable
  @Override
  String getQueue() {
    return queue;
  }

  @javax.annotation.Nullable
  @Override
  String getTopic() {
    return topic;
  }

  @Override
  long getMaxNumRecords() {
    return maxNumRecords;
  }

  @javax.annotation.Nullable
  @Override
  Duration getMaxReadTime() {
    return maxReadTime;
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof JmsIO.Read) {
      JmsIO.Read that = (JmsIO.Read) o;
      return ((this.connectionFactory == null) ? (that.getConnectionFactory() == null) : this.connectionFactory.equals(that.getConnectionFactory()))
           && ((this.queue == null) ? (that.getQueue() == null) : this.queue.equals(that.getQueue()))
           && ((this.topic == null) ? (that.getTopic() == null) : this.topic.equals(that.getTopic()))
           && (this.maxNumRecords == that.getMaxNumRecords())
           && ((this.maxReadTime == null) ? (that.getMaxReadTime() == null) : this.maxReadTime.equals(that.getMaxReadTime()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= (connectionFactory == null) ? 0 : connectionFactory.hashCode();
    h *= 1000003;
    h ^= (queue == null) ? 0 : queue.hashCode();
    h *= 1000003;
    h ^= (topic == null) ? 0 : topic.hashCode();
    h *= 1000003;
    h ^= (maxNumRecords >>> 32) ^ maxNumRecords;
    h *= 1000003;
    h ^= (maxReadTime == null) ? 0 : maxReadTime.hashCode();
    return h;
  }

  @Override
  public JmsIO.Read.Builder builder() {
    return new Builder(this);
  }

  static final class Builder extends JmsIO.Read.Builder {
    private ConnectionFactory connectionFactory;
    private String queue;
    private String topic;
    private Long maxNumRecords;
    private Duration maxReadTime;
    Builder() {
    }
    Builder(JmsIO.Read source) {
      this.connectionFactory = source.getConnectionFactory();
      this.queue = source.getQueue();
      this.topic = source.getTopic();
      this.maxNumRecords = source.getMaxNumRecords();
      this.maxReadTime = source.getMaxReadTime();
    }
    @Override
    public JmsIO.Read.Builder setConnectionFactory(ConnectionFactory connectionFactory) {
      this.connectionFactory = connectionFactory;
      return this;
    }
    @Override
    public JmsIO.Read.Builder setQueue(String queue) {
      this.queue = queue;
      return this;
    }
    @Override
    public JmsIO.Read.Builder setTopic(String topic) {
      this.topic = topic;
      return this;
    }
    @Override
    public JmsIO.Read.Builder setMaxNumRecords(long maxNumRecords) {
      this.maxNumRecords = maxNumRecords;
      return this;
    }
    @Override
    public JmsIO.Read.Builder setMaxReadTime(Duration maxReadTime) {
      this.maxReadTime = maxReadTime;
      return this;
    }
    @Override
    public JmsIO.Read build() {
      String missing = "";
      if (maxNumRecords == null) {
        missing += " maxNumRecords";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_JmsIO_Read(
          this.connectionFactory,
          this.queue,
          this.topic,
          this.maxNumRecords,
          this.maxReadTime);
    }
  }
}
