/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.jms;

import javax.annotation.Nullable;
import javax.jms.ConnectionFactory;
import org.apache.beam.sdk.io.jms.JmsIO;
import org.joda.time.Duration;

final class AutoValue_JmsIO_Read
extends JmsIO.Read {
    private final ConnectionFactory connectionFactory;
    private final String queue;
    private final String topic;
    private final long maxNumRecords;
    private final Duration maxReadTime;

    private AutoValue_JmsIO_Read(@Nullable ConnectionFactory connectionFactory, @Nullable String queue, @Nullable String topic, long maxNumRecords, @Nullable Duration maxReadTime) {
        this.connectionFactory = connectionFactory;
        this.queue = queue;
        this.topic = topic;
        this.maxNumRecords = maxNumRecords;
        this.maxReadTime = maxReadTime;
    }

    @Override
    @Nullable
    ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    @Override
    @Nullable
    String getQueue() {
        return this.queue;
    }

    @Override
    @Nullable
    String getTopic() {
        return this.topic;
    }

    @Override
    long getMaxNumRecords() {
        return this.maxNumRecords;
    }

    @Override
    @Nullable
    Duration getMaxReadTime() {
        return this.maxReadTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof JmsIO.Read) {
            JmsIO.Read that = (JmsIO.Read)((Object)o);
            return (this.connectionFactory == null ? that.getConnectionFactory() == null : this.connectionFactory.equals(that.getConnectionFactory())) && (this.queue == null ? that.getQueue() == null : this.queue.equals(that.getQueue())) && (this.topic == null ? that.getTopic() == null : this.topic.equals(that.getTopic())) && this.maxNumRecords == that.getMaxNumRecords() && (this.maxReadTime == null ? that.getMaxReadTime() == null : this.maxReadTime.equals((Object)that.getMaxReadTime()));
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.connectionFactory == null ? 0 : this.connectionFactory.hashCode();
        h *= 1000003;
        h ^= this.queue == null ? 0 : this.queue.hashCode();
        h *= 1000003;
        h ^= this.topic == null ? 0 : this.topic.hashCode();
        h *= 1000003;
        h = (int)((long)h ^ (this.maxNumRecords >>> 32 ^ this.maxNumRecords));
        h *= 1000003;
        return h ^= this.maxReadTime == null ? 0 : this.maxReadTime.hashCode();
    }

    @Override
    public JmsIO.Read.Builder builder() {
        return new Builder(this);
    }

    static final class Builder
    extends JmsIO.Read.Builder {
        private ConnectionFactory connectionFactory;
        private String queue;
        private String topic;
        private Long maxNumRecords;
        private Duration maxReadTime;

        Builder() {
        }

        Builder(JmsIO.Read source) {
            this.connectionFactory = source.getConnectionFactory();
            this.queue = source.getQueue();
            this.topic = source.getTopic();
            this.maxNumRecords = source.getMaxNumRecords();
            this.maxReadTime = source.getMaxReadTime();
        }

        @Override
        public JmsIO.Read.Builder setConnectionFactory(ConnectionFactory connectionFactory) {
            this.connectionFactory = connectionFactory;
            return this;
        }

        @Override
        public JmsIO.Read.Builder setQueue(String queue) {
            this.queue = queue;
            return this;
        }

        @Override
        public JmsIO.Read.Builder setTopic(String topic) {
            this.topic = topic;
            return this;
        }

        @Override
        public JmsIO.Read.Builder setMaxNumRecords(long maxNumRecords) {
            this.maxNumRecords = maxNumRecords;
            return this;
        }

        @Override
        public JmsIO.Read.Builder setMaxReadTime(Duration maxReadTime) {
            this.maxReadTime = maxReadTime;
            return this;
        }

        @Override
        public JmsIO.Read build() {
            String missing = "";
            if (this.maxNumRecords == null) {
                missing = missing + " maxNumRecords";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_JmsIO_Read(this.connectionFactory, this.queue, this.topic, this.maxNumRecords, this.maxReadTime);
        }
    }
}

