/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.jms;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.jms.AutoValue_JmsIO_Read;
import org.apache.beam.sdk.io.jms.AutoValue_JmsIO_Write;
import org.apache.beam.sdk.io.jms.JmsCheckpointMark;
import org.apache.beam.sdk.io.jms.JmsRecord;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsIO {
    private static final Logger LOG = LoggerFactory.getLogger(JmsIO.class);

    public static Read read() {
        return new AutoValue_JmsIO_Read.Builder().setMaxNumRecords(Long.MAX_VALUE).build();
    }

    public static Write write() {
        return new AutoValue_JmsIO_Write.Builder().build();
    }

    private JmsIO() {
    }

    public static abstract class Write
    extends PTransform<PCollection<String>, PDone> {
        @Nullable
        abstract ConnectionFactory getConnectionFactory();

        @Nullable
        abstract String getQueue();

        @Nullable
        abstract String getTopic();

        @Nullable
        abstract String getUsername();

        @Nullable
        abstract String getPassword();

        abstract Builder builder();

        public Write withConnectionFactory(ConnectionFactory connectionFactory) {
            Preconditions.checkArgument((connectionFactory != null ? 1 : 0) != 0, (Object)"withConnectionFactory(connectionFactory) called with null connectionFactory");
            return this.builder().setConnectionFactory(connectionFactory).build();
        }

        public Write withQueue(String queue) {
            Preconditions.checkArgument((queue != null ? 1 : 0) != 0, (Object)"withQueue(queue) called with null queue");
            return this.builder().setQueue(queue).build();
        }

        public Write withTopic(String topic) {
            Preconditions.checkArgument((topic != null ? 1 : 0) != 0, (Object)"withTopic(topic) called with null topic");
            return this.builder().setTopic(topic).build();
        }

        public Write withUsername(String username) {
            Preconditions.checkArgument((username != null ? 1 : 0) != 0, (Object)"JmsIO.write().withUsername(username) called with null username");
            return this.builder().setUsername(username).build();
        }

        public Write withPassword(String password) {
            Preconditions.checkArgument((password != null ? 1 : 0) != 0, (Object)"JmsIO.write().withPassword(password) called with null password");
            return this.builder().setPassword(password).build();
        }

        public PDone expand(PCollection<String> input) {
            input.apply((PTransform)ParDo.of((DoFn)new WriterFn(this)));
            return PDone.in((Pipeline)input.getPipeline());
        }

        public void validate(PCollection<String> input) {
            Preconditions.checkState((this.getConnectionFactory() != null ? 1 : 0) != 0, (Object)"JmsIO.write() requires a JMS connection factory to be set via withConnectionFactory(connectionFactory)");
            Preconditions.checkState((this.getQueue() != null || this.getTopic() != null ? 1 : 0) != 0, (Object)"JmsIO.write() requires a JMS destination (queue or topic) to be set via withQueue(queue) or withTopic(topic)");
        }

        private static class WriterFn
        extends DoFn<String, Void> {
            private Write spec;
            private Connection connection;
            private Session session;
            private MessageProducer producer;

            public WriterFn(Write spec) {
                this.spec = spec;
            }

            @DoFn.StartBundle
            public void startBundle(DoFn.Context c) throws Exception {
                if (this.producer == null) {
                    this.connection = this.spec.getUsername() != null ? this.spec.getConnectionFactory().createConnection(this.spec.getUsername(), this.spec.getPassword()) : this.spec.getConnectionFactory().createConnection();
                    this.connection.start();
                    this.session = this.connection.createSession(false, 1);
                    Object destination = this.spec.getQueue() != null ? this.session.createQueue(this.spec.getQueue()) : this.session.createTopic(this.spec.getTopic());
                    this.producer = this.session.createProducer((Destination)destination);
                }
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext ctx) throws Exception {
                String value = (String)ctx.element();
                try {
                    TextMessage message = this.session.createTextMessage(value);
                    this.producer.send((Message)message);
                }
                catch (Exception t) {
                    this.finishBundle(null);
                    throw t;
                }
            }

            @DoFn.FinishBundle
            public void finishBundle(DoFn.Context c) throws Exception {
                this.producer.close();
                this.producer = null;
                this.session.close();
                this.session = null;
                this.connection.stop();
                this.connection.close();
                this.connection = null;
            }
        }

        static abstract class Builder {
            Builder() {
            }

            abstract Builder setConnectionFactory(ConnectionFactory var1);

            abstract Builder setQueue(String var1);

            abstract Builder setTopic(String var1);

            abstract Builder setUsername(String var1);

            abstract Builder setPassword(String var1);

            abstract Write build();
        }
    }

    private static class UnboundedJmsReader
    extends UnboundedSource.UnboundedReader<JmsRecord> {
        private UnboundedJmsSource source;
        private JmsCheckpointMark checkpointMark;
        private Connection connection;
        private Session session;
        private MessageConsumer consumer;
        private JmsRecord currentRecord;
        private Instant currentTimestamp;

        public UnboundedJmsReader(UnboundedJmsSource source, JmsCheckpointMark checkpointMark) {
            this.source = source;
            this.checkpointMark = checkpointMark != null ? checkpointMark : new JmsCheckpointMark();
            this.currentRecord = null;
        }

        public boolean start() throws IOException {
            Read spec = this.source.spec;
            ConnectionFactory connectionFactory = spec.getConnectionFactory();
            try {
                Connection connection = spec.getUsername() != null ? connectionFactory.createConnection(spec.getUsername(), spec.getPassword()) : connectionFactory.createConnection();
                connection.start();
                this.connection = connection;
            }
            catch (Exception e) {
                throw new IOException("Error connecting to JMS", e);
            }
            try {
                this.session = this.connection.createSession(false, 1);
            }
            catch (Exception e) {
                throw new IOException("Error creating JMS session", e);
            }
            try {
                this.consumer = spec.getTopic() != null ? this.session.createConsumer((Destination)this.session.createTopic(spec.getTopic())) : this.session.createConsumer((Destination)this.session.createQueue(spec.getQueue()));
            }
            catch (Exception e) {
                throw new IOException("Error creating JMS consumer", e);
            }
            return this.advance();
        }

        public boolean advance() throws IOException {
            try {
                TextMessage message = (TextMessage)this.consumer.receiveNoWait();
                if (message == null) {
                    this.currentRecord = null;
                    return false;
                }
                HashMap<String, Object> properties = new HashMap<String, Object>();
                Enumeration propertyNames = message.getPropertyNames();
                while (propertyNames.hasMoreElements()) {
                    String propertyName = (String)propertyNames.nextElement();
                    properties.put(propertyName, message.getObjectProperty(propertyName));
                }
                JmsRecord jmsRecord = new JmsRecord(message.getJMSMessageID(), message.getJMSTimestamp(), message.getJMSCorrelationID(), message.getJMSReplyTo(), message.getJMSDestination(), message.getJMSDeliveryMode(), message.getJMSRedelivered(), message.getJMSType(), message.getJMSExpiration(), message.getJMSPriority(), properties, message.getText());
                this.checkpointMark.addMessage((Message)message);
                this.currentRecord = jmsRecord;
                this.currentTimestamp = new Instant(message.getJMSTimestamp());
                return true;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        public JmsRecord getCurrent() throws NoSuchElementException {
            if (this.currentRecord == null) {
                throw new NoSuchElementException();
            }
            return this.currentRecord;
        }

        public Instant getWatermark() {
            return this.checkpointMark.getOldestPendingTimestamp();
        }

        public Instant getCurrentTimestamp() {
            if (this.currentRecord == null) {
                throw new NoSuchElementException();
            }
            return this.currentTimestamp;
        }

        public UnboundedSource.CheckpointMark getCheckpointMark() {
            return this.checkpointMark;
        }

        public UnboundedSource<JmsRecord, ?> getCurrentSource() {
            return this.source;
        }

        public void close() throws IOException {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                    this.consumer = null;
                }
                if (this.session != null) {
                    this.session.close();
                    this.session = null;
                }
                if (this.connection != null) {
                    this.connection.stop();
                    this.connection.close();
                    this.connection = null;
                }
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    @VisibleForTesting
    protected static class UnboundedJmsSource
    extends UnboundedSource<JmsRecord, JmsCheckpointMark> {
        private final Read spec;

        public UnboundedJmsSource(Read spec) {
            this.spec = spec;
        }

        public List<UnboundedJmsSource> generateInitialSplits(int desiredNumSplits, PipelineOptions options) throws Exception {
            ArrayList<UnboundedJmsSource> sources = new ArrayList<UnboundedJmsSource>();
            if (this.spec.getTopic() != null) {
                sources.add(new UnboundedJmsSource(this.spec));
            } else {
                for (int i = 0; i < desiredNumSplits; ++i) {
                    sources.add(new UnboundedJmsSource(this.spec));
                }
            }
            return sources;
        }

        public UnboundedJmsReader createReader(PipelineOptions options, JmsCheckpointMark checkpointMark) {
            return new UnboundedJmsReader(this, checkpointMark);
        }

        public void validate() {
            this.spec.validate((PBegin)null);
        }

        public Coder<JmsCheckpointMark> getCheckpointMarkCoder() {
            return AvroCoder.of(JmsCheckpointMark.class);
        }

        public Coder<JmsRecord> getDefaultOutputCoder() {
            return SerializableCoder.of(JmsRecord.class);
        }
    }

    public static abstract class Read
    extends PTransform<PBegin, PCollection<JmsRecord>> {
        @Nullable
        abstract ConnectionFactory getConnectionFactory();

        @Nullable
        abstract String getQueue();

        @Nullable
        abstract String getTopic();

        @Nullable
        abstract String getUsername();

        @Nullable
        abstract String getPassword();

        abstract long getMaxNumRecords();

        @Nullable
        abstract Duration getMaxReadTime();

        abstract Builder builder();

        public Read withConnectionFactory(ConnectionFactory connectionFactory) {
            Preconditions.checkArgument((connectionFactory != null ? 1 : 0) != 0, (Object)"withConnectionFactory(connectionFactory) called with null connectionFactory");
            return this.builder().setConnectionFactory(connectionFactory).build();
        }

        public Read withQueue(String queue) {
            Preconditions.checkArgument((queue != null ? 1 : 0) != 0, (Object)"withQueue(queue) called with null queue");
            return this.builder().setQueue(queue).build();
        }

        public Read withTopic(String topic) {
            Preconditions.checkArgument((topic != null ? 1 : 0) != 0, (Object)"withTopic(topic) called with null topic");
            return this.builder().setTopic(topic).build();
        }

        public Read withUsername(String username) {
            Preconditions.checkArgument((username != null ? 1 : 0) != 0, (Object)"JmsIO.read().withUsername(username) called with null username");
            return this.builder().setUsername(username).build();
        }

        public Read withPassword(String password) {
            Preconditions.checkArgument((password != null ? 1 : 0) != 0, (Object)"JmsIO.read().withPassword(password) called with null password");
            return this.builder().setPassword(password).build();
        }

        public Read withMaxNumRecords(long maxNumRecords) {
            Preconditions.checkArgument((maxNumRecords >= 0L ? 1 : 0) != 0, (Object)"withMaxNumRecords(maxNumRecords) called with invalid maxNumRecords");
            return this.builder().setMaxNumRecords(maxNumRecords).build();
        }

        public Read withMaxReadTime(Duration maxReadTime) {
            Preconditions.checkArgument((maxReadTime != null ? 1 : 0) != 0, (Object)"withMaxReadTime(maxReadTime) called with null maxReadTime");
            return this.builder().setMaxReadTime(maxReadTime).build();
        }

        public PCollection<JmsRecord> expand(PBegin input) {
            Read.Unbounded unbounded;
            Read.Unbounded transform = unbounded = org.apache.beam.sdk.io.Read.from(this.createSource());
            if (this.getMaxNumRecords() != Long.MAX_VALUE) {
                transform = unbounded.withMaxNumRecords(this.getMaxNumRecords());
            } else if (this.getMaxReadTime() != null) {
                transform = unbounded.withMaxReadTime(this.getMaxReadTime());
            }
            return (PCollection)input.getPipeline().apply((PTransform)transform);
        }

        public void validate(PBegin input) {
            Preconditions.checkState((this.getConnectionFactory() != null ? 1 : 0) != 0, (Object)"JmsIO.read() requires a JMS connection factory to be set via withConnectionFactory(connectionFactory)");
            Preconditions.checkState((this.getQueue() != null || this.getTopic() != null ? 1 : 0) != 0, (Object)"JmsIO.read() requires a JMS destination (queue or topic) to be set via withQueue(queueName) or withTopic(topicName)");
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.addIfNotNull(DisplayData.item((String)"queue", (String)this.getQueue()));
            builder.addIfNotNull(DisplayData.item((String)"topic", (String)this.getTopic()));
        }

        @VisibleForTesting
        UnboundedSource<JmsRecord, JmsCheckpointMark> createSource() {
            return new UnboundedJmsSource(this);
        }

        static abstract class Builder {
            Builder() {
            }

            abstract Builder setConnectionFactory(ConnectionFactory var1);

            abstract Builder setQueue(String var1);

            abstract Builder setTopic(String var1);

            abstract Builder setUsername(String var1);

            abstract Builder setPassword(String var1);

            abstract Builder setMaxNumRecords(long var1);

            abstract Builder setMaxReadTime(Duration var1);

            abstract Read build();
        }
    }
}

