/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.jms;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.jms.Message;
import org.apache.beam.sdk.io.UnboundedSource;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JmsCheckpointMark
implements UnboundedSource.CheckpointMark,
Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(JmsCheckpointMark.class);
    private @UnknownKeyFor @NonNull @Initialized Instant oldestMessageTimestamp = Instant.now();
    private transient @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Message> messages = new ArrayList<Message>();
    private final @UnknownKeyFor @NonNull @Initialized ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    JmsCheckpointMark() {
    }

    void add(@UnknownKeyFor @NonNull @Initialized Message message) throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.lock.writeLock().lock();
        try {
            Instant currentMessageTimestamp = new Instant(message.getJMSTimestamp());
            if (currentMessageTimestamp.isBefore((ReadableInstant)this.oldestMessageTimestamp)) {
                this.oldestMessageTimestamp = currentMessageTimestamp;
            }
            this.messages.add(message);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @UnknownKeyFor @NonNull @Initialized Instant getOldestMessageTimestamp() {
        this.lock.readLock().lock();
        try {
            Instant instant = this.oldestMessageTimestamp;
            return instant;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalizeCheckpoint() {
        this.lock.writeLock().lock();
        try {
            for (Message message : this.messages) {
                try {
                    message.acknowledge();
                    Instant currentMessageTimestamp = new Instant(message.getJMSTimestamp());
                    if (!currentMessageTimestamp.isAfter((ReadableInstant)this.oldestMessageTimestamp)) continue;
                    this.oldestMessageTimestamp = currentMessageTimestamp;
                }
                catch (Exception e) {
                    LOG.error("Exception while finalizing message: ", (Throwable)e);
                }
            }
            this.messages.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void readObject(@UnknownKeyFor @NonNull @Initialized ObjectInputStream stream) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized ClassNotFoundException {
        stream.defaultReadObject();
        this.messages = new ArrayList<Message>();
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JmsCheckpointMark that = (JmsCheckpointMark)o;
        return this.oldestMessageTimestamp.equals((Object)that.oldestMessageTimestamp);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.oldestMessageTimestamp);
    }
}

