/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.jms;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.jms.AutoValue_JmsIO_Read;
import org.apache.beam.sdk.io.jms.AutoValue_JmsIO_Write;
import org.apache.beam.sdk.io.jms.JmsCheckpointMark;
import org.apache.beam.sdk.io.jms.JmsRecord;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class JmsIO {
    public static @UnknownKeyFor @NonNull @Initialized Read<@UnknownKeyFor @NonNull @Initialized JmsRecord> read() {
        return new AutoValue_JmsIO_Read.Builder().setMaxNumRecords(Long.MAX_VALUE).setCoder(SerializableCoder.of(JmsRecord.class)).setMessageMapper(new MessageMapper<JmsRecord>(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized JmsRecord mapMessage(@UnknownKeyFor @NonNull @Initialized Message message) throws @UnknownKeyFor @NonNull @Initialized Exception {
                TextMessage textMessage = (TextMessage)message;
                HashMap<String, Object> properties = new HashMap<String, Object>();
                Enumeration propertyNames = textMessage.getPropertyNames();
                while (propertyNames.hasMoreElements()) {
                    String propertyName = (String)propertyNames.nextElement();
                    properties.put(propertyName, textMessage.getObjectProperty(propertyName));
                }
                return new JmsRecord(textMessage.getJMSMessageID(), textMessage.getJMSTimestamp(), textMessage.getJMSCorrelationID(), textMessage.getJMSReplyTo(), textMessage.getJMSDestination(), textMessage.getJMSDeliveryMode(), textMessage.getJMSRedelivered(), textMessage.getJMSType(), textMessage.getJMSExpiration(), textMessage.getJMSPriority(), properties, textMessage.getText());
            }
        }).build();
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Read<T> readMessage() {
        return new AutoValue_JmsIO_Read.Builder().setMaxNumRecords(Long.MAX_VALUE).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized Write write() {
        return new AutoValue_JmsIO_Write.Builder().build();
    }

    private JmsIO() {
    }

    @AutoValue
    public static abstract class Write
    extends PTransform<PCollection<String>, PDone> {
        abstract @Nullable @UnknownKeyFor @Initialized ConnectionFactory getConnectionFactory();

        abstract @Nullable @UnknownKeyFor @Initialized String getQueue();

        abstract @Nullable @UnknownKeyFor @Initialized String getTopic();

        abstract @Nullable @UnknownKeyFor @Initialized String getUsername();

        abstract @Nullable @UnknownKeyFor @Initialized String getPassword();

        abstract @UnknownKeyFor @NonNull @Initialized Builder builder();

        public @UnknownKeyFor @NonNull @Initialized Write withConnectionFactory(@UnknownKeyFor @NonNull @Initialized ConnectionFactory connectionFactory) {
            Preconditions.checkArgument((connectionFactory != null ? 1 : 0) != 0, (Object)"connectionFactory can not be null");
            return this.builder().setConnectionFactory(connectionFactory).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withQueue(@UnknownKeyFor @NonNull @Initialized String queue) {
            Preconditions.checkArgument((queue != null ? 1 : 0) != 0, (Object)"queue can not be null");
            return this.builder().setQueue(queue).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withTopic(@UnknownKeyFor @NonNull @Initialized String topic) {
            Preconditions.checkArgument((topic != null ? 1 : 0) != 0, (Object)"topic can not be null");
            return this.builder().setTopic(topic).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withUsername(@UnknownKeyFor @NonNull @Initialized String username) {
            Preconditions.checkArgument((username != null ? 1 : 0) != 0, (Object)"username can not be null");
            return this.builder().setUsername(username).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withPassword(@UnknownKeyFor @NonNull @Initialized String password) {
            Preconditions.checkArgument((password != null ? 1 : 0) != 0, (Object)"password can not be null");
            return this.builder().setPassword(password).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PDone expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> input) {
            Preconditions.checkArgument((this.getConnectionFactory() != null ? 1 : 0) != 0, (Object)"withConnectionFactory() is required");
            Preconditions.checkArgument((this.getQueue() != null || this.getTopic() != null ? 1 : 0) != 0, (Object)"Either withQueue(queue) or withTopic(topic) is required");
            Preconditions.checkArgument((this.getQueue() == null || this.getTopic() == null ? 1 : 0) != 0, (Object)"withQueue(queue) and withTopic(topic) are exclusive");
            input.apply((PTransform)ParDo.of((DoFn)new WriterFn(this)));
            return PDone.in((Pipeline)input.getPipeline());
        }

        private static class WriterFn
        extends DoFn<String, Void> {
            private @UnknownKeyFor @NonNull @Initialized Write spec;
            private @UnknownKeyFor @NonNull @Initialized Connection connection;
            private @UnknownKeyFor @NonNull @Initialized Session session;
            private @UnknownKeyFor @NonNull @Initialized MessageProducer producer;

            public WriterFn(@UnknownKeyFor @NonNull @Initialized Write spec) {
                this.spec = spec;
            }

            @DoFn.Setup
            public void setup() throws @UnknownKeyFor @NonNull @Initialized Exception {
                if (this.producer == null) {
                    this.connection = this.spec.getUsername() != null ? this.spec.getConnectionFactory().createConnection(this.spec.getUsername(), this.spec.getPassword()) : this.spec.getConnectionFactory().createConnection();
                    this.connection.start();
                    this.session = this.connection.createSession(false, 1);
                    Object destination = this.spec.getQueue() != null ? this.session.createQueue(this.spec.getQueue()) : this.session.createTopic(this.spec.getTopic());
                    this.producer = this.session.createProducer((Destination)destination);
                }
            }

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext ctx) throws @UnknownKeyFor @NonNull @Initialized Exception {
                String value = (String)ctx.element();
                TextMessage message = this.session.createTextMessage(value);
                this.producer.send((Message)message);
            }

            @DoFn.Teardown
            public void teardown() throws @UnknownKeyFor @NonNull @Initialized Exception {
                this.producer.close();
                this.producer = null;
                this.session.close();
                this.session = null;
                this.connection.stop();
                this.connection.close();
                this.connection = null;
            }
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setConnectionFactory(@UnknownKeyFor @NonNull @Initialized ConnectionFactory var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setQueue(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setTopic(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setUsername(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setPassword(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Write build();
        }
    }

    static class UnboundedJmsReader<@UnknownKeyFor T>
    extends UnboundedSource.UnboundedReader<T> {
        private @UnknownKeyFor @NonNull @Initialized UnboundedJmsSource<T> source;
        private @UnknownKeyFor @NonNull @Initialized JmsCheckpointMark checkpointMark;
        private @UnknownKeyFor @NonNull @Initialized Connection connection;
        private @UnknownKeyFor @NonNull @Initialized Session session;
        private @UnknownKeyFor @NonNull @Initialized MessageConsumer consumer;
        private T currentMessage;
        private @UnknownKeyFor @NonNull @Initialized Instant currentTimestamp;

        public UnboundedJmsReader(@UnknownKeyFor @NonNull @Initialized UnboundedJmsSource<T> source, @UnknownKeyFor @NonNull @Initialized JmsCheckpointMark checkpointMark) {
            this.source = source;
            this.checkpointMark = checkpointMark != null ? checkpointMark : new JmsCheckpointMark();
            this.currentMessage = null;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean start() throws @UnknownKeyFor @NonNull @Initialized IOException {
            Read spec = ((UnboundedJmsSource)this.source).spec;
            ConnectionFactory connectionFactory = spec.getConnectionFactory();
            try {
                Connection connection = spec.getUsername() != null ? connectionFactory.createConnection(spec.getUsername(), spec.getPassword()) : connectionFactory.createConnection();
                connection.start();
                this.connection = connection;
            }
            catch (Exception e) {
                throw new IOException("Error connecting to JMS", e);
            }
            try {
                this.session = this.connection.createSession(false, 2);
            }
            catch (Exception e) {
                throw new IOException("Error creating JMS session", e);
            }
            try {
                this.consumer = spec.getTopic() != null ? this.session.createConsumer((Destination)this.session.createTopic(spec.getTopic())) : this.session.createConsumer((Destination)this.session.createQueue(spec.getQueue()));
            }
            catch (Exception e) {
                throw new IOException("Error creating JMS consumer", e);
            }
            return this.advance();
        }

        public @UnknownKeyFor @NonNull @Initialized boolean advance() throws @UnknownKeyFor @NonNull @Initialized IOException {
            try {
                Message message = this.consumer.receiveNoWait();
                if (message == null) {
                    this.currentMessage = null;
                    return false;
                }
                this.checkpointMark.add(message);
                this.currentMessage = ((UnboundedJmsSource)this.source).spec.getMessageMapper().mapMessage(message);
                this.currentTimestamp = new Instant(message.getJMSTimestamp());
                return true;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        public T getCurrent() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
            if (this.currentMessage == null) {
                throw new NoSuchElementException();
            }
            return this.currentMessage;
        }

        public @UnknownKeyFor @NonNull @Initialized Instant getWatermark() {
            return this.checkpointMark.getOldestMessageTimestamp();
        }

        public @UnknownKeyFor @NonNull @Initialized Instant getCurrentTimestamp() {
            if (this.currentMessage == null) {
                throw new NoSuchElementException();
            }
            return this.currentTimestamp;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized UnboundedSource.CheckpointMark getCheckpointMark() {
            return this.checkpointMark;
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized UnboundedSource<T, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> getCurrentSource() {
            return this.source;
        }

        public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                    this.consumer = null;
                }
                if (this.session != null) {
                    this.session.close();
                    this.session = null;
                }
                if (this.connection != null) {
                    this.connection.stop();
                    this.connection.close();
                    this.connection = null;
                }
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    static class UnboundedJmsSource<@UnknownKeyFor T>
    extends UnboundedSource<T, JmsCheckpointMark> {
        private final @UnknownKeyFor @NonNull @Initialized Read<T> spec;

        public UnboundedJmsSource(@UnknownKeyFor @NonNull @Initialized Read<T> spec) {
            this.spec = spec;
        }

        public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized UnboundedJmsSource<T>> split(@UnknownKeyFor @NonNull @Initialized int desiredNumSplits, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
            ArrayList<UnboundedJmsSource<T>> sources = new ArrayList<UnboundedJmsSource<T>>();
            if (this.spec.getTopic() != null) {
                sources.add(new UnboundedJmsSource<T>(this.spec));
            } else {
                for (int i = 0; i < desiredNumSplits; ++i) {
                    sources.add(new UnboundedJmsSource<T>(this.spec));
                }
            }
            return sources;
        }

        public @UnknownKeyFor @NonNull @Initialized UnboundedJmsReader<T> createReader(@UnknownKeyFor @NonNull @Initialized PipelineOptions options, @UnknownKeyFor @NonNull @Initialized JmsCheckpointMark checkpointMark) {
            return new UnboundedJmsReader(this, checkpointMark);
        }

        public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized JmsCheckpointMark> getCheckpointMarkCoder() {
            return SerializableCoder.of(JmsCheckpointMark.class);
        }

        public @UnknownKeyFor @NonNull @Initialized Coder<T> getOutputCoder() {
            return this.spec.getCoder();
        }
    }

    @FunctionalInterface
    public static interface MessageMapper<@UnknownKeyFor T>
    extends Serializable {
        public T mapMessage(@UnknownKeyFor @NonNull @Initialized Message var1) throws @UnknownKeyFor @NonNull @Initialized Exception;
    }

    @AutoValue
    public static abstract class Read<@UnknownKeyFor T>
    extends PTransform<PBegin, PCollection<T>> {
        abstract @Nullable @UnknownKeyFor @Initialized ConnectionFactory getConnectionFactory();

        abstract @Nullable @UnknownKeyFor @Initialized String getQueue();

        abstract @Nullable @UnknownKeyFor @Initialized String getTopic();

        abstract @Nullable @UnknownKeyFor @Initialized String getUsername();

        abstract @Nullable @UnknownKeyFor @Initialized String getPassword();

        abstract @UnknownKeyFor @NonNull @Initialized long getMaxNumRecords();

        abstract @Nullable @UnknownKeyFor @Initialized Duration getMaxReadTime();

        abstract @Nullable @UnknownKeyFor @Initialized MessageMapper<T> getMessageMapper();

        abstract @Nullable @UnknownKeyFor @Initialized Coder<T> getCoder();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> builder();

        public @UnknownKeyFor @NonNull @Initialized Read<T> withConnectionFactory(@UnknownKeyFor @NonNull @Initialized ConnectionFactory connectionFactory) {
            Preconditions.checkArgument((connectionFactory != null ? 1 : 0) != 0, (Object)"connectionFactory can not be null");
            return this.builder().setConnectionFactory(connectionFactory).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withQueue(@UnknownKeyFor @NonNull @Initialized String queue) {
            Preconditions.checkArgument((queue != null ? 1 : 0) != 0, (Object)"queue can not be null");
            return this.builder().setQueue(queue).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withTopic(@UnknownKeyFor @NonNull @Initialized String topic) {
            Preconditions.checkArgument((topic != null ? 1 : 0) != 0, (Object)"topic can not be null");
            return this.builder().setTopic(topic).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withUsername(@UnknownKeyFor @NonNull @Initialized String username) {
            Preconditions.checkArgument((username != null ? 1 : 0) != 0, (Object)"username can not be null");
            return this.builder().setUsername(username).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withPassword(@UnknownKeyFor @NonNull @Initialized String password) {
            Preconditions.checkArgument((password != null ? 1 : 0) != 0, (Object)"password can not be null");
            return this.builder().setPassword(password).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withMaxNumRecords(@UnknownKeyFor @NonNull @Initialized long maxNumRecords) {
            Preconditions.checkArgument((maxNumRecords >= 0L ? 1 : 0) != 0, (String)"maxNumRecords must be > 0, but was: %s", (long)maxNumRecords);
            return this.builder().setMaxNumRecords(maxNumRecords).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withMaxReadTime(@UnknownKeyFor @NonNull @Initialized Duration maxReadTime) {
            Preconditions.checkArgument((maxReadTime != null ? 1 : 0) != 0, (Object)"maxReadTime can not be null");
            return this.builder().setMaxReadTime(maxReadTime).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withMessageMapper(@UnknownKeyFor @NonNull @Initialized MessageMapper<T> messageMapper) {
            Preconditions.checkArgument((messageMapper != null ? 1 : 0) != 0, (Object)"messageMapper can not be null");
            return this.builder().setMessageMapper(messageMapper).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
            Preconditions.checkArgument((coder != null ? 1 : 0) != 0, (Object)"coder can not be null");
            return this.builder().setCoder(coder).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            Read.Unbounded unbounded;
            Preconditions.checkArgument((this.getConnectionFactory() != null ? 1 : 0) != 0, (Object)"withConnectionFactory() is required");
            Preconditions.checkArgument((this.getQueue() != null || this.getTopic() != null ? 1 : 0) != 0, (Object)"Either withQueue() or withTopic() is required");
            Preconditions.checkArgument((this.getQueue() == null || this.getTopic() == null ? 1 : 0) != 0, (Object)"withQueue() and withTopic() are exclusive");
            Preconditions.checkArgument((this.getMessageMapper() != null ? 1 : 0) != 0, (Object)"withMessageMapper() is required");
            Preconditions.checkArgument((this.getCoder() != null ? 1 : 0) != 0, (Object)"withCoder() is required");
            Read.Unbounded transform = unbounded = org.apache.beam.sdk.io.Read.from(this.createSource());
            if (this.getMaxNumRecords() < Long.MAX_VALUE || this.getMaxReadTime() != null) {
                transform = unbounded.withMaxReadTime(this.getMaxReadTime()).withMaxNumRecords(this.getMaxNumRecords());
            }
            return (PCollection)input.getPipeline().apply((PTransform)transform);
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.addIfNotNull(DisplayData.item((String)"queue", (String)this.getQueue()));
            builder.addIfNotNull(DisplayData.item((String)"topic", (String)this.getTopic()));
        }

        @UnknownKeyFor @NonNull @Initialized UnboundedSource<T, @UnknownKeyFor @NonNull @Initialized JmsCheckpointMark> createSource() {
            return new UnboundedJmsSource(this);
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor T> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setConnectionFactory(@UnknownKeyFor @NonNull @Initialized ConnectionFactory var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setQueue(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setTopic(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setUsername(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setPassword(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setMaxNumRecords(@UnknownKeyFor @NonNull @Initialized long var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setMaxReadTime(@UnknownKeyFor @NonNull @Initialized Duration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setMessageMapper(@UnknownKeyFor @NonNull @Initialized MessageMapper<T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Read<T> build();
        }
    }
}

