/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.jms;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.jms.AutoValue_JmsIO_Read;
import org.apache.beam.sdk.io.jms.AutoValue_JmsIO_Write;
import org.apache.beam.sdk.io.jms.JmsCheckpointMark;
import org.apache.beam.sdk.io.jms.JmsRecord;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdks.java.io.jms.repackaged.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.sdks.java.io.jms.repackaged.com.google.common.base.Preconditions;
import org.joda.time.Duration;
import org.joda.time.Instant;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class JmsIO {
    public static Read<JmsRecord> read() {
        return new AutoValue_JmsIO_Read.Builder().setMaxNumRecords(Long.MAX_VALUE).setCoder(SerializableCoder.of(JmsRecord.class)).setMessageMapper(new MessageMapper<JmsRecord>(){

            @Override
            public JmsRecord mapMessage(Message message) throws Exception {
                TextMessage textMessage = (TextMessage)message;
                HashMap<String, Object> properties = new HashMap<String, Object>();
                Enumeration propertyNames = textMessage.getPropertyNames();
                while (propertyNames.hasMoreElements()) {
                    String propertyName = (String)propertyNames.nextElement();
                    properties.put(propertyName, textMessage.getObjectProperty(propertyName));
                }
                JmsRecord jmsRecord = new JmsRecord(textMessage.getJMSMessageID(), textMessage.getJMSTimestamp(), textMessage.getJMSCorrelationID(), textMessage.getJMSReplyTo(), textMessage.getJMSDestination(), textMessage.getJMSDeliveryMode(), textMessage.getJMSRedelivered(), textMessage.getJMSType(), textMessage.getJMSExpiration(), textMessage.getJMSPriority(), properties, textMessage.getText());
                return jmsRecord;
            }
        }).build();
    }

    public static <T> Read<T> readMessage() {
        return new AutoValue_JmsIO_Read.Builder().setMaxNumRecords(Long.MAX_VALUE).build();
    }

    public static Write write() {
        return new AutoValue_JmsIO_Write.Builder().build();
    }

    private JmsIO() {
    }

    @AutoValue
    public static abstract class Write
    extends PTransform<PCollection<String>, PDone> {
        @Nullable
        abstract ConnectionFactory getConnectionFactory();

        @Nullable
        abstract String getQueue();

        @Nullable
        abstract String getTopic();

        @Nullable
        abstract String getUsername();

        @Nullable
        abstract String getPassword();

        abstract Builder builder();

        public Write withConnectionFactory(ConnectionFactory connectionFactory) {
            Preconditions.checkArgument(connectionFactory != null, "connectionFactory can not be null");
            return this.builder().setConnectionFactory(connectionFactory).build();
        }

        public Write withQueue(String queue) {
            Preconditions.checkArgument(queue != null, "queue can not be null");
            return this.builder().setQueue(queue).build();
        }

        public Write withTopic(String topic) {
            Preconditions.checkArgument(topic != null, "topic can not be null");
            return this.builder().setTopic(topic).build();
        }

        public Write withUsername(String username) {
            Preconditions.checkArgument(username != null, "username can not be null");
            return this.builder().setUsername(username).build();
        }

        public Write withPassword(String password) {
            Preconditions.checkArgument(password != null, "password can not be null");
            return this.builder().setPassword(password).build();
        }

        public PDone expand(PCollection<String> input) {
            Preconditions.checkArgument(this.getConnectionFactory() != null, "withConnectionFactory() is required");
            Preconditions.checkArgument(this.getQueue() != null || this.getTopic() != null, "Either withQueue(queue) or withTopic(topic) is required");
            Preconditions.checkArgument(this.getQueue() == null || this.getTopic() == null, "withQueue(queue) and withTopic(topic) are exclusive");
            input.apply((PTransform)ParDo.of((DoFn)new WriterFn(this)));
            return PDone.in((Pipeline)input.getPipeline());
        }

        private static class WriterFn
        extends DoFn<String, Void> {
            private Write spec;
            private Connection connection;
            private Session session;
            private MessageProducer producer;

            public WriterFn(Write spec) {
                this.spec = spec;
            }

            @DoFn.Setup
            public void setup() throws Exception {
                if (this.producer == null) {
                    this.connection = this.spec.getUsername() != null ? this.spec.getConnectionFactory().createConnection(this.spec.getUsername(), this.spec.getPassword()) : this.spec.getConnectionFactory().createConnection();
                    this.connection.start();
                    this.session = this.connection.createSession(false, 1);
                    Object destination = this.spec.getQueue() != null ? this.session.createQueue(this.spec.getQueue()) : this.session.createTopic(this.spec.getTopic());
                    this.producer = this.session.createProducer((Destination)destination);
                }
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext ctx) throws Exception {
                String value = (String)ctx.element();
                TextMessage message = this.session.createTextMessage(value);
                this.producer.send((Message)message);
            }

            @DoFn.Teardown
            public void teardown() throws Exception {
                this.producer.close();
                this.producer = null;
                this.session.close();
                this.session = null;
                this.connection.stop();
                this.connection.close();
                this.connection = null;
            }
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setConnectionFactory(ConnectionFactory var1);

            abstract Builder setQueue(String var1);

            abstract Builder setTopic(String var1);

            abstract Builder setUsername(String var1);

            abstract Builder setPassword(String var1);

            abstract Write build();
        }
    }

    @VisibleForTesting
    static class UnboundedJmsReader<T>
    extends UnboundedSource.UnboundedReader<T> {
        private UnboundedJmsSource<T> source;
        private JmsCheckpointMark checkpointMark;
        private Connection connection;
        private Session session;
        private MessageConsumer consumer;
        private T currentMessage;
        private Instant currentTimestamp;

        public UnboundedJmsReader(UnboundedJmsSource<T> source, JmsCheckpointMark checkpointMark) {
            this.source = source;
            this.checkpointMark = checkpointMark != null ? checkpointMark : new JmsCheckpointMark();
            this.currentMessage = null;
        }

        public boolean start() throws IOException {
            Read spec = ((UnboundedJmsSource)this.source).spec;
            ConnectionFactory connectionFactory = spec.getConnectionFactory();
            try {
                Connection connection = spec.getUsername() != null ? connectionFactory.createConnection(spec.getUsername(), spec.getPassword()) : connectionFactory.createConnection();
                connection.start();
                this.connection = connection;
            }
            catch (Exception e) {
                throw new IOException("Error connecting to JMS", e);
            }
            try {
                this.session = this.connection.createSession(false, 2);
            }
            catch (Exception e) {
                throw new IOException("Error creating JMS session", e);
            }
            try {
                this.consumer = spec.getTopic() != null ? this.session.createConsumer((Destination)this.session.createTopic(spec.getTopic())) : this.session.createConsumer((Destination)this.session.createQueue(spec.getQueue()));
            }
            catch (Exception e) {
                throw new IOException("Error creating JMS consumer", e);
            }
            return this.advance();
        }

        public boolean advance() throws IOException {
            try {
                Message message = this.consumer.receiveNoWait();
                if (message == null) {
                    this.currentMessage = null;
                    return false;
                }
                this.checkpointMark.addMessage(message);
                this.currentMessage = ((UnboundedJmsSource)this.source).spec.getMessageMapper().mapMessage(message);
                this.currentTimestamp = new Instant(message.getJMSTimestamp());
                return true;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        public T getCurrent() throws NoSuchElementException {
            if (this.currentMessage == null) {
                throw new NoSuchElementException();
            }
            return this.currentMessage;
        }

        public Instant getWatermark() {
            return this.checkpointMark.getOldestPendingTimestamp();
        }

        public Instant getCurrentTimestamp() {
            if (this.currentMessage == null) {
                throw new NoSuchElementException();
            }
            return this.currentTimestamp;
        }

        public UnboundedSource.CheckpointMark getCheckpointMark() {
            return this.checkpointMark;
        }

        public UnboundedSource<T, ?> getCurrentSource() {
            return this.source;
        }

        public void close() throws IOException {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                    this.consumer = null;
                }
                if (this.session != null) {
                    this.session.close();
                    this.session = null;
                }
                if (this.connection != null) {
                    this.connection.stop();
                    this.connection.close();
                    this.connection = null;
                }
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    @VisibleForTesting
    protected static class UnboundedJmsSource<T>
    extends UnboundedSource<T, JmsCheckpointMark> {
        private final Read<T> spec;

        public UnboundedJmsSource(Read<T> spec) {
            this.spec = spec;
        }

        public List<UnboundedJmsSource<T>> split(int desiredNumSplits, PipelineOptions options) throws Exception {
            ArrayList<UnboundedJmsSource<T>> sources = new ArrayList<UnboundedJmsSource<T>>();
            if (this.spec.getTopic() != null) {
                sources.add(new UnboundedJmsSource<T>(this.spec));
            } else {
                for (int i = 0; i < desiredNumSplits; ++i) {
                    sources.add(new UnboundedJmsSource<T>(this.spec));
                }
            }
            return sources;
        }

        public UnboundedJmsReader<T> createReader(PipelineOptions options, JmsCheckpointMark checkpointMark) {
            return new UnboundedJmsReader(this, checkpointMark);
        }

        public Coder<JmsCheckpointMark> getCheckpointMarkCoder() {
            return AvroCoder.of(JmsCheckpointMark.class);
        }

        public Coder<T> getOutputCoder() {
            return this.spec.getCoder();
        }
    }

    @FunctionalInterface
    public static interface MessageMapper<T>
    extends Serializable {
        public T mapMessage(Message var1) throws Exception;
    }

    @AutoValue
    public static abstract class Read<T>
    extends PTransform<PBegin, PCollection<T>> {
        @Nullable
        abstract ConnectionFactory getConnectionFactory();

        @Nullable
        abstract String getQueue();

        @Nullable
        abstract String getTopic();

        @Nullable
        abstract String getUsername();

        @Nullable
        abstract String getPassword();

        abstract long getMaxNumRecords();

        @Nullable
        abstract Duration getMaxReadTime();

        @Nullable
        abstract MessageMapper<T> getMessageMapper();

        @Nullable
        abstract Coder<T> getCoder();

        abstract Builder<T> builder();

        public Read<T> withConnectionFactory(ConnectionFactory connectionFactory) {
            Preconditions.checkArgument(connectionFactory != null, "connectionFactory can not be null");
            return this.builder().setConnectionFactory(connectionFactory).build();
        }

        public Read<T> withQueue(String queue) {
            Preconditions.checkArgument(queue != null, "queue can not be null");
            return this.builder().setQueue(queue).build();
        }

        public Read<T> withTopic(String topic) {
            Preconditions.checkArgument(topic != null, "topic can not be null");
            return this.builder().setTopic(topic).build();
        }

        public Read<T> withUsername(String username) {
            Preconditions.checkArgument(username != null, "username can not be null");
            return this.builder().setUsername(username).build();
        }

        public Read<T> withPassword(String password) {
            Preconditions.checkArgument(password != null, "password can not be null");
            return this.builder().setPassword(password).build();
        }

        public Read<T> withMaxNumRecords(long maxNumRecords) {
            Preconditions.checkArgument(maxNumRecords >= 0L, "maxNumRecords must be > 0, but was: %d", maxNumRecords);
            return this.builder().setMaxNumRecords(maxNumRecords).build();
        }

        public Read<T> withMaxReadTime(Duration maxReadTime) {
            Preconditions.checkArgument(maxReadTime != null, "maxReadTime can not be null");
            return this.builder().setMaxReadTime(maxReadTime).build();
        }

        public Read<T> withMessageMapper(MessageMapper<T> messageMapper) {
            Preconditions.checkArgument(messageMapper != null, "messageMapper can not be null");
            return this.builder().setMessageMapper(messageMapper).build();
        }

        public Read<T> withCoder(Coder<T> coder) {
            Preconditions.checkArgument(coder != null, "coder can not be null");
            return this.builder().setCoder(coder).build();
        }

        public PCollection<T> expand(PBegin input) {
            Read.Unbounded unbounded;
            Preconditions.checkArgument(this.getConnectionFactory() != null, "withConnectionFactory() is required");
            Preconditions.checkArgument(this.getQueue() != null || this.getTopic() != null, "Either withQueue() or withTopic() is required");
            Preconditions.checkArgument(this.getQueue() == null || this.getTopic() == null, "withQueue() and withTopic() are exclusive");
            Preconditions.checkArgument(this.getMessageMapper() != null, "withMessageMapper() is required");
            Preconditions.checkArgument(this.getCoder() != null, "withCoder() is required");
            Read.Unbounded transform = unbounded = org.apache.beam.sdk.io.Read.from(this.createSource());
            if (this.getMaxNumRecords() < Long.MAX_VALUE || this.getMaxReadTime() != null) {
                transform = unbounded.withMaxReadTime(this.getMaxReadTime()).withMaxNumRecords(this.getMaxNumRecords());
            }
            return (PCollection)input.getPipeline().apply((PTransform)transform);
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.addIfNotNull(DisplayData.item((String)"queue", (String)this.getQueue()));
            builder.addIfNotNull(DisplayData.item((String)"topic", (String)this.getTopic()));
        }

        @VisibleForTesting
        UnboundedSource<T, JmsCheckpointMark> createSource() {
            return new UnboundedJmsSource(this);
        }

        @AutoValue.Builder
        static abstract class Builder<T> {
            Builder() {
            }

            abstract Builder<T> setConnectionFactory(ConnectionFactory var1);

            abstract Builder<T> setQueue(String var1);

            abstract Builder<T> setTopic(String var1);

            abstract Builder<T> setUsername(String var1);

            abstract Builder<T> setPassword(String var1);

            abstract Builder<T> setMaxNumRecords(long var1);

            abstract Builder<T> setMaxReadTime(Duration var1);

            abstract Builder<T> setMessageMapper(MessageMapper<T> var1);

            abstract Builder<T> setCoder(Coder<T> var1);

            abstract Read<T> build();
        }
    }
}

