/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.jms;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import javax.jms.Destination;
import org.checkerframework.checker.nullness.qual.Nullable;

public class JmsRecord
implements Serializable {
    private final @Nullable String jmsMessageID;
    private final long jmsTimestamp;
    private final String jmsCorrelationID;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"})
    private final @Nullable Destination jmsReplyTo;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"})
    private final Destination jmsDestination;
    private final int jmsDeliveryMode;
    private final boolean jmsRedelivered;
    private final String jmsType;
    private final long jmsExpiration;
    private final int jmsPriority;
    private final Map<String, Object> properties;
    private final String text;

    public JmsRecord(@Nullable String jmsMessageID, long jmsTimestamp, String jmsCorrelationID, @Nullable Destination jmsReplyTo, Destination jmsDestination, int jmsDeliveryMode, boolean jmsRedelivered, String jmsType, long jmsExpiration, int jmsPriority, Map<String, Object> properties, String text) {
        this.jmsMessageID = jmsMessageID;
        this.jmsTimestamp = jmsTimestamp;
        this.jmsCorrelationID = jmsCorrelationID;
        this.jmsReplyTo = jmsReplyTo;
        this.jmsDestination = jmsDestination;
        this.jmsDeliveryMode = jmsDeliveryMode;
        this.jmsRedelivered = jmsRedelivered;
        this.jmsType = jmsType;
        this.jmsExpiration = jmsExpiration;
        this.jmsPriority = jmsPriority;
        this.properties = properties;
        this.text = text;
    }

    public String getJmsMessageID() {
        return this.jmsMessageID;
    }

    public long getJmsTimestamp() {
        return this.jmsTimestamp;
    }

    public String getJmsCorrelationID() {
        return this.jmsCorrelationID;
    }

    public @Nullable Destination getJmsReplyTo() {
        return this.jmsReplyTo;
    }

    public Destination getJmsDestination() {
        return this.jmsDestination;
    }

    public int getJmsDeliveryMode() {
        return this.jmsDeliveryMode;
    }

    public boolean getJmsRedelivered() {
        return this.jmsRedelivered;
    }

    public String getJmsType() {
        return this.jmsType;
    }

    public long getJmsExpiration() {
        return this.jmsExpiration;
    }

    public int getJmsPriority() {
        return this.jmsPriority;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public String getPayload() {
        return this.text;
    }

    public int hashCode() {
        return Objects.hash(this.jmsMessageID, this.jmsTimestamp, this.jmsCorrelationID, this.jmsReplyTo, this.jmsDestination, this.jmsDeliveryMode, this.jmsRedelivered, this.jmsType, this.jmsExpiration, this.jmsPriority, this.properties, this.text);
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof JmsRecord) {
            JmsRecord other = (JmsRecord)obj;
            return this.jmsDestination.equals(other.jmsDestination) && this.jmsDeliveryMode == other.jmsDeliveryMode && this.jmsRedelivered == other.jmsRedelivered && this.jmsExpiration == other.jmsExpiration && this.jmsPriority == other.jmsPriority && this.properties.equals(other.properties) && this.text.equals(other.text);
        }
        return false;
    }
}

