/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.jms;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.jms.Message;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JmsCheckpointMark
implements UnboundedSource.CheckpointMark,
Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(JmsCheckpointMark.class);
    private Instant oldestMessageTimestamp = Instant.now();
    private transient List<Message> messages = new ArrayList<Message>();
    @VisibleForTesting
    transient boolean discarded = false;
    @VisibleForTesting
    final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    JmsCheckpointMark() {
    }

    void add(Message message) throws Exception {
        this.lock.writeLock().lock();
        try {
            if (this.discarded) {
                throw new IllegalStateException(String.format("Attempting to add message %s to checkpoint that is discarded.", message));
            }
            Instant currentMessageTimestamp = new Instant(message.getJMSTimestamp());
            if (currentMessageTimestamp.isBefore((ReadableInstant)this.oldestMessageTimestamp)) {
                this.oldestMessageTimestamp = currentMessageTimestamp;
            }
            this.messages.add(message);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    Instant getOldestMessageTimestamp() {
        this.lock.readLock().lock();
        try {
            Instant instant = this.oldestMessageTimestamp;
            return instant;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    void discard() {
        this.lock.writeLock().lock();
        try {
            this.discarded = true;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalizeCheckpoint() {
        this.lock.writeLock().lock();
        try {
            if (this.discarded) {
                this.messages.clear();
                return;
            }
            for (Message message : this.messages) {
                try {
                    message.acknowledge();
                    Instant currentMessageTimestamp = new Instant(message.getJMSTimestamp());
                    if (!currentMessageTimestamp.isAfter((ReadableInstant)this.oldestMessageTimestamp)) continue;
                    this.oldestMessageTimestamp = currentMessageTimestamp;
                }
                catch (Exception e) {
                    LOG.error("Exception while finalizing message: ", (Throwable)e);
                }
            }
            this.messages.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.messages = new ArrayList<Message>();
        this.discarded = false;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JmsCheckpointMark that = (JmsCheckpointMark)o;
        return this.oldestMessageTimestamp.equals((Object)that.oldestMessageTimestamp);
    }

    public int hashCode() {
        return Objects.hash(this.oldestMessageTimestamp);
    }
}

