/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.jms;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import javax.jms.Destination;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

public class JmsRecord
implements Serializable {
    private final @Nullable @UnknownKeyFor @Initialized String jmsMessageID;
    private final @UnknownKeyFor @NonNull @Initialized long jmsTimestamp;
    private final @UnknownKeyFor @NonNull @Initialized String jmsCorrelationID;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"})
    private final @Nullable @UnknownKeyFor @Initialized Destination jmsReplyTo;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"})
    private final @UnknownKeyFor @NonNull @Initialized Destination jmsDestination;
    private final @UnknownKeyFor @NonNull @Initialized int jmsDeliveryMode;
    private final @UnknownKeyFor @NonNull @Initialized boolean jmsRedelivered;
    private final @UnknownKeyFor @NonNull @Initialized String jmsType;
    private final @UnknownKeyFor @NonNull @Initialized long jmsExpiration;
    private final @UnknownKeyFor @NonNull @Initialized int jmsPriority;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> properties;
    private final @UnknownKeyFor @NonNull @Initialized String text;

    public JmsRecord(@Nullable @UnknownKeyFor @Initialized String jmsMessageID, @UnknownKeyFor @NonNull @Initialized long jmsTimestamp, @UnknownKeyFor @NonNull @Initialized String jmsCorrelationID, @Nullable @UnknownKeyFor @Initialized Destination jmsReplyTo, @UnknownKeyFor @NonNull @Initialized Destination jmsDestination, @UnknownKeyFor @NonNull @Initialized int jmsDeliveryMode, @UnknownKeyFor @NonNull @Initialized boolean jmsRedelivered, @UnknownKeyFor @NonNull @Initialized String jmsType, @UnknownKeyFor @NonNull @Initialized long jmsExpiration, @UnknownKeyFor @NonNull @Initialized int jmsPriority, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> properties, @UnknownKeyFor @NonNull @Initialized String text) {
        this.jmsMessageID = jmsMessageID;
        this.jmsTimestamp = jmsTimestamp;
        this.jmsCorrelationID = jmsCorrelationID;
        this.jmsReplyTo = jmsReplyTo;
        this.jmsDestination = jmsDestination;
        this.jmsDeliveryMode = jmsDeliveryMode;
        this.jmsRedelivered = jmsRedelivered;
        this.jmsType = jmsType;
        this.jmsExpiration = jmsExpiration;
        this.jmsPriority = jmsPriority;
        this.properties = properties;
        this.text = text;
    }

    public @UnknownKeyFor @NonNull @Initialized String getJmsMessageID() {
        return this.jmsMessageID;
    }

    public @UnknownKeyFor @NonNull @Initialized long getJmsTimestamp() {
        return this.jmsTimestamp;
    }

    public @UnknownKeyFor @NonNull @Initialized String getJmsCorrelationID() {
        return this.jmsCorrelationID;
    }

    public @Nullable @UnknownKeyFor @Initialized Destination getJmsReplyTo() {
        return this.jmsReplyTo;
    }

    public @UnknownKeyFor @NonNull @Initialized Destination getJmsDestination() {
        return this.jmsDestination;
    }

    public @UnknownKeyFor @NonNull @Initialized int getJmsDeliveryMode() {
        return this.jmsDeliveryMode;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean getJmsRedelivered() {
        return this.jmsRedelivered;
    }

    public @UnknownKeyFor @NonNull @Initialized String getJmsType() {
        return this.jmsType;
    }

    public @UnknownKeyFor @NonNull @Initialized long getJmsExpiration() {
        return this.jmsExpiration;
    }

    public @UnknownKeyFor @NonNull @Initialized int getJmsPriority() {
        return this.jmsPriority;
    }

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> getProperties() {
        return this.properties;
    }

    public @UnknownKeyFor @NonNull @Initialized String getPayload() {
        return this.text;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.jmsMessageID, this.jmsTimestamp, this.jmsCorrelationID, this.jmsReplyTo, this.jmsDestination, this.jmsDeliveryMode, this.jmsRedelivered, this.jmsType, this.jmsExpiration, this.jmsPriority, this.properties, this.text);
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
        if (obj instanceof JmsRecord) {
            JmsRecord other = (JmsRecord)obj;
            return this.jmsDestination.equals(other.jmsDestination) && this.jmsDeliveryMode == other.jmsDeliveryMode && this.jmsRedelivered == other.jmsRedelivered && this.jmsExpiration == other.jmsExpiration && this.jmsPriority == other.jmsPriority && this.properties.equals(other.properties) && this.text.equals(other.text);
        }
        return false;
    }
}

