/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.jms;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.beam.sdk.io.jms.JmsIOException;
import org.apache.beam.sdk.transforms.SerializableBiFunction;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class TextMessageMapper
implements SerializableBiFunction<String, Session, Message> {
    public @UnknownKeyFor @NonNull @Initialized Message apply(@UnknownKeyFor @NonNull @Initialized String value, @UnknownKeyFor @NonNull @Initialized Session session) {
        try {
            TextMessage msg = session.createTextMessage();
            msg.setText(value);
            return msg;
        }
        catch (JMSException e) {
            throw new JmsIOException("Error creating TextMessage", e);
        }
    }
}

