/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.jms;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JmsCheckpointMark
implements UnboundedSource.CheckpointMark,
Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(JmsCheckpointMark.class);
    private @UnknownKeyFor @NonNull @Initialized Instant oldestMessageTimestamp;
    private transient @Nullable @UnknownKeyFor @Initialized Message lastMessage;
    private transient @Nullable @UnknownKeyFor @Initialized MessageConsumer consumer;
    private transient @Nullable @UnknownKeyFor @Initialized Session session;

    private JmsCheckpointMark(@UnknownKeyFor @NonNull @Initialized Instant oldestMessageTimestamp, @Nullable @UnknownKeyFor @Initialized Message lastMessage, @Nullable @UnknownKeyFor @Initialized MessageConsumer consumer, @Nullable @UnknownKeyFor @Initialized Session session) {
        this.oldestMessageTimestamp = oldestMessageTimestamp;
        this.lastMessage = lastMessage;
        this.consumer = consumer;
        this.session = session;
    }

    public void finalizeCheckpoint() {
        try {
            if (this.lastMessage != null) {
                this.lastMessage.acknowledge();
            }
        }
        catch (JMSException e) {
            LOG.error("Failed to acknowledge the message. Will redeliver and might cause duplication.", (Throwable)e);
        }
        if (this.consumer != null) {
            try {
                this.consumer.close();
                this.consumer = null;
            }
            catch (JMSException e) {
                LOG.info("Error closing JMS consumer. It may have already been closed.");
            }
        }
        if (this.session != null) {
            try {
                this.session.close();
                this.session = null;
            }
            catch (JMSException e) {
                LOG.info("Error closing JMS session. It may have already been closed.");
            }
        }
    }

    private void readObject(@UnknownKeyFor @NonNull @Initialized ObjectInputStream stream) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized ClassNotFoundException {
        stream.defaultReadObject();
        this.lastMessage = null;
        this.session = null;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JmsCheckpointMark that = (JmsCheckpointMark)o;
        return this.oldestMessageTimestamp.equals((Object)that.oldestMessageTimestamp);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.oldestMessageTimestamp);
    }

    static @UnknownKeyFor @NonNull @Initialized Preparer newPreparer() {
        return new Preparer();
    }

    static class Preparer {
        private @UnknownKeyFor @NonNull @Initialized Instant oldestMessageTimestamp = Instant.now();
        private transient @Nullable @UnknownKeyFor @Initialized Message lastMessage = null;
        @VisibleForTesting
        transient @UnknownKeyFor @NonNull @Initialized boolean discarded = false;
        @VisibleForTesting
        final @UnknownKeyFor @NonNull @Initialized ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

        private Preparer() {
        }

        void add(@UnknownKeyFor @NonNull @Initialized Message message) throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.lock.writeLock().lock();
            try {
                if (this.discarded) {
                    throw new IllegalStateException(String.format("Attempting to add message %s to checkpoint that is discarded.", message));
                }
                Instant currentMessageTimestamp = new Instant(message.getJMSTimestamp());
                if (currentMessageTimestamp.isBefore((ReadableInstant)this.oldestMessageTimestamp)) {
                    this.oldestMessageTimestamp = currentMessageTimestamp;
                }
                this.lastMessage = message;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        @UnknownKeyFor @NonNull @Initialized Instant getOldestMessageTimestamp() {
            this.lock.readLock().lock();
            try {
                Instant instant = this.oldestMessageTimestamp;
                return instant;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        void discard() {
            this.lock.writeLock().lock();
            try {
                this.discarded = true;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @UnknownKeyFor @NonNull @Initialized JmsCheckpointMark newCheckpoint(@Nullable @UnknownKeyFor @Initialized MessageConsumer consumer, @Nullable @UnknownKeyFor @Initialized Session session) {
            JmsCheckpointMark checkpointMark;
            this.lock.writeLock().lock();
            try {
                if (this.discarded) {
                    this.lastMessage = null;
                    checkpointMark = this.emptyCheckpoint();
                } else {
                    checkpointMark = new JmsCheckpointMark(this.oldestMessageTimestamp, this.lastMessage, consumer, session);
                    this.lastMessage = null;
                    this.oldestMessageTimestamp = Instant.now();
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
            return checkpointMark;
        }

        @UnknownKeyFor @NonNull @Initialized JmsCheckpointMark emptyCheckpoint() {
            return new JmsCheckpointMark(this.oldestMessageTimestamp, null, null, null);
        }

        @UnknownKeyFor @NonNull @Initialized boolean isEmpty() {
            return this.lastMessage == null;
        }
    }
}

