/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.jms;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import org.apache.beam.sdk.io.jms.AutoValue_RetryConfiguration;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

@AutoValue
public abstract class RetryConfiguration
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized Integer DEFAULT_MAX_ATTEMPTS = 5;
    private static final @UnknownKeyFor @NonNull @Initialized Duration DEFAULT_INITIAL_BACKOFF = Duration.standardSeconds((long)15L);
    private static final @UnknownKeyFor @NonNull @Initialized Duration DEFAULT_MAX_CUMULATIVE_BACKOFF = Duration.standardDays((long)1000L);

    abstract @UnknownKeyFor @NonNull @Initialized int getMaxAttempts();

    abstract @Nullable @UnknownKeyFor @Initialized Duration getMaxDuration();

    abstract @Nullable @UnknownKeyFor @Initialized Duration getInitialDuration();

    public static @UnknownKeyFor @NonNull @Initialized RetryConfiguration create() {
        return RetryConfiguration.create(DEFAULT_MAX_ATTEMPTS, null, null);
    }

    public static @UnknownKeyFor @NonNull @Initialized RetryConfiguration create(@UnknownKeyFor @NonNull @Initialized int maxAttempts) {
        return RetryConfiguration.create(maxAttempts, null, null);
    }

    public static @UnknownKeyFor @NonNull @Initialized RetryConfiguration create(@UnknownKeyFor @NonNull @Initialized int maxAttempts, @Nullable @UnknownKeyFor @Initialized Duration maxDuration, @Nullable @UnknownKeyFor @Initialized Duration initialDuration) {
        Preconditions.checkArgument((maxAttempts > 0 ? 1 : 0) != 0, (Object)"maxAttempts should be greater than 0");
        if (maxDuration == null || maxDuration.equals((Object)Duration.ZERO)) {
            maxDuration = DEFAULT_MAX_CUMULATIVE_BACKOFF;
        }
        if (initialDuration == null || initialDuration.equals((Object)Duration.ZERO)) {
            initialDuration = DEFAULT_INITIAL_BACKOFF;
        }
        return new AutoValue_RetryConfiguration.Builder().setMaxAttempts(maxAttempts).setInitialDuration(initialDuration).setMaxDuration(maxDuration).build();
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized Builder setMaxAttempts(@UnknownKeyFor @NonNull @Initialized int var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setMaxDuration(@UnknownKeyFor @NonNull @Initialized Duration var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setInitialDuration(@UnknownKeyFor @NonNull @Initialized Duration var1);

        abstract @UnknownKeyFor @NonNull @Initialized RetryConfiguration build();
    }
}

