/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.jms;

import javax.jms.ConnectionFactory;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.jms.AutoScaler;
import org.apache.beam.sdk.io.jms.JmsIO;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;

final class AutoValue_JmsIO_Read<T>
extends JmsIO.Read<T> {
    private final @Nullable SerializableFunction<Void, ? extends ConnectionFactory> connectionFactoryProviderFn;
    private final @Nullable String queue;
    private final @Nullable String topic;
    private final @Nullable String username;
    private final @Nullable String password;
    private final long maxNumRecords;
    private final @Nullable Duration maxReadTime;
    private final  @Nullable JmsIO.MessageMapper<T> messageMapper;
    private final @Nullable Coder<T> coder;
    private final @Nullable AutoScaler autoScaler;
    private final Duration closeTimeout;
    private final @Nullable Duration receiveTimeout;
    private final boolean requiresDeduping;

    private AutoValue_JmsIO_Read(@Nullable SerializableFunction<Void, ? extends ConnectionFactory> connectionFactoryProviderFn, @Nullable String queue, @Nullable String topic, @Nullable String username, @Nullable String password, long maxNumRecords, @Nullable Duration maxReadTime,  @Nullable JmsIO.MessageMapper<T> messageMapper, @Nullable Coder<T> coder, @Nullable AutoScaler autoScaler, Duration closeTimeout, @Nullable Duration receiveTimeout, boolean requiresDeduping) {
        this.connectionFactoryProviderFn = connectionFactoryProviderFn;
        this.queue = queue;
        this.topic = topic;
        this.username = username;
        this.password = password;
        this.maxNumRecords = maxNumRecords;
        this.maxReadTime = maxReadTime;
        this.messageMapper = messageMapper;
        this.coder = coder;
        this.autoScaler = autoScaler;
        this.closeTimeout = closeTimeout;
        this.receiveTimeout = receiveTimeout;
        this.requiresDeduping = requiresDeduping;
    }

    @Override
    @Nullable SerializableFunction<Void, ? extends ConnectionFactory> getConnectionFactoryProviderFn() {
        return this.connectionFactoryProviderFn;
    }

    @Override
    @Nullable String getQueue() {
        return this.queue;
    }

    @Override
    @Nullable String getTopic() {
        return this.topic;
    }

    @Override
    @Nullable String getUsername() {
        return this.username;
    }

    @Override
    @Nullable String getPassword() {
        return this.password;
    }

    @Override
    long getMaxNumRecords() {
        return this.maxNumRecords;
    }

    @Override
    @Nullable Duration getMaxReadTime() {
        return this.maxReadTime;
    }

    @Override
     @Nullable JmsIO.MessageMapper<T> getMessageMapper() {
        return this.messageMapper;
    }

    @Override
    @Nullable Coder<T> getCoder() {
        return this.coder;
    }

    @Override
    @Nullable AutoScaler getAutoScaler() {
        return this.autoScaler;
    }

    @Override
    Duration getCloseTimeout() {
        return this.closeTimeout;
    }

    @Override
    @Nullable Duration getReceiveTimeout() {
        return this.receiveTimeout;
    }

    @Override
    boolean isRequiresDeduping() {
        return this.requiresDeduping;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof JmsIO.Read) {
            JmsIO.Read that = (JmsIO.Read)o;
            return (this.connectionFactoryProviderFn == null ? that.getConnectionFactoryProviderFn() == null : this.connectionFactoryProviderFn.equals(that.getConnectionFactoryProviderFn())) && (this.queue == null ? that.getQueue() == null : this.queue.equals(that.getQueue())) && (this.topic == null ? that.getTopic() == null : this.topic.equals(that.getTopic())) && (this.username == null ? that.getUsername() == null : this.username.equals(that.getUsername())) && (this.password == null ? that.getPassword() == null : this.password.equals(that.getPassword())) && this.maxNumRecords == that.getMaxNumRecords() && (this.maxReadTime == null ? that.getMaxReadTime() == null : this.maxReadTime.equals((Object)that.getMaxReadTime())) && (this.messageMapper == null ? that.getMessageMapper() == null : this.messageMapper.equals(that.getMessageMapper())) && (this.coder == null ? that.getCoder() == null : this.coder.equals(that.getCoder())) && (this.autoScaler == null ? that.getAutoScaler() == null : this.autoScaler.equals(that.getAutoScaler())) && this.closeTimeout.equals((Object)that.getCloseTimeout()) && (this.receiveTimeout == null ? that.getReceiveTimeout() == null : this.receiveTimeout.equals((Object)that.getReceiveTimeout())) && this.requiresDeduping == that.isRequiresDeduping();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.connectionFactoryProviderFn == null ? 0 : this.connectionFactoryProviderFn.hashCode();
        h$ *= 1000003;
        h$ ^= this.queue == null ? 0 : this.queue.hashCode();
        h$ *= 1000003;
        h$ ^= this.topic == null ? 0 : this.topic.hashCode();
        h$ *= 1000003;
        h$ ^= this.username == null ? 0 : this.username.hashCode();
        h$ *= 1000003;
        h$ ^= this.password == null ? 0 : this.password.hashCode();
        h$ *= 1000003;
        h$ ^= (int)(this.maxNumRecords >>> 32 ^ this.maxNumRecords);
        h$ *= 1000003;
        h$ ^= this.maxReadTime == null ? 0 : this.maxReadTime.hashCode();
        h$ *= 1000003;
        h$ ^= this.messageMapper == null ? 0 : this.messageMapper.hashCode();
        h$ *= 1000003;
        h$ ^= this.coder == null ? 0 : this.coder.hashCode();
        h$ *= 1000003;
        h$ ^= this.autoScaler == null ? 0 : this.autoScaler.hashCode();
        h$ *= 1000003;
        h$ ^= this.closeTimeout.hashCode();
        h$ *= 1000003;
        h$ ^= this.receiveTimeout == null ? 0 : this.receiveTimeout.hashCode();
        h$ *= 1000003;
        return h$ ^= this.requiresDeduping ? 1231 : 1237;
    }

    @Override
    JmsIO.Read.Builder<T> builder() {
        return new Builder(this);
    }

    static final class Builder<T>
    extends JmsIO.Read.Builder<T> {
        private @Nullable SerializableFunction<Void, ? extends ConnectionFactory> connectionFactoryProviderFn;
        private @Nullable String queue;
        private @Nullable String topic;
        private @Nullable String username;
        private @Nullable String password;
        private Long maxNumRecords;
        private @Nullable Duration maxReadTime;
        private  @Nullable JmsIO.MessageMapper<T> messageMapper;
        private @Nullable Coder<T> coder;
        private @Nullable AutoScaler autoScaler;
        private Duration closeTimeout;
        private @Nullable Duration receiveTimeout;
        private Boolean requiresDeduping;

        Builder() {
        }

        private Builder(JmsIO.Read<T> source) {
            this.connectionFactoryProviderFn = source.getConnectionFactoryProviderFn();
            this.queue = source.getQueue();
            this.topic = source.getTopic();
            this.username = source.getUsername();
            this.password = source.getPassword();
            this.maxNumRecords = source.getMaxNumRecords();
            this.maxReadTime = source.getMaxReadTime();
            this.messageMapper = source.getMessageMapper();
            this.coder = source.getCoder();
            this.autoScaler = source.getAutoScaler();
            this.closeTimeout = source.getCloseTimeout();
            this.receiveTimeout = source.getReceiveTimeout();
            this.requiresDeduping = source.isRequiresDeduping();
        }

        @Override
        JmsIO.Read.Builder<T> setConnectionFactoryProviderFn(SerializableFunction<Void, ? extends ConnectionFactory> connectionFactoryProviderFn) {
            this.connectionFactoryProviderFn = connectionFactoryProviderFn;
            return this;
        }

        @Override
        JmsIO.Read.Builder<T> setQueue(String queue) {
            this.queue = queue;
            return this;
        }

        @Override
        JmsIO.Read.Builder<T> setTopic(String topic) {
            this.topic = topic;
            return this;
        }

        @Override
        JmsIO.Read.Builder<T> setUsername(String username) {
            this.username = username;
            return this;
        }

        @Override
        JmsIO.Read.Builder<T> setPassword(String password) {
            this.password = password;
            return this;
        }

        @Override
        JmsIO.Read.Builder<T> setMaxNumRecords(long maxNumRecords) {
            this.maxNumRecords = maxNumRecords;
            return this;
        }

        @Override
        JmsIO.Read.Builder<T> setMaxReadTime(Duration maxReadTime) {
            this.maxReadTime = maxReadTime;
            return this;
        }

        @Override
        JmsIO.Read.Builder<T> setMessageMapper(JmsIO.MessageMapper<T> messageMapper) {
            this.messageMapper = messageMapper;
            return this;
        }

        @Override
        JmsIO.Read.Builder<T> setCoder(Coder<T> coder) {
            this.coder = coder;
            return this;
        }

        @Override
        JmsIO.Read.Builder<T> setAutoScaler(AutoScaler autoScaler) {
            this.autoScaler = autoScaler;
            return this;
        }

        @Override
        JmsIO.Read.Builder<T> setCloseTimeout(Duration closeTimeout) {
            if (closeTimeout == null) {
                throw new NullPointerException("Null closeTimeout");
            }
            this.closeTimeout = closeTimeout;
            return this;
        }

        @Override
        JmsIO.Read.Builder<T> setReceiveTimeout(Duration receiveTimeout) {
            this.receiveTimeout = receiveTimeout;
            return this;
        }

        @Override
        JmsIO.Read.Builder<T> setRequiresDeduping(boolean requiresDeduping) {
            this.requiresDeduping = requiresDeduping;
            return this;
        }

        @Override
        JmsIO.Read<T> build() {
            if (this.maxNumRecords == null || this.closeTimeout == null || this.requiresDeduping == null) {
                StringBuilder missing = new StringBuilder();
                if (this.maxNumRecords == null) {
                    missing.append(" maxNumRecords");
                }
                if (this.closeTimeout == null) {
                    missing.append(" closeTimeout");
                }
                if (this.requiresDeduping == null) {
                    missing.append(" requiresDeduping");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_JmsIO_Read(this.connectionFactoryProviderFn, this.queue, this.topic, this.username, this.password, this.maxNumRecords, this.maxReadTime, this.messageMapper, this.coder, this.autoScaler, this.closeTimeout, this.receiveTimeout, this.requiresDeduping);
        }
    }
}

