/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.kafka.AutoValue_KafkaSourceDescriptor;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.annotations.SchemaCreate;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldName;
import org.apache.beam.sdk.schemas.annotations.SchemaIgnore;
import org.apache.kafka.common.TopicPartition;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

@DefaultSchema(value=AutoValueSchema.class)
@AutoValue
public abstract class KafkaSourceDescriptor
implements Serializable {
    private @UnknownKeyFor @NonNull @Initialized TopicPartition topicPartition = null;

    @SchemaFieldName(value="topic")
    abstract @UnknownKeyFor @NonNull @Initialized String getTopic();

    @SchemaFieldName(value="partition")
    abstract @UnknownKeyFor @NonNull @Initialized Integer getPartition();

    @SchemaFieldName(value="start_read_offset")
    @Nullable
    abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Long getStartReadOffset();

    @SchemaFieldName(value="start_read_time")
    @Nullable
    abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Instant getStartReadTime();

    @SchemaFieldName(value="bootstrap_servers")
    @Nullable
    abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getBootStrapServers();

    @SchemaIgnore
    public @UnknownKeyFor @NonNull @Initialized TopicPartition getTopicPartition() {
        if (this.topicPartition == null) {
            this.topicPartition = new TopicPartition(this.getTopic(), this.getPartition().intValue());
        }
        return this.topicPartition;
    }

    public static @UnknownKeyFor @NonNull @Initialized KafkaSourceDescriptor of(@UnknownKeyFor @NonNull @Initialized TopicPartition topicPartition, @UnknownKeyFor @NonNull @Initialized Long startReadOffset, @UnknownKeyFor @NonNull @Initialized Instant startReadTime, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> bootstrapServers) {
        return new AutoValue_KafkaSourceDescriptor(topicPartition.topic(), topicPartition.partition(), startReadOffset, startReadTime, bootstrapServers);
    }

    @SchemaCreate
    static @UnknownKeyFor @NonNull @Initialized KafkaSourceDescriptor create(@UnknownKeyFor @NonNull @Initialized String topic, @UnknownKeyFor @NonNull @Initialized Integer partition, @UnknownKeyFor @NonNull @Initialized Long start_read_offset, @UnknownKeyFor @NonNull @Initialized Instant start_read_time, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> bootstrap_servers) {
        return new AutoValue_KafkaSourceDescriptor(topic, partition, start_read_offset, start_read_time, bootstrap_servers);
    }
}

