/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.io.requestresponse;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.auto.value.AutoValue;
import java.util.Optional;
import org.apache.beam.io.requestresponse.AutoValue_ApiIOError;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.annotations.SchemaCaseFormat;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.CaseFormat;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Throwables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

@SchemaCaseFormat(value=CaseFormat.LOWER_UNDERSCORE)
@DefaultSchema(value=AutoValueSchema.class)
@AutoValue
public abstract class ApiIOError {
    private static final @UnknownKeyFor @NonNull @Initialized ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    static <T, ErrorT extends Exception> @UnknownKeyFor @NonNull @Initialized ApiIOError of(ErrorT e, T element) throws @UnknownKeyFor @NonNull @Initialized JsonProcessingException {
        String json = OBJECT_MAPPER.writeValueAsString(Preconditions.checkStateNotNull(element));
        return ApiIOError.builder().setRequestAsJsonString(json).setMessage(Optional.ofNullable(e.getMessage()).orElse("")).setObservedTimestamp(Instant.now()).setStackTrace(Throwables.getStackTraceAsString(e)).build();
    }

    static @UnknownKeyFor @NonNull @Initialized Builder builder() {
        return new AutoValue_ApiIOError.Builder();
    }

    public abstract @UnknownKeyFor @NonNull @Initialized String getRequestAsJsonString();

    public abstract @UnknownKeyFor @NonNull @Initialized Instant getObservedTimestamp();

    public abstract @UnknownKeyFor @NonNull @Initialized String getMessage();

    public abstract @UnknownKeyFor @NonNull @Initialized String getStackTrace();

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized Builder setRequestAsJsonString(@UnknownKeyFor @NonNull @Initialized String var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setObservedTimestamp(@UnknownKeyFor @NonNull @Initialized Instant var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setMessage(@UnknownKeyFor @NonNull @Initialized String var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setStackTrace(@UnknownKeyFor @NonNull @Initialized String var1);

        abstract @UnknownKeyFor @NonNull @Initialized ApiIOError build();
    }
}

