/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.io.requestresponse;

import java.util.Optional;
import org.apache.beam.io.requestresponse.Repeater;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.util.BackOff;
import org.apache.beam.sdk.util.Sleeper;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AutoValue_Repeater<InputT, OutputT>
extends Repeater<InputT, OutputT> {
    private final Repeater.ThrowableFunction<InputT, OutputT> throwableFunction;
    private final Sleeper sleeper;
    private final BackOff backOff;
    private final @Nullable Counter callCounter;
    private final @Nullable Counter backoffCounter;
    private final @Nullable Counter sleeperCounter;

    private AutoValue_Repeater(Repeater.ThrowableFunction<InputT, OutputT> throwableFunction, Sleeper sleeper, BackOff backOff, @Nullable Counter callCounter, @Nullable Counter backoffCounter, @Nullable Counter sleeperCounter) {
        this.throwableFunction = throwableFunction;
        this.sleeper = sleeper;
        this.backOff = backOff;
        this.callCounter = callCounter;
        this.backoffCounter = backoffCounter;
        this.sleeperCounter = sleeperCounter;
    }

    @Override
    Repeater.ThrowableFunction<InputT, OutputT> getThrowableFunction() {
        return this.throwableFunction;
    }

    @Override
    Sleeper getSleeper() {
        return this.sleeper;
    }

    @Override
    BackOff getBackOff() {
        return this.backOff;
    }

    @Override
    @Nullable Counter getCallCounter() {
        return this.callCounter;
    }

    @Override
    @Nullable Counter getBackoffCounter() {
        return this.backoffCounter;
    }

    @Override
    @Nullable Counter getSleeperCounter() {
        return this.sleeperCounter;
    }

    public String toString() {
        return "Repeater{throwableFunction=" + this.throwableFunction + ", sleeper=" + this.sleeper + ", backOff=" + this.backOff + ", callCounter=" + this.callCounter + ", backoffCounter=" + this.backoffCounter + ", sleeperCounter=" + this.sleeperCounter + "}";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Repeater) {
            Repeater that = (Repeater)o;
            return this.throwableFunction.equals(that.getThrowableFunction()) && this.sleeper.equals(that.getSleeper()) && this.backOff.equals(that.getBackOff()) && (this.callCounter == null ? that.getCallCounter() == null : this.callCounter.equals(that.getCallCounter())) && (this.backoffCounter == null ? that.getBackoffCounter() == null : this.backoffCounter.equals(that.getBackoffCounter())) && (this.sleeperCounter == null ? that.getSleeperCounter() == null : this.sleeperCounter.equals(that.getSleeperCounter()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.throwableFunction.hashCode();
        h$ *= 1000003;
        h$ ^= this.sleeper.hashCode();
        h$ *= 1000003;
        h$ ^= this.backOff.hashCode();
        h$ *= 1000003;
        h$ ^= this.callCounter == null ? 0 : this.callCounter.hashCode();
        h$ *= 1000003;
        h$ ^= this.backoffCounter == null ? 0 : this.backoffCounter.hashCode();
        h$ *= 1000003;
        return h$ ^= this.sleeperCounter == null ? 0 : this.sleeperCounter.hashCode();
    }

    @Override
    Repeater.Builder<InputT, OutputT> toBuilder() {
        return new Builder(this);
    }

    static final class Builder<InputT, OutputT>
    extends Repeater.Builder<InputT, OutputT> {
        private Repeater.ThrowableFunction<InputT, OutputT> throwableFunction;
        private Sleeper sleeper;
        private BackOff backOff;
        private @Nullable Counter callCounter;
        private @Nullable Counter backoffCounter;
        private @Nullable Counter sleeperCounter;

        Builder() {
        }

        private Builder(Repeater<InputT, OutputT> source) {
            this.throwableFunction = source.getThrowableFunction();
            this.sleeper = source.getSleeper();
            this.backOff = source.getBackOff();
            this.callCounter = source.getCallCounter();
            this.backoffCounter = source.getBackoffCounter();
            this.sleeperCounter = source.getSleeperCounter();
        }

        @Override
        Repeater.Builder<InputT, OutputT> setThrowableFunction(Repeater.ThrowableFunction<InputT, OutputT> throwableFunction) {
            if (throwableFunction == null) {
                throw new NullPointerException("Null throwableFunction");
            }
            this.throwableFunction = throwableFunction;
            return this;
        }

        @Override
        Repeater.Builder<InputT, OutputT> setSleeper(Sleeper sleeper) {
            if (sleeper == null) {
                throw new NullPointerException("Null sleeper");
            }
            this.sleeper = sleeper;
            return this;
        }

        @Override
        Optional<Sleeper> getSleeper() {
            if (this.sleeper == null) {
                return Optional.empty();
            }
            return Optional.of(this.sleeper);
        }

        @Override
        Repeater.Builder<InputT, OutputT> setBackOff(BackOff backOff) {
            if (backOff == null) {
                throw new NullPointerException("Null backOff");
            }
            this.backOff = backOff;
            return this;
        }

        @Override
        Optional<BackOff> getBackOff() {
            if (this.backOff == null) {
                return Optional.empty();
            }
            return Optional.of(this.backOff);
        }

        @Override
        Repeater.Builder<InputT, OutputT> setCallCounter(Counter callCounter) {
            this.callCounter = callCounter;
            return this;
        }

        @Override
        Repeater.Builder<InputT, OutputT> setBackoffCounter(Counter backoffCounter) {
            this.backoffCounter = backoffCounter;
            return this;
        }

        @Override
        Repeater.Builder<InputT, OutputT> setSleeperCounter(Counter sleeperCounter) {
            this.sleeperCounter = sleeperCounter;
            return this;
        }

        @Override
        Repeater<InputT, OutputT> autoBuild() {
            if (this.throwableFunction == null || this.sleeper == null || this.backOff == null) {
                StringBuilder missing = new StringBuilder();
                if (this.throwableFunction == null) {
                    missing.append(" throwableFunction");
                }
                if (this.sleeper == null) {
                    missing.append(" sleeper");
                }
                if (this.backOff == null) {
                    missing.append(" backOff");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_Repeater(this.throwableFunction, this.sleeper, this.backOff, this.callCounter, this.backoffCounter, this.sleeperCounter);
        }
    }
}

