/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.io.requestresponse;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import org.apache.beam.io.requestresponse.Call;
import org.apache.beam.io.requestresponse.Caller;
import org.apache.beam.io.requestresponse.RedisClient;
import org.apache.beam.io.requestresponse.Result;
import org.apache.beam.io.requestresponse.SetupTeardown;
import org.apache.beam.io.requestresponse.UserCodeExecutionException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.ByteSource;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

public final class Cache {
    public static <RequestT, ResponseT> @UnknownKeyFor @NonNull @Initialized Pair<RequestT, ResponseT> usingRedis(@UnknownKeyFor @NonNull @Initialized URI uri, @UnknownKeyFor @NonNull @Initialized Coder<RequestT> requestTCoder, @UnknownKeyFor @NonNull @Initialized Coder<ResponseT> responseTCoder, @UnknownKeyFor @NonNull @Initialized Duration expiry) throws // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
        PTransform<PCollection<RequestT>, Result<KV<RequestT, @Nullable ResponseT>>> read = Cache.readUsingRedis(new RedisClient(uri), requestTCoder, new CacheResponseCoder(responseTCoder));
        PTransform write = Cache.writeUsingRedis(expiry, new RedisClient(uri), requestTCoder, new CacheResponseCoder(responseTCoder));
        return Pair.of(read, write);
    }

    static <RequestT, ResponseT, CallerSetupTeardownT extends Caller<RequestT, KV<RequestT, ResponseT>> & SetupTeardown> @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<RequestT>, @UnknownKeyFor @NonNull @Initialized Result<@UnknownKeyFor @NonNull @Initialized KV<RequestT, @Nullable ResponseT>>> read(CallerSetupTeardownT implementsCallerSetupTeardown, @UnknownKeyFor @NonNull @Initialized Coder<RequestT> requestTCoder, @UnknownKeyFor @NonNull @Initialized Coder<@Nullable ResponseT> responseTCoder) {
        return Call.ofCallerAndSetupTeardown(implementsCallerSetupTeardown, KvCoder.of(requestTCoder, responseTCoder));
    }

    static <RequestT, ResponseT> @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<RequestT>, @UnknownKeyFor @NonNull @Initialized Result<@UnknownKeyFor @NonNull @Initialized KV<RequestT, @Nullable ResponseT>>> readUsingRedis(@UnknownKeyFor @NonNull @Initialized RedisClient client, @UnknownKeyFor @NonNull @Initialized Coder<RequestT> requestTCoder, @UnknownKeyFor @NonNull @Initialized Coder<@Nullable ResponseT> responseTCoder) throws // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
        return Cache.read(new UsingRedis(requestTCoder, responseTCoder, client).read(), requestTCoder, responseTCoder);
    }

    static <RequestT, ResponseT, CallerSetupTeardownT extends Caller<KV<RequestT, ResponseT>, KV<RequestT, ResponseT>> & SetupTeardown> @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<RequestT, ResponseT>>, @UnknownKeyFor @NonNull @Initialized Result<@UnknownKeyFor @NonNull @Initialized KV<RequestT, ResponseT>>> write(CallerSetupTeardownT implementsCallerSetupTeardown, @UnknownKeyFor @NonNull @Initialized KvCoder<RequestT, ResponseT> kvCoder) {
        return Call.ofCallerAndSetupTeardown(implementsCallerSetupTeardown, kvCoder);
    }

    static <RequestT, ResponseT> @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<RequestT, ResponseT>>, @UnknownKeyFor @NonNull @Initialized Result<@UnknownKeyFor @NonNull @Initialized KV<RequestT, ResponseT>>> writeUsingRedis(@UnknownKeyFor @NonNull @Initialized Duration expiry, @UnknownKeyFor @NonNull @Initialized RedisClient client, @UnknownKeyFor @NonNull @Initialized Coder<RequestT> requestTCoder, @UnknownKeyFor @NonNull @Initialized Coder<@Nullable ResponseT> responseTCoder) throws // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
        return Cache.write(new UsingRedis(requestTCoder, responseTCoder, client).write(expiry), KvCoder.of(requestTCoder, responseTCoder));
    }

    private static class CacheResponseCoder<@UnknownKeyFor ResponseT>
    extends CustomCoder<ResponseT> {
        private final @UnknownKeyFor @NonNull @Initialized NullableCoder<ResponseT> basis;

        private CacheResponseCoder(@UnknownKeyFor @NonNull @Initialized Coder<ResponseT> basis) {
            this.basis = NullableCoder.of(basis);
        }

        public void encode(@Nullable ResponseT value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            this.basis.encode(value, outStream);
        }

        public @Nullable ResponseT decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            return (ResponseT)this.basis.decode(inStream);
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
            return this.basis.getCoderArguments();
        }

        public void verifyDeterministic() throws // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
            this.basis.verifyDeterministic();
        }
    }

    private static class UsingRedis<@UnknownKeyFor RequestT, @UnknownKeyFor ResponseT> {
        private final @UnknownKeyFor @NonNull @Initialized Coder<RequestT> requestTCoder;
        private final @UnknownKeyFor @NonNull @Initialized Coder<@Nullable ResponseT> responseTCoder;
        private final @UnknownKeyFor @NonNull @Initialized RedisClient client;

        private UsingRedis(@UnknownKeyFor @NonNull @Initialized Coder<RequestT> requestTCoder, @UnknownKeyFor @NonNull @Initialized Coder<@Nullable ResponseT> responseTCoder, @UnknownKeyFor @NonNull @Initialized RedisClient client) throws // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
            this.client = client;
            requestTCoder.verifyDeterministic();
            responseTCoder.verifyDeterministic();
            this.requestTCoder = requestTCoder;
            this.responseTCoder = responseTCoder;
        }

        @UnknownKeyFor @NonNull @Initialized Read<RequestT, @Nullable ResponseT> read() {
            return new Read(this.requestTCoder, this.responseTCoder, this.client);
        }

        @UnknownKeyFor @NonNull @Initialized Write<RequestT, ResponseT> write(@UnknownKeyFor @NonNull @Initialized Duration expiry) {
            return new Write(expiry, this.requestTCoder, this.responseTCoder, this.client);
        }

        static class Write<@UnknownKeyFor RequestT, @UnknownKeyFor ResponseT>
        implements Caller<KV<RequestT, ResponseT>, KV<RequestT, ResponseT>>,
        SetupTeardown {
            private final @UnknownKeyFor @NonNull @Initialized Duration expiry;
            private final @UnknownKeyFor @NonNull @Initialized Coder<RequestT> requestTCoder;
            private final @UnknownKeyFor @NonNull @Initialized Coder<@Nullable ResponseT> responseTCoder;
            private final @UnknownKeyFor @NonNull @Initialized RedisClient client;

            private Write(@UnknownKeyFor @NonNull @Initialized Duration expiry, @UnknownKeyFor @NonNull @Initialized Coder<RequestT> requestTCoder, @UnknownKeyFor @NonNull @Initialized Coder<@Nullable ResponseT> responseTCoder, @UnknownKeyFor @NonNull @Initialized RedisClient client) {
                this.expiry = expiry;
                this.requestTCoder = requestTCoder;
                this.responseTCoder = responseTCoder;
                this.client = client;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized KV<RequestT, ResponseT> call(@UnknownKeyFor @NonNull @Initialized KV<RequestT, ResponseT> request) throws @UnknownKeyFor @NonNull @Initialized UserCodeExecutionException {
                ByteArrayOutputStream keyStream = new ByteArrayOutputStream();
                ByteArrayOutputStream valueStream = new ByteArrayOutputStream();
                try {
                    this.requestTCoder.encode(request.getKey(), (OutputStream)keyStream);
                    this.responseTCoder.encode(request.getValue(), (OutputStream)valueStream);
                }
                catch (IOException e) {
                    throw new UserCodeExecutionException(e);
                }
                this.client.setex(keyStream.toByteArray(), valueStream.toByteArray(), this.expiry);
                return request;
            }

            @Override
            public void setup() throws @UnknownKeyFor @NonNull @Initialized UserCodeExecutionException {
                this.client.setup();
            }

            @Override
            public void teardown() throws @UnknownKeyFor @NonNull @Initialized UserCodeExecutionException {
                this.client.teardown();
            }
        }

        static class Read<@UnknownKeyFor RequestT, @Nullable ResponseT>
        implements Caller<RequestT, KV<RequestT, ResponseT>>,
        SetupTeardown {
            private final @UnknownKeyFor @NonNull @Initialized Coder<RequestT> requestTCoder;
            private final @UnknownKeyFor @NonNull @Initialized Coder<@Nullable ResponseT> responseTCoder;
            private final @UnknownKeyFor @NonNull @Initialized RedisClient client;

            private Read(@UnknownKeyFor @NonNull @Initialized Coder<RequestT> requestTCoder, @UnknownKeyFor @NonNull @Initialized Coder<@Nullable ResponseT> responseTCoder, @UnknownKeyFor @NonNull @Initialized RedisClient client) {
                this.requestTCoder = requestTCoder;
                this.responseTCoder = responseTCoder;
                this.client = client;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized KV<RequestT, @Nullable ResponseT> call(RequestT request) throws @UnknownKeyFor @NonNull @Initialized UserCodeExecutionException {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    this.requestTCoder.encode(request, (OutputStream)baos);
                    byte[] encodedRequest = baos.toByteArray();
                    byte[] encodedResponse = this.client.getBytes(encodedRequest);
                    if (encodedResponse == null) {
                        return KV.of(request, null);
                    }
                    Object response = Preconditions.checkStateNotNull((Object)this.responseTCoder.decode(ByteSource.wrap((byte[])encodedResponse).openStream()));
                    return KV.of(request, (Object)response);
                }
                catch (IOException | IllegalStateException e) {
                    throw new UserCodeExecutionException(e);
                }
            }

            @Override
            public void setup() throws @UnknownKeyFor @NonNull @Initialized UserCodeExecutionException {
                this.client.setup();
            }

            @Override
            public void teardown() throws @UnknownKeyFor @NonNull @Initialized UserCodeExecutionException {
                this.client.teardown();
            }
        }
    }

    public static class Pair<@UnknownKeyFor RequestT, @UnknownKeyFor ResponseT> {
        private final @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<RequestT>, @UnknownKeyFor @NonNull @Initialized Result<@UnknownKeyFor @NonNull @Initialized KV<RequestT, @Nullable ResponseT>>> read;
        private final @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<RequestT, ResponseT>>, @UnknownKeyFor @NonNull @Initialized Result<@UnknownKeyFor @NonNull @Initialized KV<RequestT, ResponseT>>> write;

        public static <RequestT, ResponseT> @UnknownKeyFor @NonNull @Initialized Pair<RequestT, ResponseT> of(@UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<RequestT>, @UnknownKeyFor @NonNull @Initialized Result<@UnknownKeyFor @NonNull @Initialized KV<RequestT, @Nullable ResponseT>>> read, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<RequestT, ResponseT>>, @UnknownKeyFor @NonNull @Initialized Result<@UnknownKeyFor @NonNull @Initialized KV<RequestT, ResponseT>>> write) {
            return new Pair<RequestT, ResponseT>(read, write);
        }

        private Pair(@UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<RequestT>, @UnknownKeyFor @NonNull @Initialized Result<@UnknownKeyFor @NonNull @Initialized KV<RequestT, @Nullable ResponseT>>> read, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<RequestT, ResponseT>>, @UnknownKeyFor @NonNull @Initialized Result<@UnknownKeyFor @NonNull @Initialized KV<RequestT, ResponseT>>> write) {
            this.read = read;
            this.write = write;
        }

        public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<RequestT>, @UnknownKeyFor @NonNull @Initialized Result<@UnknownKeyFor @NonNull @Initialized KV<RequestT, @Nullable ResponseT>>> getRead() {
            return this.read;
        }

        public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<RequestT, ResponseT>>, @UnknownKeyFor @NonNull @Initialized Result<@UnknownKeyFor @NonNull @Initialized KV<RequestT, ResponseT>>> getWrite() {
            return this.write;
        }
    }
}

