/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.io.requestresponse;

import java.io.Serializable;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Objects;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Duration;

public class Quota
implements Serializable {
    private final @UnknownKeyFor @NonNull @Initialized long numRequests;
    private final @UnknownKeyFor @NonNull @Initialized Duration interval;

    public Quota(@UnknownKeyFor @NonNull @Initialized long numRequests, @UnknownKeyFor @NonNull @Initialized Duration interval) {
        this.numRequests = numRequests;
        this.interval = interval;
    }

    public @UnknownKeyFor @NonNull @Initialized long getNumRequests() {
        return this.numRequests;
    }

    public @UnknownKeyFor @NonNull @Initialized Duration getInterval() {
        return this.interval;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Quota quota = (Quota)o;
        return this.numRequests == quota.numRequests && Objects.equal((Object)this.interval, (Object)quota.interval);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.numRequests, this.interval});
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "Quota{numRequests=" + this.numRequests + ", interval=" + this.interval + '}';
    }
}

