/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.io.requestresponse;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.apache.beam.io.requestresponse.SetupTeardown;
import org.apache.beam.io.requestresponse.UserCodeExecutionException;
import org.apache.beam.sdk.util.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import redis.clients.jedis.JedisPooled;
import redis.clients.jedis.exceptions.JedisException;

class RedisClient
implements SetupTeardown {
    private final @UnknownKeyFor @NonNull @Initialized URI uri;
    private transient @MonotonicNonNull @UnknownKeyFor @Initialized JedisPooled jedis;

    RedisClient(@UnknownKeyFor @NonNull @Initialized URI uri) {
        this.uri = uri;
    }

    @UnknownKeyFor @NonNull @Initialized long decr(@UnknownKeyFor @NonNull @Initialized String key) throws @UnknownKeyFor @NonNull @Initialized UserCodeExecutionException {
        try {
            return this.getSafeClient().decr(key);
        }
        catch (JedisException e) {
            throw new UserCodeExecutionException(e);
        }
    }

    @UnknownKeyFor @NonNull @Initialized byte @Nullable @UnknownKeyFor @Initialized [] getBytes(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] key) throws @UnknownKeyFor @NonNull @Initialized UserCodeExecutionException {
        try {
            return this.getSafeClient().get(key);
        }
        catch (JedisException e) {
            throw new UserCodeExecutionException(e);
        }
    }

    @UnknownKeyFor @NonNull @Initialized long getLong(@UnknownKeyFor @NonNull @Initialized String key) throws @UnknownKeyFor @NonNull @Initialized UserCodeExecutionException {
        try {
            return this.getSafeClient().decrBy(key, 0L);
        }
        catch (JedisException e) {
            throw new UserCodeExecutionException(e);
        }
    }

    @UnknownKeyFor @NonNull @Initialized boolean exists(@UnknownKeyFor @NonNull @Initialized String key) throws @UnknownKeyFor @NonNull @Initialized UserCodeExecutionException {
        try {
            return this.getSafeClient().exists(key);
        }
        catch (JedisException e) {
            throw new UserCodeExecutionException(e);
        }
    }

    @UnknownKeyFor @NonNull @Initialized long incr(@UnknownKeyFor @NonNull @Initialized String key) throws @UnknownKeyFor @NonNull @Initialized UserCodeExecutionException {
        try {
            return this.getSafeClient().incr(key);
        }
        catch (JedisException e) {
            throw new UserCodeExecutionException(e);
        }
    }

    @UnknownKeyFor @NonNull @Initialized long llen(@UnknownKeyFor @NonNull @Initialized String key) throws @UnknownKeyFor @NonNull @Initialized UserCodeExecutionException {
        try {
            return this.getSafeClient().llen(key);
        }
        catch (JedisException e) {
            throw new UserCodeExecutionException(e);
        }
    }

    @UnknownKeyFor @NonNull @Initialized boolean isEmpty(@UnknownKeyFor @NonNull @Initialized String key) throws @UnknownKeyFor @NonNull @Initialized UserCodeExecutionException {
        return this.llen(key) == 0L;
    }

    void rpush(@UnknownKeyFor @NonNull @Initialized String key, byte[] ... items) throws @UnknownKeyFor @NonNull @Initialized UserCodeExecutionException {
        try {
            this.getSafeClient().rpush(key.getBytes(StandardCharsets.UTF_8), items);
        }
        catch (JedisException e) {
            throw new UserCodeExecutionException(e);
        }
    }

    @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] lpop(@UnknownKeyFor @NonNull @Initialized String key) throws @UnknownKeyFor @NonNull @Initialized UserCodeExecutionException {
        try {
            return this.getSafeClient().lpop(key.getBytes(StandardCharsets.UTF_8));
        }
        catch (JedisException e) {
            throw new UserCodeExecutionException(e);
        }
    }

    void setex(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] key, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] value, @UnknownKeyFor @NonNull @Initialized Duration expiry) throws @UnknownKeyFor @NonNull @Initialized UserCodeExecutionException {
        try {
            this.getSafeClient().setex(key, expiry.getStandardSeconds(), value);
        }
        catch (JedisException e) {
            throw new UserCodeExecutionException(e);
        }
    }

    void setex(@UnknownKeyFor @NonNull @Initialized String key, @UnknownKeyFor @NonNull @Initialized Long value, @UnknownKeyFor @NonNull @Initialized Duration expiry) throws @UnknownKeyFor @NonNull @Initialized UserCodeExecutionException {
        try {
            this.getSafeClient().setex(key, expiry.getStandardSeconds(), String.valueOf(value));
        }
        catch (JedisException e) {
            throw new UserCodeExecutionException(e);
        }
    }

    @Override
    public void setup() throws @UnknownKeyFor @NonNull @Initialized UserCodeExecutionException {
        try {
            this.jedis = new JedisPooled(this.uri);
            this.jedis.ping();
        }
        catch (JedisException e) {
            String message = String.format("Failed to connect to host: %s, error: %s", this.uri, e.getMessage());
            throw new UserCodeExecutionException(message, e);
        }
    }

    private @NonNull @UnknownKeyFor @Initialized JedisPooled getSafeClient() {
        return (JedisPooled)Preconditions.checkStateNotNull((Object)this.jedis);
    }

    @Override
    public void teardown() throws @UnknownKeyFor @NonNull @Initialized UserCodeExecutionException {
        if (this.jedis != null) {
            this.jedis.close();
        }
    }
}

