/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.io.requestresponse;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.util.Optional;
import org.apache.beam.io.requestresponse.AutoValue_Repeater;
import org.apache.beam.io.requestresponse.Monitoring;
import org.apache.beam.io.requestresponse.UserCodeExecutionException;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.util.BackOff;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.util.Sleeper;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoValue
abstract class Repeater<@UnknownKeyFor InputT, @UnknownKeyFor OutputT> {
    Repeater() {
    }

    static <InputT, OutputT> @UnknownKeyFor @NonNull @Initialized Builder<InputT, OutputT> builder() {
        return new AutoValue_Repeater.Builder();
    }

    abstract @UnknownKeyFor @NonNull @Initialized ThrowableFunction<InputT, OutputT> getThrowableFunction();

    abstract @UnknownKeyFor @NonNull @Initialized Sleeper getSleeper();

    abstract @UnknownKeyFor @NonNull @Initialized BackOff getBackOff();

    abstract @Nullable @UnknownKeyFor @Initialized Counter getCallCounter();

    @UnknownKeyFor @NonNull @Initialized Repeater<InputT, OutputT> withCallCounter(@Nullable @UnknownKeyFor @Initialized Counter value) {
        if (value == null) {
            return this;
        }
        return this.toBuilder().setCallCounter((Counter)Preconditions.checkStateNotNull((Object)value)).build();
    }

    abstract @Nullable @UnknownKeyFor @Initialized Counter getBackoffCounter();

    @UnknownKeyFor @NonNull @Initialized Repeater<InputT, OutputT> withBackoffCounter(@Nullable @UnknownKeyFor @Initialized Counter value) {
        if (value == null) {
            return this;
        }
        return this.toBuilder().setBackoffCounter((Counter)Preconditions.checkStateNotNull((Object)value)).build();
    }

    abstract @Nullable @UnknownKeyFor @Initialized Counter getSleeperCounter();

    @UnknownKeyFor @NonNull @Initialized Repeater<InputT, OutputT> withSleeperCounter(@Nullable @UnknownKeyFor @Initialized Counter value) {
        if (value == null) {
            return this;
        }
        return this.toBuilder().setSleeperCounter((Counter)Preconditions.checkStateNotNull((Object)value)).build();
    }

    abstract @UnknownKeyFor @NonNull @Initialized Builder<InputT, OutputT> toBuilder();

    OutputT apply(InputT input) throws @UnknownKeyFor @NonNull @Initialized UserCodeExecutionException {
        Optional<UserCodeExecutionException> latestError = Optional.empty();
        long waitFor = 0L;
        while (waitFor != -1L) {
            try {
                this.sleepIfNeeded(waitFor);
                Monitoring.incIfPresent(this.getCallCounter());
                return this.getThrowableFunction().apply(input);
            }
            catch (UserCodeExecutionException e) {
                if (!e.shouldRepeat()) {
                    throw e;
                }
                latestError = Optional.of(e);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                Monitoring.incIfPresent(this.getBackoffCounter());
                waitFor = this.getBackOff().nextBackOffMillis();
            }
            catch (IOException e) {
                throw new UserCodeExecutionException(e);
            }
        }
        throw latestError.orElse(new UserCodeExecutionException("failed to process for input: " + input));
    }

    private void sleepIfNeeded(@UnknownKeyFor @NonNull @Initialized long waitFor) throws @UnknownKeyFor @NonNull @Initialized InterruptedException {
        if (waitFor > 0L) {
            Monitoring.incIfPresent(this.getSleeperCounter());
            this.getSleeper().sleep(waitFor);
        }
    }

    @AutoValue.Builder
    static abstract class Builder<@UnknownKeyFor InputT, @UnknownKeyFor OutputT> {
        Builder() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized Builder<InputT, OutputT> setThrowableFunction(@UnknownKeyFor @NonNull @Initialized ThrowableFunction<InputT, OutputT> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder<InputT, OutputT> setSleeper(@UnknownKeyFor @NonNull @Initialized Sleeper var1);

        abstract @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Sleeper> getSleeper();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<InputT, OutputT> setBackOff(@UnknownKeyFor @NonNull @Initialized BackOff var1);

        abstract @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized BackOff> getBackOff();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<InputT, OutputT> setCallCounter(@UnknownKeyFor @NonNull @Initialized Counter var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder<InputT, OutputT> setBackoffCounter(@UnknownKeyFor @NonNull @Initialized Counter var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder<InputT, OutputT> setSleeperCounter(@UnknownKeyFor @NonNull @Initialized Counter var1);

        abstract @UnknownKeyFor @NonNull @Initialized Repeater<InputT, OutputT> autoBuild();

        final @UnknownKeyFor @NonNull @Initialized Repeater<InputT, OutputT> build() {
            if (!this.getSleeper().isPresent()) {
                this.setSleeper(Sleeper.DEFAULT);
            }
            if (!this.getBackOff().isPresent()) {
                this.setBackOff(FluentBackoff.DEFAULT.backoff());
            }
            return this.autoBuild();
        }
    }

    @FunctionalInterface
    static interface ThrowableFunction<@UnknownKeyFor InputT, @UnknownKeyFor OutputT> {
        public OutputT apply(InputT var1) throws @UnknownKeyFor @NonNull @Initialized UserCodeExecutionException;
    }
}

