/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.io.requestresponse;

import java.util.Optional;
import org.apache.beam.io.requestresponse.Call;
import org.apache.beam.io.requestresponse.CallShouldBackoff;
import org.apache.beam.io.requestresponse.Caller;
import org.apache.beam.io.requestresponse.Monitoring;
import org.apache.beam.io.requestresponse.SetupTeardown;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.util.BackOff;
import org.apache.beam.sdk.util.SerializableSupplier;
import org.apache.beam.sdk.util.Sleeper;
import org.joda.time.Duration;

final class AutoValue_Call_Configuration<RequestT, ResponseT>
extends Call.Configuration<RequestT, ResponseT> {
    private final Caller<RequestT, ResponseT> caller;
    private final SetupTeardown setupTeardown;
    private final Duration timeout;
    private final Coder<ResponseT> responseCoder;
    private final Boolean shouldRepeat;
    private final CallShouldBackoff<ResponseT> callShouldBackoff;
    private final SerializableSupplier<Sleeper> sleeperSupplier;
    private final SerializableSupplier<BackOff> backOffSupplier;
    private final Monitoring monitoringConfiguration;

    private AutoValue_Call_Configuration(Caller<RequestT, ResponseT> caller, SetupTeardown setupTeardown, Duration timeout, Coder<ResponseT> responseCoder, Boolean shouldRepeat, CallShouldBackoff<ResponseT> callShouldBackoff, SerializableSupplier<Sleeper> sleeperSupplier, SerializableSupplier<BackOff> backOffSupplier, Monitoring monitoringConfiguration) {
        this.caller = caller;
        this.setupTeardown = setupTeardown;
        this.timeout = timeout;
        this.responseCoder = responseCoder;
        this.shouldRepeat = shouldRepeat;
        this.callShouldBackoff = callShouldBackoff;
        this.sleeperSupplier = sleeperSupplier;
        this.backOffSupplier = backOffSupplier;
        this.monitoringConfiguration = monitoringConfiguration;
    }

    @Override
    Caller<RequestT, ResponseT> getCaller() {
        return this.caller;
    }

    @Override
    SetupTeardown getSetupTeardown() {
        return this.setupTeardown;
    }

    @Override
    Duration getTimeout() {
        return this.timeout;
    }

    @Override
    Coder<ResponseT> getResponseCoder() {
        return this.responseCoder;
    }

    @Override
    Boolean getShouldRepeat() {
        return this.shouldRepeat;
    }

    @Override
    CallShouldBackoff<ResponseT> getCallShouldBackoff() {
        return this.callShouldBackoff;
    }

    @Override
    SerializableSupplier<Sleeper> getSleeperSupplier() {
        return this.sleeperSupplier;
    }

    @Override
    SerializableSupplier<BackOff> getBackOffSupplier() {
        return this.backOffSupplier;
    }

    @Override
    Monitoring getMonitoringConfiguration() {
        return this.monitoringConfiguration;
    }

    public String toString() {
        return "Configuration{caller=" + this.caller + ", setupTeardown=" + this.setupTeardown + ", timeout=" + this.timeout + ", responseCoder=" + this.responseCoder + ", shouldRepeat=" + this.shouldRepeat + ", callShouldBackoff=" + this.callShouldBackoff + ", sleeperSupplier=" + this.sleeperSupplier + ", backOffSupplier=" + this.backOffSupplier + ", monitoringConfiguration=" + this.monitoringConfiguration + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Call.Configuration) {
            Call.Configuration that = (Call.Configuration)o;
            return this.caller.equals(that.getCaller()) && this.setupTeardown.equals(that.getSetupTeardown()) && this.timeout.equals((Object)that.getTimeout()) && this.responseCoder.equals(that.getResponseCoder()) && this.shouldRepeat.equals(that.getShouldRepeat()) && this.callShouldBackoff.equals(that.getCallShouldBackoff()) && this.sleeperSupplier.equals(that.getSleeperSupplier()) && this.backOffSupplier.equals(that.getBackOffSupplier()) && this.monitoringConfiguration.equals(that.getMonitoringConfiguration());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.caller.hashCode();
        h$ *= 1000003;
        h$ ^= this.setupTeardown.hashCode();
        h$ *= 1000003;
        h$ ^= this.timeout.hashCode();
        h$ *= 1000003;
        h$ ^= this.responseCoder.hashCode();
        h$ *= 1000003;
        h$ ^= this.shouldRepeat.hashCode();
        h$ *= 1000003;
        h$ ^= this.callShouldBackoff.hashCode();
        h$ *= 1000003;
        h$ ^= this.sleeperSupplier.hashCode();
        h$ *= 1000003;
        h$ ^= this.backOffSupplier.hashCode();
        h$ *= 1000003;
        return h$ ^= this.monitoringConfiguration.hashCode();
    }

    @Override
    Call.Configuration.Builder<RequestT, ResponseT> toBuilder() {
        return new Builder(this);
    }

    static final class Builder<RequestT, ResponseT>
    extends Call.Configuration.Builder<RequestT, ResponseT> {
        private Caller<RequestT, ResponseT> caller;
        private SetupTeardown setupTeardown;
        private Duration timeout;
        private Coder<ResponseT> responseCoder;
        private Boolean shouldRepeat;
        private CallShouldBackoff<ResponseT> callShouldBackoff;
        private SerializableSupplier<Sleeper> sleeperSupplier;
        private SerializableSupplier<BackOff> backOffSupplier;
        private Monitoring monitoringConfiguration;

        Builder() {
        }

        private Builder(Call.Configuration<RequestT, ResponseT> source) {
            this.caller = source.getCaller();
            this.setupTeardown = source.getSetupTeardown();
            this.timeout = source.getTimeout();
            this.responseCoder = source.getResponseCoder();
            this.shouldRepeat = source.getShouldRepeat();
            this.callShouldBackoff = source.getCallShouldBackoff();
            this.sleeperSupplier = source.getSleeperSupplier();
            this.backOffSupplier = source.getBackOffSupplier();
            this.monitoringConfiguration = source.getMonitoringConfiguration();
        }

        @Override
        Call.Configuration.Builder<RequestT, ResponseT> setCaller(Caller<RequestT, ResponseT> caller) {
            if (caller == null) {
                throw new NullPointerException("Null caller");
            }
            this.caller = caller;
            return this;
        }

        @Override
        Call.Configuration.Builder<RequestT, ResponseT> setSetupTeardown(SetupTeardown setupTeardown) {
            if (setupTeardown == null) {
                throw new NullPointerException("Null setupTeardown");
            }
            this.setupTeardown = setupTeardown;
            return this;
        }

        @Override
        Optional<SetupTeardown> getSetupTeardown() {
            if (this.setupTeardown == null) {
                return Optional.empty();
            }
            return Optional.of(this.setupTeardown);
        }

        @Override
        Call.Configuration.Builder<RequestT, ResponseT> setTimeout(Duration timeout) {
            if (timeout == null) {
                throw new NullPointerException("Null timeout");
            }
            this.timeout = timeout;
            return this;
        }

        @Override
        Optional<Duration> getTimeout() {
            if (this.timeout == null) {
                return Optional.empty();
            }
            return Optional.of(this.timeout);
        }

        @Override
        Call.Configuration.Builder<RequestT, ResponseT> setResponseCoder(Coder<ResponseT> responseCoder) {
            if (responseCoder == null) {
                throw new NullPointerException("Null responseCoder");
            }
            this.responseCoder = responseCoder;
            return this;
        }

        @Override
        Call.Configuration.Builder<RequestT, ResponseT> setShouldRepeat(Boolean shouldRepeat) {
            if (shouldRepeat == null) {
                throw new NullPointerException("Null shouldRepeat");
            }
            this.shouldRepeat = shouldRepeat;
            return this;
        }

        @Override
        Optional<Boolean> getShouldRepeat() {
            if (this.shouldRepeat == null) {
                return Optional.empty();
            }
            return Optional.of(this.shouldRepeat);
        }

        @Override
        Call.Configuration.Builder<RequestT, ResponseT> setCallShouldBackoff(CallShouldBackoff<ResponseT> callShouldBackoff) {
            if (callShouldBackoff == null) {
                throw new NullPointerException("Null callShouldBackoff");
            }
            this.callShouldBackoff = callShouldBackoff;
            return this;
        }

        @Override
        Optional<CallShouldBackoff<ResponseT>> getCallShouldBackoff() {
            if (this.callShouldBackoff == null) {
                return Optional.empty();
            }
            return Optional.of(this.callShouldBackoff);
        }

        @Override
        Call.Configuration.Builder<RequestT, ResponseT> setSleeperSupplier(SerializableSupplier<Sleeper> sleeperSupplier) {
            if (sleeperSupplier == null) {
                throw new NullPointerException("Null sleeperSupplier");
            }
            this.sleeperSupplier = sleeperSupplier;
            return this;
        }

        @Override
        Optional<SerializableSupplier<Sleeper>> getSleeperSupplier() {
            if (this.sleeperSupplier == null) {
                return Optional.empty();
            }
            return Optional.of(this.sleeperSupplier);
        }

        @Override
        Call.Configuration.Builder<RequestT, ResponseT> setBackOffSupplier(SerializableSupplier<BackOff> backOffSupplier) {
            if (backOffSupplier == null) {
                throw new NullPointerException("Null backOffSupplier");
            }
            this.backOffSupplier = backOffSupplier;
            return this;
        }

        @Override
        Optional<SerializableSupplier<BackOff>> getBackOffSupplier() {
            if (this.backOffSupplier == null) {
                return Optional.empty();
            }
            return Optional.of(this.backOffSupplier);
        }

        @Override
        Call.Configuration.Builder<RequestT, ResponseT> setMonitoringConfiguration(Monitoring monitoringConfiguration) {
            if (monitoringConfiguration == null) {
                throw new NullPointerException("Null monitoringConfiguration");
            }
            this.monitoringConfiguration = monitoringConfiguration;
            return this;
        }

        @Override
        Optional<Monitoring> getMonitoringConfiguration() {
            if (this.monitoringConfiguration == null) {
                return Optional.empty();
            }
            return Optional.of(this.monitoringConfiguration);
        }

        @Override
        Call.Configuration<RequestT, ResponseT> autoBuild() {
            if (this.caller == null || this.setupTeardown == null || this.timeout == null || this.responseCoder == null || this.shouldRepeat == null || this.callShouldBackoff == null || this.sleeperSupplier == null || this.backOffSupplier == null || this.monitoringConfiguration == null) {
                StringBuilder missing = new StringBuilder();
                if (this.caller == null) {
                    missing.append(" caller");
                }
                if (this.setupTeardown == null) {
                    missing.append(" setupTeardown");
                }
                if (this.timeout == null) {
                    missing.append(" timeout");
                }
                if (this.responseCoder == null) {
                    missing.append(" responseCoder");
                }
                if (this.shouldRepeat == null) {
                    missing.append(" shouldRepeat");
                }
                if (this.callShouldBackoff == null) {
                    missing.append(" callShouldBackoff");
                }
                if (this.sleeperSupplier == null) {
                    missing.append(" sleeperSupplier");
                }
                if (this.backOffSupplier == null) {
                    missing.append(" backOffSupplier");
                }
                if (this.monitoringConfiguration == null) {
                    missing.append(" monitoringConfiguration");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_Call_Configuration(this.caller, this.setupTeardown, this.timeout, this.responseCoder, this.shouldRepeat, this.callShouldBackoff, this.sleeperSupplier, this.backOffSupplier, this.monitoringConfiguration);
        }
    }
}

