/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.io.requestresponse;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.beam.io.requestresponse.ApiIOError;
import org.apache.beam.io.requestresponse.AutoValue_Call_Configuration;
import org.apache.beam.io.requestresponse.CallShouldBackoff;
import org.apache.beam.io.requestresponse.Caller;
import org.apache.beam.io.requestresponse.DefaultSerializableBackoffSupplier;
import org.apache.beam.io.requestresponse.Monitoring;
import org.apache.beam.io.requestresponse.Repeater;
import org.apache.beam.io.requestresponse.RequestResponseIO;
import org.apache.beam.io.requestresponse.Result;
import org.apache.beam.io.requestresponse.SetupTeardown;
import org.apache.beam.io.requestresponse.UserCodeExecutionException;
import org.apache.beam.io.requestresponse.UserCodeQuotaException;
import org.apache.beam.io.requestresponse.UserCodeTimeoutException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.util.BackOff;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.util.SerializableSupplier;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.util.Sleeper;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

class Call<@UnknownKeyFor RequestT, @UnknownKeyFor ResponseT>
extends PTransform<PCollection<RequestT>, Result<ResponseT>> {
    private final @UnknownKeyFor @NonNull @Initialized TupleTag<ResponseT> responseTag = new TupleTag<ResponseT>(){};
    private final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized ApiIOError> failureTag = new TupleTag<ApiIOError>(){};
    private final @UnknownKeyFor @NonNull @Initialized Configuration<RequestT, ResponseT> configuration;

    static <RequestT, ResponseT> @UnknownKeyFor @NonNull @Initialized Call<RequestT, ResponseT> of(@UnknownKeyFor @NonNull @Initialized Caller<RequestT, ResponseT> caller, @UnknownKeyFor @NonNull @Initialized Coder<ResponseT> responseTCoder) {
        caller = (Caller)SerializableUtils.ensureSerializable(caller);
        return new Call(Configuration.builder().setCaller(caller).setResponseCoder(responseTCoder).build());
    }

    static <RequestT, ResponseT, CallerSetupTeardownT extends Caller<RequestT, ResponseT> & SetupTeardown> @UnknownKeyFor @NonNull @Initialized Call<RequestT, ResponseT> ofCallerAndSetupTeardown(CallerSetupTeardownT implementsCallerAndSetupTeardown, @UnknownKeyFor @NonNull @Initialized Coder<ResponseT> responseTCoder) {
        implementsCallerAndSetupTeardown = (Caller)SerializableUtils.ensureSerializable(implementsCallerAndSetupTeardown);
        return new Call(Configuration.builder().setCaller(implementsCallerAndSetupTeardown).setResponseCoder(responseTCoder).setSetupTeardown((SetupTeardown)implementsCallerAndSetupTeardown).build());
    }

    static <RequestT, ResponseT> @UnknownKeyFor @NonNull @Initialized Call<RequestT, ResponseT> of(@UnknownKeyFor @NonNull @Initialized Configuration<RequestT, ResponseT> configuration) {
        return new Call<RequestT, ResponseT>(configuration);
    }

    private Call(@UnknownKeyFor @NonNull @Initialized Configuration<RequestT, ResponseT> configuration) {
        this.configuration = (Configuration)SerializableUtils.ensureSerializable(configuration);
    }

    @UnknownKeyFor @NonNull @Initialized Call<RequestT, ResponseT> withSetupTeardown(@UnknownKeyFor @NonNull @Initialized SetupTeardown setupTeardown) {
        setupTeardown = (SetupTeardown)SerializableUtils.ensureSerializable((Serializable)setupTeardown);
        return new Call<RequestT, ResponseT>(this.configuration.toBuilder().setSetupTeardown(setupTeardown).build());
    }

    @UnknownKeyFor @NonNull @Initialized Call<RequestT, ResponseT> withTimeout(@UnknownKeyFor @NonNull @Initialized Duration timeout) {
        return new Call<RequestT, ResponseT>(this.configuration.toBuilder().setTimeout(timeout).build());
    }

    public @UnknownKeyFor @NonNull @Initialized Result<ResponseT> expand(@UnknownKeyFor @NonNull @Initialized PCollection<RequestT> input) {
        PCollectionTuple pct = (PCollectionTuple)input.apply(CallFn.class.getSimpleName(), (PTransform)ParDo.of(new CallFn(this.responseTag, this.failureTag, this.configuration)).withOutputTags(this.responseTag, TupleTagList.of(this.failureTag)));
        return Result.of(this.configuration.getResponseCoder(), this.responseTag, this.failureTag, pct);
    }

    private static <T> void parseAndThrow(@UnknownKeyFor @NonNull @Initialized Future<T> future, @UnknownKeyFor @NonNull @Initialized ExecutionException e) throws @UnknownKeyFor @NonNull @Initialized UserCodeExecutionException {
        future.cancel(true);
        if (e.getCause() == null) {
            throw new UserCodeExecutionException(e);
        }
        Throwable cause = (Throwable)Preconditions.checkStateNotNull((Object)e.getCause());
        if (cause instanceof UserCodeQuotaException) {
            throw new UserCodeQuotaException(cause);
        }
        throw new UserCodeExecutionException(cause);
    }

    private static class SetupTeardownWithTimeout
    implements SetupTeardown {
        private final @UnknownKeyFor @NonNull @Initialized Duration timeout;
        private final @UnknownKeyFor @NonNull @Initialized SetupTeardown setupTeardown;
        private @MonotonicNonNull @UnknownKeyFor @Initialized ExecutorService executor;

        SetupTeardownWithTimeout(@UnknownKeyFor @NonNull @Initialized Duration timeout, @UnknownKeyFor @NonNull @Initialized SetupTeardown setupTeardown) {
            this.timeout = timeout;
            this.setupTeardown = setupTeardown;
        }

        private void setExecutor(@UnknownKeyFor @NonNull @Initialized ExecutorService executor) {
            this.executor = executor;
        }

        @Override
        public void setup() throws @UnknownKeyFor @NonNull @Initialized UserCodeExecutionException {
            Callable<Void> callable = () -> {
                this.setupTeardown.setup();
                return null;
            };
            this.executeAsync(callable);
        }

        @Override
        public void teardown() throws @UnknownKeyFor @NonNull @Initialized UserCodeExecutionException {
            Callable<Void> callable = () -> {
                this.setupTeardown.teardown();
                return null;
            };
            this.executeAsync(callable);
        }

        private void executeAsync(@UnknownKeyFor @NonNull @Initialized Callable<@UnknownKeyFor @Nullable @Initialized Void> callable) throws @UnknownKeyFor @NonNull @Initialized UserCodeExecutionException {
            Future<Void> future = ((ExecutorService)Preconditions.checkStateNotNull((Object)this.executor)).submit(callable);
            try {
                future.get(this.timeout.getMillis(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | TimeoutException e) {
                future.cancel(true);
                throw new UserCodeTimeoutException(e);
            }
            catch (ExecutionException e) {
                Call.parseAndThrow(future, e);
            }
        }
    }

    private static class CallerWithTimeout<@UnknownKeyFor RequestT, @UnknownKeyFor ResponseT>
    implements Caller<RequestT, ResponseT> {
        private final @UnknownKeyFor @NonNull @Initialized Duration timeout;
        private final @UnknownKeyFor @NonNull @Initialized Caller<RequestT, ResponseT> caller;
        private @MonotonicNonNull @UnknownKeyFor @Initialized ExecutorService executor;

        private CallerWithTimeout(@UnknownKeyFor @NonNull @Initialized Duration timeout, @UnknownKeyFor @NonNull @Initialized Caller<RequestT, ResponseT> caller) {
            this.timeout = timeout;
            this.caller = caller;
        }

        private void setExecutor(@UnknownKeyFor @NonNull @Initialized ExecutorService executor) {
            this.executor = executor;
        }

        @Override
        public ResponseT call(RequestT request) throws @UnknownKeyFor @NonNull @Initialized UserCodeExecutionException {
            Future<Object> future = ((ExecutorService)Preconditions.checkStateNotNull((Object)this.executor)).submit(() -> this.caller.call(request));
            try {
                return (ResponseT)future.get(this.timeout.getMillis(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | TimeoutException e) {
                throw new UserCodeTimeoutException(e);
            }
            catch (ExecutionException e) {
                Call.parseAndThrow(future, e);
                throw new UserCodeExecutionException("could not complete request");
            }
        }
    }

    private static class NoopCallShouldBackoff<@UnknownKeyFor ResponseT>
    implements CallShouldBackoff<ResponseT> {
        private NoopCallShouldBackoff() {
        }

        @Override
        public void update(@UnknownKeyFor @NonNull @Initialized UserCodeExecutionException exception) {
        }

        @Override
        public void update(ResponseT response) {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean isTrue() {
            return false;
        }
    }

    static class NoopSetupTeardown
    implements SetupTeardown {
        NoopSetupTeardown() {
        }

        @Override
        public void setup() throws @UnknownKeyFor @NonNull @Initialized UserCodeExecutionException {
        }

        @Override
        public void teardown() throws @UnknownKeyFor @NonNull @Initialized UserCodeExecutionException {
        }
    }

    @AutoValue
    static abstract class Configuration<@UnknownKeyFor RequestT, @UnknownKeyFor ResponseT>
    implements Serializable {
        Configuration() {
        }

        static <RequestT, ResponseT> @UnknownKeyFor @NonNull @Initialized Builder<RequestT, ResponseT> builder() {
            return new AutoValue_Call_Configuration.Builder();
        }

        abstract @UnknownKeyFor @NonNull @Initialized Caller<RequestT, ResponseT> getCaller();

        abstract @UnknownKeyFor @NonNull @Initialized SetupTeardown getSetupTeardown();

        abstract @UnknownKeyFor @NonNull @Initialized Duration getTimeout();

        abstract @UnknownKeyFor @NonNull @Initialized Coder<ResponseT> getResponseCoder();

        abstract @UnknownKeyFor @NonNull @Initialized Boolean getShouldRepeat();

        abstract @UnknownKeyFor @NonNull @Initialized CallShouldBackoff<ResponseT> getCallShouldBackoff();

        abstract @UnknownKeyFor @NonNull @Initialized SerializableSupplier<@UnknownKeyFor @NonNull @Initialized Sleeper> getSleeperSupplier();

        abstract @UnknownKeyFor @NonNull @Initialized SerializableSupplier<@UnknownKeyFor @NonNull @Initialized BackOff> getBackOffSupplier();

        abstract @UnknownKeyFor @NonNull @Initialized Monitoring getMonitoringConfiguration();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<RequestT, ResponseT> toBuilder();

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor RequestT, @UnknownKeyFor ResponseT> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<RequestT, ResponseT> setCaller(@UnknownKeyFor @NonNull @Initialized Caller<RequestT, ResponseT> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<RequestT, ResponseT> setResponseCoder(@UnknownKeyFor @NonNull @Initialized Coder<ResponseT> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<RequestT, ResponseT> setSetupTeardown(@UnknownKeyFor @NonNull @Initialized SetupTeardown var1);

            abstract @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized SetupTeardown> getSetupTeardown();

            abstract @UnknownKeyFor @NonNull @Initialized Builder<RequestT, ResponseT> setTimeout(@UnknownKeyFor @NonNull @Initialized Duration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Duration> getTimeout();

            abstract @UnknownKeyFor @NonNull @Initialized Builder<RequestT, ResponseT> setShouldRepeat(@UnknownKeyFor @NonNull @Initialized Boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Boolean> getShouldRepeat();

            abstract @UnknownKeyFor @NonNull @Initialized Builder<RequestT, ResponseT> setCallShouldBackoff(@UnknownKeyFor @NonNull @Initialized CallShouldBackoff<ResponseT> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized CallShouldBackoff<ResponseT>> getCallShouldBackoff();

            abstract @UnknownKeyFor @NonNull @Initialized Builder<RequestT, ResponseT> setSleeperSupplier(@UnknownKeyFor @NonNull @Initialized SerializableSupplier<@UnknownKeyFor @NonNull @Initialized Sleeper> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized SerializableSupplier<@UnknownKeyFor @NonNull @Initialized Sleeper>> getSleeperSupplier();

            abstract @UnknownKeyFor @NonNull @Initialized Builder<RequestT, ResponseT> setBackOffSupplier(@UnknownKeyFor @NonNull @Initialized SerializableSupplier<@UnknownKeyFor @NonNull @Initialized BackOff> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized SerializableSupplier<@UnknownKeyFor @NonNull @Initialized BackOff>> getBackOffSupplier();

            abstract @UnknownKeyFor @NonNull @Initialized Builder<RequestT, ResponseT> setMonitoringConfiguration(@UnknownKeyFor @NonNull @Initialized Monitoring var1);

            abstract @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Monitoring> getMonitoringConfiguration();

            abstract @UnknownKeyFor @NonNull @Initialized Configuration<RequestT, ResponseT> autoBuild();

            final @UnknownKeyFor @NonNull @Initialized Configuration<RequestT, ResponseT> build() {
                if (!this.getSetupTeardown().isPresent()) {
                    this.setSetupTeardown(new NoopSetupTeardown());
                }
                if (!this.getShouldRepeat().isPresent()) {
                    this.setShouldRepeat(false);
                }
                if (!this.getTimeout().isPresent()) {
                    this.setTimeout(RequestResponseIO.DEFAULT_TIMEOUT);
                }
                if (!this.getCallShouldBackoff().isPresent()) {
                    this.setCallShouldBackoff(new NoopCallShouldBackoff());
                }
                if (!this.getSleeperSupplier().isPresent()) {
                    this.setSleeperSupplier((SerializableSupplier<Sleeper>)(SerializableSupplier & Serializable)() -> Sleeper.DEFAULT);
                }
                if (!this.getBackOffSupplier().isPresent()) {
                    this.setBackOffSupplier(new DefaultSerializableBackoffSupplier());
                }
                if (!this.getMonitoringConfiguration().isPresent()) {
                    this.setMonitoringConfiguration(Monitoring.builder().build());
                }
                return this.autoBuild();
            }
        }
    }

    private static class CallFn<@UnknownKeyFor RequestT, @UnknownKeyFor ResponseT>
    extends DoFn<RequestT, ResponseT> {
        private final @UnknownKeyFor @NonNull @Initialized TupleTag<ResponseT> responseTag;
        private final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized ApiIOError> failureTag;
        private final @UnknownKeyFor @NonNull @Initialized CallerWithTimeout<RequestT, ResponseT> caller;
        private final @UnknownKeyFor @NonNull @Initialized SetupTeardownWithTimeout setupTeardown;
        private final @UnknownKeyFor @NonNull @Initialized Configuration<RequestT, ResponseT> configuration;
        private @MonotonicNonNull @UnknownKeyFor @Initialized Counter requestsCounter = null;
        private @MonotonicNonNull @UnknownKeyFor @Initialized Counter responsesCounter = null;
        private @MonotonicNonNull @UnknownKeyFor @Initialized Counter failuresCounter = null;
        private @MonotonicNonNull @UnknownKeyFor @Initialized Counter callCounter = null;
        private @MonotonicNonNull @UnknownKeyFor @Initialized Counter setupCounter = null;
        private @MonotonicNonNull @UnknownKeyFor @Initialized Counter teardownCounter = null;
        private @MonotonicNonNull @UnknownKeyFor @Initialized Counter backoffCounter = null;
        private @MonotonicNonNull @UnknownKeyFor @Initialized Counter sleeperCounter = null;
        private @MonotonicNonNull @UnknownKeyFor @Initialized Counter shouldBackoffCounter = null;
        private transient @MonotonicNonNull @UnknownKeyFor @Initialized ExecutorService executor;

        private CallFn(@UnknownKeyFor @NonNull @Initialized TupleTag<ResponseT> responseTag, @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized ApiIOError> failureTag, @UnknownKeyFor @NonNull @Initialized Configuration<RequestT, ResponseT> configuration) {
            this.responseTag = responseTag;
            this.failureTag = failureTag;
            this.caller = new CallerWithTimeout(configuration.getTimeout(), configuration.getCaller());
            this.setupTeardown = new SetupTeardownWithTimeout(configuration.getTimeout(), configuration.getSetupTeardown());
            this.configuration = configuration;
        }

        private void setupMetrics() {
            Monitoring monitoring = this.configuration.getMonitoringConfiguration();
            if (monitoring.getCountRequests().booleanValue()) {
                this.requestsCounter = Metrics.counter(Call.class, (String)"requests");
            }
            if (monitoring.getCountResponses().booleanValue()) {
                this.responsesCounter = Metrics.counter(Call.class, (String)"responses");
            }
            if (monitoring.getCountFailures().booleanValue()) {
                this.failuresCounter = Metrics.counter(Call.class, (String)"failures");
            }
            if (monitoring.getCountCalls().booleanValue()) {
                this.callCounter = Metrics.counter(Call.class, (String)Monitoring.callCounterNameOf(this.configuration.getCaller()));
            }
            if (monitoring.getCountSetup().booleanValue()) {
                this.setupCounter = Metrics.counter(Call.class, (String)Monitoring.setupCounterNameOf(this.configuration.getSetupTeardown()));
            }
            if (monitoring.getCountTeardown().booleanValue()) {
                this.teardownCounter = Metrics.counter(Call.class, (String)Monitoring.teardownCounterNameOf(this.configuration.getSetupTeardown()));
            }
            if (monitoring.getCountBackoffs().booleanValue()) {
                this.backoffCounter = Metrics.counter(Call.class, (String)Monitoring.backoffCounterNameOf((BackOff)this.configuration.getBackOffSupplier().get()));
            }
            if (monitoring.getCountSleeps().booleanValue()) {
                this.sleeperCounter = Metrics.counter(Call.class, (String)Monitoring.sleeperCounterNameOf((Sleeper)this.configuration.getSleeperSupplier().get()));
            }
            if (monitoring.getCountShouldBackoff().booleanValue()) {
                this.shouldBackoffCounter = Metrics.counter(Call.class, (String)Monitoring.shouldBackoffCounterName(this.configuration.getCallShouldBackoff()));
            }
        }

        private void setupWithoutRepeat() throws @UnknownKeyFor @NonNull @Initialized UserCodeExecutionException {
            Monitoring.incIfPresent(this.setupCounter);
            this.setupTeardown.setup();
        }

        @DoFn.Setup
        public void setup() throws @UnknownKeyFor @NonNull @Initialized UserCodeExecutionException {
            this.setupMetrics();
            this.executor = Executors.newSingleThreadExecutor();
            ((CallerWithTimeout)this.caller).setExecutor(this.executor);
            this.setupTeardown.setExecutor(this.executor);
            if (!this.configuration.getShouldRepeat().booleanValue()) {
                this.setupWithoutRepeat();
                return;
            }
            BackOff backOff = (BackOff)this.configuration.getBackOffSupplier().get();
            Sleeper sleeper = (Sleeper)this.configuration.getSleeperSupplier().get();
            this.backoffIfNeeded(backOff, sleeper);
            Repeater<Void, Void> repeater = Repeater.builder().setBackOff(backOff).setSleeper(sleeper).setThrowableFunction(ignored -> {
                Monitoring.incIfPresent(this.setupCounter);
                this.setupTeardown.setup();
                return null;
            }).build().withBackoffCounter(this.backoffCounter).withSleeperCounter(this.sleeperCounter);
            repeater.apply(null);
        }

        @DoFn.Teardown
        public void teardown() throws @UnknownKeyFor @NonNull @Initialized UserCodeExecutionException {
            BackOff backOff = (BackOff)this.configuration.getBackOffSupplier().get();
            Sleeper sleeper = (Sleeper)this.configuration.getSleeperSupplier().get();
            this.backoffIfNeeded(backOff, sleeper);
            if (!this.configuration.getShouldRepeat().booleanValue()) {
                Monitoring.incIfPresent(this.teardownCounter);
                this.setupTeardown.teardown();
                return;
            }
            Repeater<Void, Void> repeater = Repeater.builder().setBackOff(backOff).setSleeper(sleeper).setThrowableFunction(ignored -> {
                Monitoring.incIfPresent(this.teardownCounter);
                this.setupTeardown.teardown();
                return null;
            }).build().withBackoffCounter(this.backoffCounter).withSleeperCounter(this.sleeperCounter);
            repeater.apply(null);
            ((ExecutorService)Preconditions.checkStateNotNull((Object)this.executor)).shutdown();
            try {
                boolean bl = this.executor.awaitTermination(3L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @DoFn.ProcessElement
        public void process(@DoFn.Element RequestT request, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.MultiOutputReceiver receiver) {
            BackOff backOff = (BackOff)this.configuration.getBackOffSupplier().get();
            Sleeper sleeper = (Sleeper)this.configuration.getSleeperSupplier().get();
            Monitoring.incIfPresent(this.requestsCounter);
            this.backoffIfNeeded(backOff, sleeper);
            if (!this.configuration.getShouldRepeat().booleanValue()) {
                Monitoring.incIfPresent(this.callCounter);
                try {
                    ResponseT response = this.caller.call(request);
                    receiver.get(this.responseTag).output(response);
                    Monitoring.incIfPresent(this.responsesCounter);
                }
                catch (UserCodeExecutionException e) {
                    Monitoring.incIfPresent(this.failuresCounter);
                    receiver.get(this.failureTag).output((Object)ApiIOError.of(e, request));
                }
                return;
            }
            Repeater<Object, Object> repeater = Repeater.builder().setSleeper(sleeper).setBackOff(backOff).setThrowableFunction(this.caller::call).build().withSleeperCounter(this.sleeperCounter).withBackoffCounter(this.backoffCounter).withCallCounter(this.callCounter);
            try {
                Object response = repeater.apply(request);
                receiver.get(this.responseTag).output(response);
                Monitoring.incIfPresent(this.responsesCounter);
            }
            catch (UserCodeExecutionException e) {
                Monitoring.incIfPresent(this.failuresCounter);
                receiver.get(this.failureTag).output((Object)ApiIOError.of(e, request));
            }
        }

        private void backoffIfNeeded(@UnknownKeyFor @NonNull @Initialized BackOff backOff, @UnknownKeyFor @NonNull @Initialized Sleeper sleeper) {
            if (this.configuration.getCallShouldBackoff().isTrue()) {
                Monitoring.incIfPresent(this.shouldBackoffCounter);
                Monitoring.incIfPresent(this.backoffCounter);
                try {
                    Monitoring.incIfPresent(this.sleeperCounter);
                    sleeper.sleep(backOff.nextBackOffMillis());
                }
                catch (InterruptedException interruptedException) {
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

