/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.io.requestresponse;

import org.apache.beam.io.requestresponse.CallShouldBackoff;
import org.apache.beam.io.requestresponse.UserCodeExecutionException;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class CallShouldBackoffBasedOnRejectionProbability<@UnknownKeyFor ResponseT>
implements CallShouldBackoff<ResponseT> {
    private static final @UnknownKeyFor @NonNull @Initialized double DEFAULT_MULTIPLIER = 2.0;
    private @Nullable @UnknownKeyFor @Initialized Double threshold;
    private final @UnknownKeyFor @NonNull @Initialized double multiplier;
    private @UnknownKeyFor @NonNull @Initialized double requests = 0.0;
    private @UnknownKeyFor @NonNull @Initialized double accepts = 0.0;

    CallShouldBackoffBasedOnRejectionProbability() {
        this(2.0);
    }

    CallShouldBackoffBasedOnRejectionProbability(@UnknownKeyFor @NonNull @Initialized double multiplier) {
        this.multiplier = multiplier;
    }

    @UnknownKeyFor @NonNull @Initialized CallShouldBackoffBasedOnRejectionProbability<ResponseT> setThreshold(@UnknownKeyFor @NonNull @Initialized double threshold) {
        this.threshold = threshold;
        return this;
    }

    @Override
    public void update(@UnknownKeyFor @NonNull @Initialized UserCodeExecutionException exception) {
        this.requests += 1.0;
    }

    @Override
    public void update(ResponseT response) {
        this.requests += 1.0;
        this.accepts += 1.0;
    }

    @UnknownKeyFor @NonNull @Initialized double getThreshold() {
        if (this.threshold != null) {
            return this.threshold;
        }
        return Math.random();
    }

    @UnknownKeyFor @NonNull @Initialized double getRejectionProbability() {
        double numerator = this.requests - this.multiplier * this.accepts;
        double denominator = this.requests + 1.0;
        double ratio = numerator / denominator;
        return Math.max(0.0, ratio);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isTrue() {
        return this.getRejectionProbability() > this.getThreshold();
    }
}

