/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.io.requestresponse;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Optional;
import org.apache.beam.io.requestresponse.AutoValue_Monitoring;
import org.apache.beam.io.requestresponse.CallShouldBackoff;
import org.apache.beam.io.requestresponse.Caller;
import org.apache.beam.io.requestresponse.SetupTeardown;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.util.BackOff;
import org.apache.beam.sdk.util.Sleeper;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.CaseFormat;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoValue
public abstract class Monitoring
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized String SEPARATOR = "_";
    static final @UnknownKeyFor @NonNull @Initialized String REQUESTS_COUNTER_NAME = "requests";
    static final @UnknownKeyFor @NonNull @Initialized String RESPONSES_COUNTER_NAME = "responses";
    static final @UnknownKeyFor @NonNull @Initialized String FAILURES_COUNTER_NAME = "failures";
    static final @UnknownKeyFor @NonNull @Initialized String CACHE_READ_REQUESTS_COUNTER_NAME = Monitoring.metricNameOf("cache", "read", "requests");
    static final @UnknownKeyFor @NonNull @Initialized String CACHE_READ_NULL_COUNTER_NAME = Monitoring.metricNameOf("cache", "read", "nulls");
    static final @UnknownKeyFor @NonNull @Initialized String CACHE_READ_NON_NULL_COUNTER_NAME = Monitoring.metricNameOf("cache", "read", "non", "nulls");
    static final @UnknownKeyFor @NonNull @Initialized String CACHE_READ_FAILURES_COUNTER_NAME = Monitoring.metricNameOf("cache", "read", "failures");
    static final @UnknownKeyFor @NonNull @Initialized String CACHE_WRITE_REQUESTS_COUNTER_NAME = Monitoring.metricNameOf("cache", "write", "requests");
    static final @UnknownKeyFor @NonNull @Initialized String CACHE_WRITE_SUCCESSES_COUNTER_NAME = Monitoring.metricNameOf("cache", "write", "successes");
    static final @UnknownKeyFor @NonNull @Initialized String CACHE_WRITE_FAILURES_COUNTER_NAME = Monitoring.metricNameOf("cache", "write", "failures");
    private static final @UnknownKeyFor @NonNull @Initialized String CALL_COUNTER_NAME = Monitoring.metricNameOf("call", "invocations");
    private static final @UnknownKeyFor @NonNull @Initialized String SETUP_COUNTER_NAME = Monitoring.metricNameOf("setup", "invocations");
    private static final @UnknownKeyFor @NonNull @Initialized String TEARDOWN_COUNTER_NAME = Monitoring.metricNameOf("teardowns", "invocations");
    private static final @UnknownKeyFor @NonNull @Initialized String BACKOFF_COUNTER_NAME = "backoffs";
    private static final @UnknownKeyFor @NonNull @Initialized String SLEEPER_COUNTER_NAME = "sleeps";
    private static final @UnknownKeyFor @NonNull @Initialized String SHOULD_BACKOFF_COUNTER_NAME = Monitoring.metricNameOf("should", "backoff", "count");

    static @UnknownKeyFor @NonNull @Initialized String callCounterNameOf(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Caller<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> instance) {
        return Monitoring.metricNameOf(instance.getClass(), CALL_COUNTER_NAME);
    }

    static @UnknownKeyFor @NonNull @Initialized String setupCounterNameOf(@UnknownKeyFor @NonNull @Initialized SetupTeardown instance) {
        return Monitoring.metricNameOf(instance.getClass(), SETUP_COUNTER_NAME);
    }

    static @UnknownKeyFor @NonNull @Initialized String teardownCounterNameOf(@UnknownKeyFor @NonNull @Initialized SetupTeardown instance) {
        return Monitoring.metricNameOf(instance.getClass(), TEARDOWN_COUNTER_NAME);
    }

    static @UnknownKeyFor @NonNull @Initialized String backoffCounterNameOf(@UnknownKeyFor @NonNull @Initialized BackOff instance) {
        return Monitoring.metricNameOf(instance.getClass(), BACKOFF_COUNTER_NAME);
    }

    static @UnknownKeyFor @NonNull @Initialized String sleeperCounterNameOf(@UnknownKeyFor @NonNull @Initialized Sleeper instance) {
        return Monitoring.metricNameOf(instance.getClass(), SLEEPER_COUNTER_NAME);
    }

    static @UnknownKeyFor @NonNull @Initialized String shouldBackoffCounterName(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized CallShouldBackoff<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> instance) {
        return Monitoring.metricNameOf(instance.getClass(), SHOULD_BACKOFF_COUNTER_NAME);
    }

    private static @UnknownKeyFor @NonNull @Initialized String metricNameOf(String ... segments) {
        return String.join((CharSequence)SEPARATOR, Arrays.asList(segments));
    }

    private static @UnknownKeyFor @NonNull @Initialized String metricNameOf(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> clazz, @UnknownKeyFor @NonNull @Initialized String suffix) {
        String simpleName = (String)CaseFormat.UPPER_CAMEL.converterTo(CaseFormat.LOWER_UNDERSCORE).convert((Object)clazz.getSimpleName());
        return simpleName + SEPARATOR + suffix;
    }

    public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
        return new AutoValue_Monitoring.Builder();
    }

    public abstract @UnknownKeyFor @NonNull @Initialized Boolean getCountRequests();

    public abstract @UnknownKeyFor @NonNull @Initialized Boolean getCountResponses();

    public abstract @UnknownKeyFor @NonNull @Initialized Boolean getCountCalls();

    public abstract @UnknownKeyFor @NonNull @Initialized Boolean getCountFailures();

    public abstract @UnknownKeyFor @NonNull @Initialized Boolean getCountSetup();

    public abstract @UnknownKeyFor @NonNull @Initialized Boolean getCountTeardown();

    public abstract @UnknownKeyFor @NonNull @Initialized Boolean getCountBackoffs();

    public abstract @UnknownKeyFor @NonNull @Initialized Boolean getCountSleeps();

    public abstract @UnknownKeyFor @NonNull @Initialized Boolean getCountShouldBackoff();

    public abstract @UnknownKeyFor @NonNull @Initialized Boolean getCountCacheReadRequests();

    public abstract @UnknownKeyFor @NonNull @Initialized Boolean getCountCacheReadNulls();

    public abstract @UnknownKeyFor @NonNull @Initialized Boolean getCountCacheReadNonNulls();

    public abstract @UnknownKeyFor @NonNull @Initialized Boolean getCountCacheReadFailures();

    public abstract @UnknownKeyFor @NonNull @Initialized Boolean getCountCacheWriteRequests();

    public abstract @UnknownKeyFor @NonNull @Initialized Boolean getCountCacheWriteSuccesses();

    public abstract @UnknownKeyFor @NonNull @Initialized Boolean getCountCacheWriteFailures();

    public @UnknownKeyFor @NonNull @Initialized Monitoring withEverythingCounted() {
        return this.toBuilder().setCountRequests(true).setCountResponses(true).setCountCalls(true).setCountFailures(true).setCountSetup(true).setCountTeardown(true).setCountBackoffs(true).setCountSleeps(true).setCountShouldBackoff(true).build().withCountCaching(true);
    }

    public @UnknownKeyFor @NonNull @Initialized Monitoring withEverythingCountedExceptedCaching() {
        return this.withEverythingCounted().withCountCaching(false);
    }

    private @UnknownKeyFor @NonNull @Initialized Monitoring withCountCaching(@UnknownKeyFor @NonNull @Initialized boolean value) {
        return this.toBuilder().setCountCacheReadRequests(value).setCountCacheReadNulls(value).setCountCacheReadNonNulls(value).setCountCacheReadFailures(value).setCountCacheWriteRequests(value).setCountCacheWriteSuccesses(value).setCountCacheWriteFailures(value).build();
    }

    public abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

    static void incIfPresent(@Nullable @UnknownKeyFor @Initialized Counter counter) {
        if (counter != null) {
            counter.inc();
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract @UnknownKeyFor @NonNull @Initialized Builder setCountRequests(@UnknownKeyFor @NonNull @Initialized Boolean var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setCountResponses(@UnknownKeyFor @NonNull @Initialized Boolean var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setCountCalls(@UnknownKeyFor @NonNull @Initialized Boolean var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setCountFailures(@UnknownKeyFor @NonNull @Initialized Boolean var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setCountSetup(@UnknownKeyFor @NonNull @Initialized Boolean var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setCountTeardown(@UnknownKeyFor @NonNull @Initialized Boolean var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setCountBackoffs(@UnknownKeyFor @NonNull @Initialized Boolean var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setCountSleeps(@UnknownKeyFor @NonNull @Initialized Boolean var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setCountShouldBackoff(@UnknownKeyFor @NonNull @Initialized Boolean var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setCountCacheReadRequests(@UnknownKeyFor @NonNull @Initialized Boolean var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setCountCacheReadNulls(@UnknownKeyFor @NonNull @Initialized Boolean var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setCountCacheReadNonNulls(@UnknownKeyFor @NonNull @Initialized Boolean var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setCountCacheReadFailures(@UnknownKeyFor @NonNull @Initialized Boolean var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setCountCacheWriteRequests(@UnknownKeyFor @NonNull @Initialized Boolean var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setCountCacheWriteSuccesses(@UnknownKeyFor @NonNull @Initialized Boolean var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setCountCacheWriteFailures(@UnknownKeyFor @NonNull @Initialized Boolean var1);

        abstract @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Boolean> getCountRequests();

        abstract @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Boolean> getCountResponses();

        abstract @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Boolean> getCountCalls();

        abstract @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Boolean> getCountFailures();

        abstract @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Boolean> getCountSetup();

        abstract @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Boolean> getCountTeardown();

        abstract @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Boolean> getCountBackoffs();

        abstract @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Boolean> getCountSleeps();

        abstract @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Boolean> getCountShouldBackoff();

        abstract @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Boolean> getCountCacheReadRequests();

        abstract @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Boolean> getCountCacheReadNulls();

        abstract @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Boolean> getCountCacheReadNonNulls();

        abstract @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Boolean> getCountCacheReadFailures();

        abstract @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Boolean> getCountCacheWriteRequests();

        abstract @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Boolean> getCountCacheWriteSuccesses();

        abstract @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Boolean> getCountCacheWriteFailures();

        abstract @UnknownKeyFor @NonNull @Initialized Monitoring autoBuild();

        public final @UnknownKeyFor @NonNull @Initialized Monitoring build() {
            if (!this.getCountRequests().isPresent()) {
                this.setCountRequests(false);
            }
            if (!this.getCountResponses().isPresent()) {
                this.setCountResponses(false);
            }
            if (!this.getCountCalls().isPresent()) {
                this.setCountCalls(false);
            }
            if (!this.getCountFailures().isPresent()) {
                this.setCountFailures(false);
            }
            if (!this.getCountSetup().isPresent()) {
                this.setCountSetup(false);
            }
            if (!this.getCountTeardown().isPresent()) {
                this.setCountTeardown(false);
            }
            if (!this.getCountBackoffs().isPresent()) {
                this.setCountBackoffs(false);
            }
            if (!this.getCountSleeps().isPresent()) {
                this.setCountSleeps(false);
            }
            if (!this.getCountShouldBackoff().isPresent()) {
                this.setCountShouldBackoff(false);
            }
            if (!this.getCountCacheReadRequests().isPresent()) {
                this.setCountCacheReadRequests(false);
            }
            if (!this.getCountCacheReadNulls().isPresent()) {
                this.setCountCacheReadNulls(false);
            }
            if (!this.getCountCacheReadNonNulls().isPresent()) {
                this.setCountCacheReadNonNulls(false);
            }
            if (!this.getCountCacheReadFailures().isPresent()) {
                this.setCountCacheReadFailures(false);
            }
            if (!this.getCountCacheWriteRequests().isPresent()) {
                this.setCountCacheWriteRequests(false);
            }
            if (!this.getCountCacheWriteSuccesses().isPresent()) {
                this.setCountCacheWriteSuccesses(false);
            }
            if (!this.getCountCacheWriteFailures().isPresent()) {
                this.setCountCacheWriteFailures(false);
            }
            return this.autoBuild();
        }
    }
}

