/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.io.requestresponse;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.util.Set;
import org.apache.beam.io.requestresponse.ApiIOError;
import org.apache.beam.io.requestresponse.AutoValue_RequestResponseIO_Configuration;
import org.apache.beam.io.requestresponse.Call;
import org.apache.beam.io.requestresponse.CallShouldBackoff;
import org.apache.beam.io.requestresponse.CallShouldBackoffBasedOnRejectionProbability;
import org.apache.beam.io.requestresponse.Caller;
import org.apache.beam.io.requestresponse.DefaultSerializableBackoffSupplier;
import org.apache.beam.io.requestresponse.Monitoring;
import org.apache.beam.io.requestresponse.Result;
import org.apache.beam.io.requestresponse.SetupTeardown;
import org.apache.beam.io.requestresponse.UserCodeExecutionException;
import org.apache.beam.io.requestresponse.UserCodeQuotaException;
import org.apache.beam.io.requestresponse.UserCodeRemoteSystemException;
import org.apache.beam.io.requestresponse.UserCodeTimeoutException;
import org.apache.beam.repackaged.core.org.apache.commons.lang3.tuple.Pair;
import org.apache.beam.repackaged.core.org.apache.commons.lang3.tuple.Triple;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.Keys;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.Partition;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.util.BackOff;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.util.SerializableSupplier;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.util.Sleeper;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

public class RequestResponseIO<@UnknownKeyFor RequestT, @UnknownKeyFor ResponseT>
extends PTransform<PCollection<RequestT>, Result<ResponseT>> {
    public static final @UnknownKeyFor @NonNull @Initialized Duration DEFAULT_TIMEOUT = Duration.standardSeconds((long)30L);
    public static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized UserCodeExecutionException>> REPEATABLE_ERROR_TYPES = ImmutableSet.of(UserCodeRemoteSystemException.class, UserCodeTimeoutException.class, UserCodeQuotaException.class);
    private static final @UnknownKeyFor @NonNull @Initialized String CALL_NAME = Call.class.getSimpleName();
    private static final @UnknownKeyFor @NonNull @Initialized String CACHE_READ_NAME = "CacheRead";
    private static final @UnknownKeyFor @NonNull @Initialized String CACHE_WRITE_NAME = "CacheWrite";
    private final @UnknownKeyFor @NonNull @Initialized TupleTag<ResponseT> responseTag = new TupleTag<ResponseT>(){};
    private final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized ApiIOError> failureTag = new TupleTag<ApiIOError>(){};
    private final @UnknownKeyFor @NonNull @Initialized Configuration<RequestT, ResponseT> rrioConfiguration;
    private final @UnknownKeyFor @NonNull @Initialized Call.Configuration<RequestT, ResponseT> callConfiguration;

    private RequestResponseIO(@UnknownKeyFor @NonNull @Initialized Configuration<RequestT, ResponseT> rrioConfiguration, @UnknownKeyFor @NonNull @Initialized Call.Configuration<RequestT, ResponseT> callConfiguration) {
        this.rrioConfiguration = rrioConfiguration;
        this.callConfiguration = callConfiguration;
    }

    public static <RequestT, ResponseT> @UnknownKeyFor @NonNull @Initialized RequestResponseIO<RequestT, ResponseT> of(@UnknownKeyFor @NonNull @Initialized Caller<RequestT, ResponseT> caller, @UnknownKeyFor @NonNull @Initialized Coder<ResponseT> responseTCoder) {
        caller = (Caller)SerializableUtils.ensureSerializable(caller);
        return super.withDefaults();
    }

    public static <RequestT, ResponseT, CallerSetupTeardownT extends Caller<RequestT, ResponseT> & SetupTeardown> @UnknownKeyFor @NonNull @Initialized RequestResponseIO<RequestT, ResponseT> ofCallerAndSetupTeardown(CallerSetupTeardownT implementsCallerAndSetupTeardown, @UnknownKeyFor @NonNull @Initialized Coder<ResponseT> responseTCoder) {
        implementsCallerAndSetupTeardown = (Caller)SerializableUtils.ensureSerializable(implementsCallerAndSetupTeardown);
        return super.withDefaults();
    }

    private @UnknownKeyFor @NonNull @Initialized RequestResponseIO<RequestT, ResponseT> withDefaults() {
        return super.shouldRepeat(true).withBackOffSupplier(new DefaultSerializableBackoffSupplier()).withSleeperSupplier((SerializableSupplier<Sleeper>)(SerializableSupplier & Serializable)() -> Sleeper.DEFAULT).withCallShouldBackoff(new CallShouldBackoffBasedOnRejectionProbability());
    }

    public @UnknownKeyFor @NonNull @Initialized RequestResponseIO<RequestT, ResponseT> withTimeout(@UnknownKeyFor @NonNull @Initialized Duration value) {
        return new RequestResponseIO<RequestT, ResponseT>(this.rrioConfiguration, this.callConfiguration.toBuilder().setTimeout(value).build());
    }

    public @UnknownKeyFor @NonNull @Initialized RequestResponseIO<RequestT, ResponseT> withoutRepeater() {
        return this.shouldRepeat(false);
    }

    private @UnknownKeyFor @NonNull @Initialized RequestResponseIO<RequestT, ResponseT> shouldRepeat(@UnknownKeyFor @NonNull @Initialized boolean value) {
        return new RequestResponseIO<RequestT, ResponseT>(this.rrioConfiguration, this.callConfiguration.toBuilder().setShouldRepeat(value).build());
    }

    public @UnknownKeyFor @NonNull @Initialized RequestResponseIO<RequestT, ResponseT> withCallShouldBackoff(@UnknownKeyFor @NonNull @Initialized CallShouldBackoff<ResponseT> value) {
        return new RequestResponseIO<RequestT, ResponseT>(this.rrioConfiguration, this.callConfiguration.toBuilder().setCallShouldBackoff(value).build());
    }

    @UnknownKeyFor @NonNull @Initialized RequestResponseIO<RequestT, ResponseT> withSleeperSupplier(@UnknownKeyFor @NonNull @Initialized SerializableSupplier<@UnknownKeyFor @NonNull @Initialized Sleeper> value) {
        return new RequestResponseIO<RequestT, ResponseT>(this.rrioConfiguration, this.callConfiguration.toBuilder().setSleeperSupplier(value).build());
    }

    @UnknownKeyFor @NonNull @Initialized RequestResponseIO<RequestT, ResponseT> withBackOffSupplier(@UnknownKeyFor @NonNull @Initialized SerializableSupplier<@UnknownKeyFor @NonNull @Initialized BackOff> value) {
        return new RequestResponseIO<RequestT, ResponseT>(this.rrioConfiguration, this.callConfiguration.toBuilder().setBackOffSupplier(value).build());
    }

    public @UnknownKeyFor @NonNull @Initialized RequestResponseIO<RequestT, ResponseT> withCache( @UnknownKeyFor @NonNull @Initialized Cache.Pair<RequestT, ResponseT> pair) {
        return new RequestResponseIO<RequestT, ResponseT>(this.rrioConfiguration.toBuilder().setCacheRead(pair.getRead()).setCacheWrite(pair.getWrite()).build(), this.callConfiguration);
    }

    public @UnknownKeyFor @NonNull @Initialized RequestResponseIO<RequestT, ResponseT> withMonitoringConfiguration(@UnknownKeyFor @NonNull @Initialized Monitoring value) {
        return new RequestResponseIO<RequestT, ResponseT>(this.rrioConfiguration, this.callConfiguration.toBuilder().setMonitoringConfiguration(value).build());
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized Call.Configuration<RequestT, ResponseT> getCallConfiguration() {
        return this.callConfiguration;
    }

    public @UnknownKeyFor @NonNull @Initialized Result<ResponseT> expand(@UnknownKeyFor @NonNull @Initialized PCollection<RequestT> input) {
        PCollectionList responseList = PCollectionList.empty((Pipeline)input.getPipeline());
        PCollectionList failureList = PCollectionList.empty((Pipeline)input.getPipeline());
        Triple<PCollection<RequestT>, PCollectionList<ResponseT>, PCollectionList<ApiIOError>> cacheRead = this.expandCacheRead(input, responseList, (PCollectionList<ApiIOError>)failureList);
        input = (PCollection)cacheRead.getLeft();
        responseList = (PCollectionList)cacheRead.getMiddle();
        failureList = (PCollectionList)cacheRead.getRight();
        Pair<PCollectionList<ResponseT>, PCollectionList<ApiIOError>> call = this.expandCallWithOptionalCacheWrites(input, responseList, (PCollectionList<ApiIOError>)failureList);
        responseList = (PCollectionList)call.getLeft();
        failureList = (PCollectionList)call.getRight();
        PCollection responses = (PCollection)responseList.apply("FlattenResponses", (PTransform)Flatten.pCollections());
        PCollection failures = (PCollection)failureList.apply("FlattenErrors", (PTransform)Flatten.pCollections());
        PCollectionTuple pct = PCollectionTuple.of(this.responseTag, (PCollection)responses).and(this.failureTag, failures);
        return Result.of(responses.getCoder(), this.responseTag, this.failureTag, pct);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Triple<@UnknownKeyFor @NonNull @Initialized PCollection<RequestT>, @UnknownKeyFor @NonNull @Initialized PCollectionList<ResponseT>, @UnknownKeyFor @NonNull @Initialized PCollectionList<@UnknownKeyFor @NonNull @Initialized ApiIOError>> expandCacheRead(@UnknownKeyFor @NonNull @Initialized PCollection<RequestT> input, @UnknownKeyFor @NonNull @Initialized PCollectionList<ResponseT> responseList, @UnknownKeyFor @NonNull @Initialized PCollectionList<@UnknownKeyFor @NonNull @Initialized ApiIOError> failureList) {
        if (this.rrioConfiguration.getCacheRead() == null) {
            return Triple.of(input, responseList, failureList);
        }
        @Nullable Result cacheReadResult = (Result)input.apply(CACHE_READ_NAME, (PTransform)Preconditions.checkStateNotNull(this.rrioConfiguration.getCacheRead()));
        PCollectionList cacheReadList = (PCollectionList)cacheReadResult.getResponses().apply("PartitionCacheReads", (PTransform)Partition.of((int)2, new PartitionCacheReadsFn()));
        input = (PCollection)cacheReadList.get(1).apply("UncachedRequests", (PTransform)Keys.create());
        responseList = responseList.and((PCollection)cacheReadList.get(0).apply("CachedResponses", (PTransform)Values.create()));
        failureList = failureList.and(cacheReadResult.getFailures());
        return Triple.of((Object)input, (Object)responseList, (Object)failureList);
    }

    @UnknownKeyFor @NonNull @Initialized Pair<@UnknownKeyFor @NonNull @Initialized PCollectionList<ResponseT>, @UnknownKeyFor @NonNull @Initialized PCollectionList<@UnknownKeyFor @NonNull @Initialized ApiIOError>> expandCallWithOptionalCacheWrites(@UnknownKeyFor @NonNull @Initialized PCollection<RequestT> input, @UnknownKeyFor @NonNull @Initialized PCollectionList<ResponseT> responseList, @UnknownKeyFor @NonNull @Initialized PCollectionList<@UnknownKeyFor @NonNull @Initialized ApiIOError> failureList) {
        if (this.rrioConfiguration.getCacheWrite() == null) {
            Call<RequestT, ResponseT> call = Call.of(this.callConfiguration);
            Result result = (Result)input.apply(CALL_NAME, call);
            return Pair.of((Object)responseList.and(result.getResponses()), (Object)failureList.and(result.getFailures()));
        }
        WrappedAssociatingRequestResponseCaller caller = new WrappedAssociatingRequestResponseCaller(this.callConfiguration.getCaller());
        KvCoder coder = KvCoder.of((Coder)input.getCoder(), this.rrioConfiguration.getResponseTCoder());
        Call.Configuration configuration = Call.Configuration.builder().setResponseCoder(coder).setCaller(caller).setSetupTeardown(this.callConfiguration.getSetupTeardown()).setBackOffSupplier(this.callConfiguration.getBackOffSupplier()).setCallShouldBackoff(new WrappedAssociatingRequestResponseCallShouldBackoff(this.callConfiguration.getCallShouldBackoff())).setShouldRepeat(this.callConfiguration.getShouldRepeat()).setSleeperSupplier(this.callConfiguration.getSleeperSupplier()).setTimeout(this.callConfiguration.getTimeout()).build();
        Call call = Call.of(configuration);
        Result result = (Result)input.apply(CALL_NAME, call);
        PCollection responses = (PCollection)result.getResponses().apply(CALL_NAME + "Responses", (PTransform)Values.create());
        responseList = responseList.and(responses);
        failureList = failureList.and(result.getFailures());
        Result cacheWriteResult = (Result)result.getResponses().apply(CACHE_WRITE_NAME, (PTransform)Preconditions.checkStateNotNull(this.rrioConfiguration.getCacheWrite()));
        failureList = failureList.and(cacheWriteResult.getFailures());
        return Pair.of((Object)responseList, (Object)failureList);
    }

    private static class WrappedAssociatingRequestResponseCallShouldBackoff<@UnknownKeyFor RequestT, @UnknownKeyFor ResponseT>
    implements CallShouldBackoff<KV<RequestT, ResponseT>> {
        private final @UnknownKeyFor @NonNull @Initialized CallShouldBackoff<ResponseT> basis;

        private WrappedAssociatingRequestResponseCallShouldBackoff(@UnknownKeyFor @NonNull @Initialized CallShouldBackoff<ResponseT> basis) {
            this.basis = basis;
        }

        @Override
        public void update(@UnknownKeyFor @NonNull @Initialized UserCodeExecutionException exception) {
            this.basis.update(exception);
        }

        @Override
        public void update(@UnknownKeyFor @NonNull @Initialized KV<RequestT, ResponseT> response) {
            this.basis.update(response.getValue());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean isTrue() {
            return this.basis.isTrue();
        }
    }

    private static class WrappedAssociatingRequestResponseCaller<@UnknownKeyFor RequestT, @UnknownKeyFor ResponseT>
    implements Caller<RequestT, KV<RequestT, ResponseT>> {
        private final @UnknownKeyFor @NonNull @Initialized Caller<RequestT, ResponseT> caller;

        private WrappedAssociatingRequestResponseCaller(@UnknownKeyFor @NonNull @Initialized Caller<RequestT, ResponseT> caller) {
            this.caller = caller;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized KV<RequestT, ResponseT> call(RequestT request) throws @UnknownKeyFor @NonNull @Initialized UserCodeExecutionException {
            ResponseT response = this.caller.call(request);
            return KV.of(request, response);
        }
    }

    private static class PartitionCacheReadsFn<@UnknownKeyFor RequestT, @UnknownKeyFor ResponseT>
    implements Partition.PartitionFn<KV<RequestT, ResponseT>> {
        private static final @UnknownKeyFor @NonNull @Initialized int NUM_PARTITIONS = 2;
        private static final @UnknownKeyFor @NonNull @Initialized int NON_NULL_PARTITION = 0;
        private static final @UnknownKeyFor @NonNull @Initialized int NULL_PARTITION = 1;

        private PartitionCacheReadsFn() {
        }

        public @UnknownKeyFor @NonNull @Initialized int partitionFor(@UnknownKeyFor @NonNull @Initialized KV<RequestT, ResponseT> elem, @UnknownKeyFor @NonNull @Initialized int numPartitions) {
            if (((KV)Preconditions.checkStateNotNull(elem)).getValue() != null) {
                return 0;
            }
            return 1;
        }
    }

    @AutoValue
    static abstract class Configuration<@UnknownKeyFor RequestT, @UnknownKeyFor ResponseT> {
        Configuration() {
        }

        static <RequestT, ResponseT> @UnknownKeyFor @NonNull @Initialized Builder<RequestT, ResponseT> builder() {
            return new AutoValue_RequestResponseIO_Configuration.Builder();
        }

        abstract @UnknownKeyFor @NonNull @Initialized Coder<ResponseT> getResponseTCoder();

        abstract @Nullable @UnknownKeyFor @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<RequestT>, @UnknownKeyFor @NonNull @Initialized Result<@UnknownKeyFor @NonNull @Initialized KV<RequestT, @Nullable ResponseT>>> getCacheRead();

        abstract @Nullable @UnknownKeyFor @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<RequestT, ResponseT>>, @UnknownKeyFor @NonNull @Initialized Result<@UnknownKeyFor @NonNull @Initialized KV<RequestT, ResponseT>>> getCacheWrite();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<RequestT, ResponseT> toBuilder();

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor RequestT, @UnknownKeyFor ResponseT> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<RequestT, ResponseT> setResponseTCoder(@UnknownKeyFor @NonNull @Initialized Coder<ResponseT> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<RequestT, ResponseT> setCacheRead(@UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<RequestT>, @UnknownKeyFor @NonNull @Initialized Result<@UnknownKeyFor @NonNull @Initialized KV<RequestT, @Nullable ResponseT>>> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<RequestT, ResponseT> setCacheWrite(@UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<RequestT, ResponseT>>, @UnknownKeyFor @NonNull @Initialized Result<@UnknownKeyFor @NonNull @Initialized KV<RequestT, ResponseT>>> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Configuration<RequestT, ResponseT> build();
        }
    }
}

