/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.io.requestresponse;

import java.util.Map;
import org.apache.beam.io.requestresponse.ApiIOError;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class Result<@UnknownKeyFor ResponseT>
implements POutput {
    private final @UnknownKeyFor @NonNull @Initialized Pipeline pipeline;
    private final @UnknownKeyFor @NonNull @Initialized TupleTag<ResponseT> responseTag;
    private final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized ApiIOError> failureTag;
    private final @UnknownKeyFor @NonNull @Initialized PCollection<ResponseT> responses;
    private final @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized ApiIOError> failures;

    static <ResponseT> @UnknownKeyFor @NonNull @Initialized Result<ResponseT> of(@UnknownKeyFor @NonNull @Initialized Coder<ResponseT> responseTCoder, @UnknownKeyFor @NonNull @Initialized TupleTag<ResponseT> responseTag, @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized ApiIOError> failureTag, @UnknownKeyFor @NonNull @Initialized PCollectionTuple pct) {
        return new Result<ResponseT>(responseTCoder, responseTag, pct, failureTag);
    }

    private Result(@UnknownKeyFor @NonNull @Initialized Coder<ResponseT> responseTCoder, @UnknownKeyFor @NonNull @Initialized TupleTag<ResponseT> responseTag, @UnknownKeyFor @NonNull @Initialized PCollectionTuple pct, @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized ApiIOError> failureTag) {
        this.pipeline = pct.getPipeline();
        this.responseTag = responseTag;
        this.failureTag = failureTag;
        this.responses = pct.get(responseTag).setCoder(responseTCoder);
        this.failures = pct.get(this.failureTag);
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<ResponseT> getResponses() {
        return this.responses;
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized ApiIOError> getFailures() {
        return this.failures;
    }

    public @UnknownKeyFor @NonNull @Initialized Pipeline getPipeline() {
        return this.pipeline;
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PValue> expand() {
        return ImmutableMap.of(this.responseTag, this.responses, this.failureTag, this.failures);
    }

    public void finishSpecifyingOutput(@UnknownKeyFor @NonNull @Initialized String transformName, @UnknownKeyFor @NonNull @Initialized PInput input, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
    }
}

