/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.io.requestresponse;

import org.apache.beam.io.requestresponse.CallShouldBackoff;
import org.apache.beam.io.requestresponse.UserCodeExecutionException;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.util.SerializableSupplier;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;

class WindowedCallShouldBackoff<@UnknownKeyFor ResponseT>
implements CallShouldBackoff<ResponseT> {
    private final @UnknownKeyFor @NonNull @Initialized Duration window;
    private final @UnknownKeyFor @NonNull @Initialized SerializableSupplier<@UnknownKeyFor @NonNull @Initialized CallShouldBackoff<ResponseT>> callShouldBackoffSupplier;
    private @MonotonicNonNull @UnknownKeyFor @Initialized CallShouldBackoff<ResponseT> basis;
    private @UnknownKeyFor @NonNull @Initialized Instant nextReset;

    WindowedCallShouldBackoff(@UnknownKeyFor @NonNull @Initialized Duration window, @UnknownKeyFor @NonNull @Initialized SerializableSupplier<@UnknownKeyFor @NonNull @Initialized CallShouldBackoff<ResponseT>> callShouldBackoffSupplier) {
        this.window = window;
        this.callShouldBackoffSupplier = callShouldBackoffSupplier;
        this.basis = (CallShouldBackoff)callShouldBackoffSupplier.get();
        this.nextReset = Instant.now().plus((ReadableDuration)window);
    }

    private void resetIfNeeded() {
        if (this.nextReset.isBeforeNow()) {
            this.basis = (CallShouldBackoff)this.callShouldBackoffSupplier.get();
            this.nextReset = this.nextReset.plus((ReadableDuration)this.window);
        }
    }

    @Override
    public void update(@UnknownKeyFor @NonNull @Initialized UserCodeExecutionException exception) {
        this.resetIfNeeded();
        ((CallShouldBackoff)Preconditions.checkStateNotNull(this.basis)).update(exception);
    }

    @Override
    public void update(ResponseT response) {
        this.resetIfNeeded();
        ((CallShouldBackoff)Preconditions.checkStateNotNull(this.basis)).update(response);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isTrue() {
        this.resetIfNeeded();
        return ((CallShouldBackoff)Preconditions.checkStateNotNull(this.basis)).isTrue();
    }
}

