/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.splunk;

import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.GZipEncoding;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpBackOffIOExceptionHandler;
import com.google.api.client.http.HttpBackOffUnsuccessfulResponseHandler;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpEncoding;
import com.google.api.client.http.HttpIOExceptionHandler;
import com.google.api.client.http.HttpMediaType;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.api.client.http.apache.v2.ApacheHttpTransport;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.ExponentialBackOff;
import com.google.auto.value.AutoValue;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.beam.sdk.io.splunk.AutoValue_HttpEventPublisher;
import org.apache.beam.sdk.io.splunk.CustomX509TrustManager;
import org.apache.beam.sdk.io.splunk.SplunkEvent;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoValue
abstract class HttpEventPublisher {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(HttpEventPublisher.class);
    private static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_MAX_CONNECTIONS = 1;
    private static final @UnknownKeyFor @NonNull @Initialized boolean DEFAULT_DISABLE_CERTIFICATE_VALIDATION = false;
    private static final @UnknownKeyFor @NonNull @Initialized Gson GSON = new GsonBuilder().setFieldNamingStrategy(f -> f.getName().toLowerCase()).create();
    @VisibleForTesting
    static final @UnknownKeyFor @NonNull @Initialized String HEC_URL_PATH = "services/collector/event";
    private static final @UnknownKeyFor @NonNull @Initialized HttpMediaType MEDIA_TYPE = new HttpMediaType("application/json;profile=urn:splunk:event:1.0;charset=utf-8");
    private static final @UnknownKeyFor @NonNull @Initialized String CONTENT_TYPE = Joiner.on((char)'/').join((Object)MEDIA_TYPE.getType(), (Object)MEDIA_TYPE.getSubType(), new Object[0]);
    private static final @UnknownKeyFor @NonNull @Initialized String AUTHORIZATION_SCHEME = "Splunk %s";
    private static final @UnknownKeyFor @NonNull @Initialized String HTTPS_PROTOCOL_PREFIX = "https";

    HttpEventPublisher() {
    }

    static @UnknownKeyFor @NonNull @Initialized Builder newBuilder() {
        return new AutoValue_HttpEventPublisher.Builder();
    }

    abstract @UnknownKeyFor @NonNull @Initialized ApacheHttpTransport transport();

    abstract @UnknownKeyFor @NonNull @Initialized HttpRequestFactory requestFactory();

    abstract @UnknownKeyFor @NonNull @Initialized GenericUrl genericUrl();

    abstract @UnknownKeyFor @NonNull @Initialized String token();

    abstract @Nullable @UnknownKeyFor @Initialized Integer maxElapsedMillis();

    abstract @UnknownKeyFor @NonNull @Initialized byte @Nullable @UnknownKeyFor @Initialized [] rootCaCertificate();

    abstract @UnknownKeyFor @NonNull @Initialized Boolean disableCertificateValidation();

    abstract @UnknownKeyFor @NonNull @Initialized Boolean enableGzipHttpCompression();

    @UnknownKeyFor @NonNull @Initialized HttpResponse execute(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SplunkEvent> events) throws @UnknownKeyFor @NonNull @Initialized IOException {
        HttpContent content = this.getContent(events);
        HttpRequest request = this.requestFactory().buildPostRequest(this.genericUrl(), content);
        if (this.enableGzipHttpCompression().booleanValue()) {
            request.setEncoding((HttpEncoding)new GZipEncoding());
        }
        HttpBackOffUnsuccessfulResponseHandler responseHandler = new HttpBackOffUnsuccessfulResponseHandler((BackOff)this.getConfiguredBackOff());
        responseHandler.setBackOffRequired(HttpBackOffUnsuccessfulResponseHandler.BackOffRequired.ON_SERVER_ERROR);
        request.setUnsuccessfulResponseHandler((HttpUnsuccessfulResponseHandler)responseHandler);
        HttpBackOffIOExceptionHandler ioExceptionHandler = new HttpBackOffIOExceptionHandler((BackOff)this.getConfiguredBackOff());
        request.setIOExceptionHandler((HttpIOExceptionHandler)ioExceptionHandler);
        this.setHeaders(request, this.token());
        return request.execute();
    }

    @UnknownKeyFor @NonNull @Initialized HttpResponse execute(@UnknownKeyFor @NonNull @Initialized SplunkEvent event) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return this.execute((List<SplunkEvent>)ImmutableList.of((Object)event));
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized ExponentialBackOff getConfiguredBackOff() {
        return new ExponentialBackOff.Builder().setMaxElapsedTimeMillis(this.maxElapsedMillis().intValue()).build();
    }

    void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (this.transport() != null) {
            LOG.info("Closing publisher transport.");
            this.transport().shutdown();
        }
    }

    private void setHeaders(@UnknownKeyFor @NonNull @Initialized HttpRequest request, @UnknownKeyFor @NonNull @Initialized String token) {
        request.getHeaders().setAuthorization(String.format(AUTHORIZATION_SCHEME, token));
        if (this.enableGzipHttpCompression().booleanValue()) {
            request.getHeaders().setContentEncoding("gzip");
        }
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized HttpContent getContent(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SplunkEvent> events) {
        String payload = this.getStringPayload(events);
        LOG.debug("Payload content: {}", (Object)payload);
        return ByteArrayContent.fromString((String)CONTENT_TYPE, (String)payload);
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized String getStringPayload(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SplunkEvent> events) {
        StringBuilder sb = new StringBuilder();
        events.forEach(event -> sb.append(GSON.toJson(event)));
        return sb.toString();
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized Builder setTransport(@UnknownKeyFor @NonNull @Initialized ApacheHttpTransport var1);

        abstract @UnknownKeyFor @NonNull @Initialized ApacheHttpTransport transport();

        abstract @UnknownKeyFor @NonNull @Initialized Builder setRequestFactory(@UnknownKeyFor @NonNull @Initialized HttpRequestFactory var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setGenericUrl(@UnknownKeyFor @NonNull @Initialized GenericUrl var1);

        abstract @UnknownKeyFor @NonNull @Initialized GenericUrl genericUrl();

        abstract @UnknownKeyFor @NonNull @Initialized Builder setToken(@UnknownKeyFor @NonNull @Initialized String var1);

        abstract @UnknownKeyFor @NonNull @Initialized String token();

        abstract @UnknownKeyFor @NonNull @Initialized Builder setDisableCertificateValidation(@UnknownKeyFor @NonNull @Initialized Boolean var1);

        abstract @UnknownKeyFor @NonNull @Initialized Boolean disableCertificateValidation();

        abstract @UnknownKeyFor @NonNull @Initialized Builder setRootCaCertificate(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] var1);

        abstract @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] rootCaCertificate();

        abstract @UnknownKeyFor @NonNull @Initialized Builder setEnableGzipHttpCompression(@UnknownKeyFor @NonNull @Initialized Boolean var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setMaxElapsedMillis(@UnknownKeyFor @NonNull @Initialized Integer var1);

        abstract @UnknownKeyFor @NonNull @Initialized Integer maxElapsedMillis();

        abstract @UnknownKeyFor @NonNull @Initialized HttpEventPublisher autoBuild();

        @UnknownKeyFor @NonNull @Initialized Builder withUrl(@UnknownKeyFor @NonNull @Initialized String url) throws @UnknownKeyFor @NonNull @Initialized UnsupportedEncodingException {
            Preconditions.checkNotNull((Object)url, (Object)"withUrl(url) called with null input.");
            return this.setGenericUrl(this.getGenericUrl(url));
        }

        @UnknownKeyFor @NonNull @Initialized Builder withToken(@UnknownKeyFor @NonNull @Initialized String token) {
            Preconditions.checkNotNull((Object)token, (Object)"withToken(token) called with null input.");
            return this.setToken(token);
        }

        @UnknownKeyFor @NonNull @Initialized Builder withDisableCertificateValidation(@UnknownKeyFor @NonNull @Initialized Boolean disableCertificateValidation) {
            Preconditions.checkNotNull((Object)disableCertificateValidation, (Object)"withDisableCertificateValidation(disableCertificateValidation) called with null input.");
            return this.setDisableCertificateValidation(disableCertificateValidation);
        }

        public @UnknownKeyFor @NonNull @Initialized Builder withRootCaCertificate(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] certificate) {
            Preconditions.checkNotNull((Object)certificate, (Object)"withRootCaCertificate(certificate) called with null input.");
            return this.setRootCaCertificate(certificate);
        }

        public @UnknownKeyFor @NonNull @Initialized Builder withEnableGzipHttpCompression(@UnknownKeyFor @NonNull @Initialized Boolean enableGzipHttpCompression) {
            Preconditions.checkNotNull((Object)enableGzipHttpCompression, (Object)"withEnableGzipHttpCompression(enableGzipHttpCompression) called with null input.");
            return this.setEnableGzipHttpCompression(enableGzipHttpCompression);
        }

        @UnknownKeyFor @NonNull @Initialized Builder withMaxElapsedMillis(@UnknownKeyFor @NonNull @Initialized Integer maxElapsedMillis) {
            Preconditions.checkNotNull((Object)maxElapsedMillis, (Object)"withMaxElapsedMillis(maxElapsedMillis) called with null input.");
            return this.setMaxElapsedMillis(maxElapsedMillis);
        }

        @UnknownKeyFor @NonNull @Initialized HttpEventPublisher build() throws @UnknownKeyFor @NonNull @Initialized NoSuchAlgorithmException, @UnknownKeyFor @NonNull @Initialized KeyStoreException, @UnknownKeyFor @NonNull @Initialized KeyManagementException, @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized CertificateException {
            Preconditions.checkNotNull((Object)this.token(), (Object)"Authentication token needs to be specified via withToken(token).");
            Preconditions.checkNotNull((Object)this.genericUrl(), (Object)"URL needs to be specified via withUrl(url).");
            if (this.disableCertificateValidation() == null) {
                LOG.info("Certificate validation disabled: {}", (Object)false);
                this.setDisableCertificateValidation(false);
            }
            if (this.maxElapsedMillis() == null) {
                LOG.info("Defaulting max backoff time to: {} milliseconds ", (Object)900000);
                this.setMaxElapsedMillis(900000);
            }
            CloseableHttpClient httpClient = this.getHttpClient(1, this.disableCertificateValidation(), this.rootCaCertificate());
            this.setTransport(new ApacheHttpTransport((HttpClient)httpClient));
            this.setRequestFactory(this.transport().createRequestFactory());
            return this.autoBuild();
        }

        @UnknownKeyFor @NonNull @Initialized GenericUrl getGenericUrl(@UnknownKeyFor @NonNull @Initialized String baseUrl) {
            String url = Joiner.on((char)'/').join((Object)baseUrl, (Object)HttpEventPublisher.HEC_URL_PATH, new Object[0]);
            return new GenericUrl(url);
        }

        private @UnknownKeyFor @NonNull @Initialized CloseableHttpClient getHttpClient(@UnknownKeyFor @NonNull @Initialized int maxConnections, @UnknownKeyFor @NonNull @Initialized boolean disableCertificateValidation, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] rootCaCertificate) throws @UnknownKeyFor @NonNull @Initialized NoSuchAlgorithmException, @UnknownKeyFor @NonNull @Initialized KeyStoreException, @UnknownKeyFor @NonNull @Initialized KeyManagementException, @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized CertificateException {
            HttpClientBuilder builder = ApacheHttpTransport.newDefaultHttpClientBuilder();
            if (this.genericUrl().getScheme().equalsIgnoreCase(HttpEventPublisher.HTTPS_PROTOCOL_PREFIX)) {
                LOG.info("SSL connection requested");
                NoopHostnameVerifier hostnameVerifier = disableCertificateValidation ? NoopHostnameVerifier.INSTANCE : new DefaultHostnameVerifier();
                SSLContext sslContext = SSLContextBuilder.create().build();
                if (disableCertificateValidation) {
                    LOG.info("Certificate validation is disabled");
                    sslContext = SSLContextBuilder.create().loadTrustMaterial((org.apache.http.ssl.TrustStrategy)((TrustStrategy)(chain, authType) -> true)).build();
                } else if (rootCaCertificate != null) {
                    LOG.info("Self-Signed Certificate provided");
                    ByteArrayInputStream inStream = new ByteArrayInputStream(rootCaCertificate);
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    X509Certificate cert = (X509Certificate)cf.generateCertificate(inStream);
                    CustomX509TrustManager customTrustManager = new CustomX509TrustManager(cert);
                    sslContext.init(null, new TrustManager[]{customTrustManager}, null);
                }
                SSLConnectionSocketFactory connectionSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)hostnameVerifier);
                builder.setSSLSocketFactory((LayeredConnectionSocketFactory)connectionSocketFactory);
            }
            builder.setMaxConnTotal(maxConnections);
            builder.setDefaultRequestConfig(RequestConfig.custom().setCookieSpec("standard").build());
            return builder.build();
        }
    }
}

