/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.splunk;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.BigEndianLongCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CoderProvider;
import org.apache.beam.sdk.coders.CoderProviders;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.splunk.SplunkEvent;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.commons.io.IOUtils;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class SplunkEventCoder
extends AtomicCoder<SplunkEvent> {
    private static final @UnknownKeyFor @NonNull @Initialized SplunkEventCoder SPLUNK_EVENT_CODER = new SplunkEventCoder();
    private static final @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized SplunkEvent> TYPE_DESCRIPTOR = new TypeDescriptor<SplunkEvent>(){};
    private static final @UnknownKeyFor @NonNull @Initialized StringUtf8Coder STRING_UTF_8_CODER = StringUtf8Coder.of();
    private static final @UnknownKeyFor @NonNull @Initialized NullableCoder<@UnknownKeyFor @NonNull @Initialized String> STRING_NULLABLE_CODER = NullableCoder.of((Coder)STRING_UTF_8_CODER);
    private static final @UnknownKeyFor @NonNull @Initialized NullableCoder<@UnknownKeyFor @NonNull @Initialized Long> LONG_NULLABLE_CODER = NullableCoder.of((Coder)BigEndianLongCoder.of());
    private static final @UnknownKeyFor @NonNull @Initialized Gson GSON = new Gson();
    private static final @UnknownKeyFor @NonNull @Initialized int VERSION_3 = 3;

    public static @UnknownKeyFor @NonNull @Initialized SplunkEventCoder of() {
        return SPLUNK_EVENT_CODER;
    }

    public static @UnknownKeyFor @NonNull @Initialized CoderProvider getCoderProvider() {
        return CoderProviders.forCoder(TYPE_DESCRIPTOR, (Coder)SplunkEventCoder.of());
    }

    public void encode(@UnknownKeyFor @NonNull @Initialized SplunkEvent value, @UnknownKeyFor @NonNull @Initialized OutputStream out) throws @UnknownKeyFor @NonNull @Initialized IOException {
        out.write(3);
        LONG_NULLABLE_CODER.encode((Object)value.time(), out);
        STRING_NULLABLE_CODER.encode((Object)value.host(), out);
        STRING_NULLABLE_CODER.encode((Object)value.source(), out);
        STRING_NULLABLE_CODER.encode((Object)value.sourceType(), out);
        STRING_NULLABLE_CODER.encode((Object)value.index(), out);
        String fields = value.fields() == null ? null : value.fields().toString();
        STRING_NULLABLE_CODER.encode((Object)fields, out);
        STRING_UTF_8_CODER.encode(value.event(), out);
    }

    public @UnknownKeyFor @NonNull @Initialized SplunkEvent decode(@UnknownKeyFor @NonNull @Initialized InputStream in) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
        SplunkEvent.Builder builder = SplunkEvent.newBuilder();
        int v = in.read();
        if (v >= 2) {
            this.decodeWithVersion(v, in, builder);
        } else {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            os.write(v);
            IOUtils.copy((InputStream)in, (OutputStream)os);
            ByteArrayInputStream streamCopy = new ByteArrayInputStream(os.toByteArray());
            this.decodeVersion1or2(streamCopy, builder);
        }
        return builder.build();
    }

    private void decodeWithVersion(@UnknownKeyFor @NonNull @Initialized int version, @UnknownKeyFor @NonNull @Initialized InputStream in, @UnknownKeyFor @NonNull @Initialized SplunkEvent.Builder builder) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.decodeCommonFields(in, builder);
        if (version >= 3) {
            String fields = (String)STRING_NULLABLE_CODER.decode(in);
            if (fields != null) {
                builder.withFields((JsonObject)GSON.fromJson(fields, JsonObject.class));
            }
            String event = STRING_UTF_8_CODER.decode(in);
            builder.withEvent(event);
        }
    }

    private void decodeVersion1or2(@UnknownKeyFor @NonNull @Initialized ByteArrayInputStream in, @UnknownKeyFor @NonNull @Initialized SplunkEvent.Builder builder) throws @UnknownKeyFor @NonNull @Initialized IOException {
        String event;
        this.decodeCommonFields(in, builder);
        in.mark(Integer.MAX_VALUE);
        JsonObject fields = null;
        try {
            String fieldsString = (String)STRING_NULLABLE_CODER.decode((InputStream)in);
            if (fieldsString != null) {
                fields = (JsonObject)GSON.fromJson(fieldsString, JsonObject.class);
            }
            event = STRING_UTF_8_CODER.decode((InputStream)in);
        }
        catch (CoderException e) {
            in.reset();
            event = STRING_UTF_8_CODER.decode((InputStream)in);
        }
        if (fields != null) {
            builder.withFields(fields);
        }
        builder.withEvent(event);
    }

    private void decodeCommonFields(@UnknownKeyFor @NonNull @Initialized InputStream in, @UnknownKeyFor @NonNull @Initialized SplunkEvent.Builder builder) throws @UnknownKeyFor @NonNull @Initialized IOException {
        String index;
        String sourceType;
        String source;
        String host;
        Long time = (Long)LONG_NULLABLE_CODER.decode(in);
        if (time != null) {
            builder.withTime(time);
        }
        if ((host = (String)STRING_NULLABLE_CODER.decode(in)) != null) {
            builder.withHost(host);
        }
        if ((source = (String)STRING_NULLABLE_CODER.decode(in)) != null) {
            builder.withSource(source);
        }
        if ((sourceType = (String)STRING_NULLABLE_CODER.decode(in)) != null) {
            builder.withSourceType(sourceType);
        }
        if ((index = (String)STRING_NULLABLE_CODER.decode(in)) != null) {
            builder.withIndex(index);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized SplunkEvent> getEncodedTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }

    public void verifyDeterministic() throws // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
        throw new Coder.NonDeterministicException((Coder)this, "SplunkEvent can hold arbitrary instances, which may be non-deterministic.");
    }
}

