/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.splunk;

import com.google.auto.value.AutoValue;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.beam.sdk.io.splunk.AutoValue_SplunkIO_Write;
import org.apache.beam.sdk.io.splunk.SplunkEvent;
import org.apache.beam.sdk.io.splunk.SplunkEventWriter;
import org.apache.beam.sdk.io.splunk.SplunkWriteError;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplunkIO {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(SplunkIO.class);

    public static @UnknownKeyFor @NonNull @Initialized Write write(@UnknownKeyFor @NonNull @Initialized String url, @UnknownKeyFor @NonNull @Initialized String token) {
        Preconditions.checkNotNull((Object)url, (Object)"url is required.");
        Preconditions.checkNotNull((Object)token, (Object)"token is required.");
        return SplunkIO.write((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)url), (ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)token));
    }

    public static @UnknownKeyFor @NonNull @Initialized Write write(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> url, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> token) {
        Preconditions.checkNotNull(url, (Object)"url is required.");
        Preconditions.checkNotNull(token, (Object)"token is required.");
        return new AutoValue_SplunkIO_Write.Builder().setUrl(url).setToken(token).build();
    }

    private SplunkIO() {
    }

    @AutoValue
    public static abstract class Write
    extends PTransform<PCollection<SplunkEvent>, PCollection<SplunkWriteError>> {
        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> url();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> token();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> batchCount();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> parallelism();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Boolean> disableCertificateValidation();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> rootCaCertificatePath();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Boolean> enableBatchLogs();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Boolean> enableGzipHttpCompression();

        abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized SplunkWriteError> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized SplunkEvent> input) {
            LOG.info("Configuring SplunkEventWriter.");
            SplunkEventWriter.Builder builder = SplunkEventWriter.newBuilder().withUrl(this.url()).withInputBatchCount(this.batchCount()).withDisableCertificateValidation(this.disableCertificateValidation()).withToken(this.token()).withRootCaCertificatePath(this.rootCaCertificatePath()).withEnableBatchLogs(this.enableBatchLogs()).withEnableGzipHttpCompression(this.enableGzipHttpCompression());
            SplunkEventWriter writer = builder.build();
            LOG.info("SplunkEventWriter configured");
            return (PCollection)((PCollection)input.apply("Create KV pairs", (PTransform)CreateKeys.of(this.parallelism()))).apply("Write Splunk events", (PTransform)ParDo.of((DoFn)writer));
        }

        public @UnknownKeyFor @NonNull @Initialized Write withBatchCount(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> batchCount) {
            return this.toBuilder().setBatchCount(batchCount).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withBatchCount(@UnknownKeyFor @NonNull @Initialized Integer batchCount) {
            return this.toBuilder().setBatchCount((ValueProvider<Integer>)ValueProvider.StaticValueProvider.of((Object)batchCount)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withParallelism(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> parallelism) {
            return this.toBuilder().setParallelism(parallelism).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withParallelism(@UnknownKeyFor @NonNull @Initialized Integer parallelism) {
            return this.toBuilder().setParallelism((ValueProvider<Integer>)ValueProvider.StaticValueProvider.of((Object)parallelism)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withDisableCertificateValidation(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Boolean> disableCertificateValidation) {
            return this.toBuilder().setDisableCertificateValidation(disableCertificateValidation).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withDisableCertificateValidation(@UnknownKeyFor @NonNull @Initialized Boolean disableCertificateValidation) {
            return this.toBuilder().setDisableCertificateValidation((ValueProvider<Boolean>)ValueProvider.StaticValueProvider.of((Object)disableCertificateValidation)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withRootCaCertificatePath(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> rootCaCertificatePath) {
            return this.toBuilder().setRootCaCertificatePath(rootCaCertificatePath).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withRootCaCertificatePath(@UnknownKeyFor @NonNull @Initialized String rootCaCertificatePath) {
            return this.toBuilder().setRootCaCertificatePath((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)rootCaCertificatePath)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withEnableBatchLogs(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Boolean> enableBatchLogs) {
            return this.toBuilder().setEnableBatchLogs(enableBatchLogs).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withEnableBatchLogs(@UnknownKeyFor @NonNull @Initialized Boolean enableBatchLogs) {
            return this.toBuilder().setEnableBatchLogs((ValueProvider<Boolean>)ValueProvider.StaticValueProvider.of((Object)enableBatchLogs)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withEnableGzipHttpCompression(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Boolean> enableGzipHttpCompression) {
            return this.toBuilder().setEnableGzipHttpCompression(enableGzipHttpCompression).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withEnableGzipHttpCompression(@UnknownKeyFor @NonNull @Initialized Boolean enableGzipHttpCompression) {
            return this.toBuilder().setEnableGzipHttpCompression((ValueProvider<Boolean>)ValueProvider.StaticValueProvider.of((Object)enableGzipHttpCompression)).build();
        }

        private static class CreateKeys
        extends PTransform<PCollection<SplunkEvent>, PCollection<KV<Integer, SplunkEvent>>> {
            private static final @UnknownKeyFor @NonNull @Initialized Integer DEFAULT_PARALLELISM = 1;
            private @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> requestedKeys;

            private CreateKeys(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> requestedKeys) {
                this.requestedKeys = requestedKeys;
            }

            static @UnknownKeyFor @NonNull @Initialized CreateKeys of(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> requestedKeys) {
                return new CreateKeys(requestedKeys);
            }

            public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized SplunkEvent>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized SplunkEvent> input) {
                return (PCollection)input.apply("Inject Keys", (PTransform)ParDo.of((DoFn)new CreateKeysFn(this.requestedKeys)));
            }

            private static class CreateKeysFn
            extends DoFn<SplunkEvent, KV<Integer, SplunkEvent>> {
                private @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> specifiedParallelism;
                private @UnknownKeyFor @NonNull @Initialized Integer calculatedParallelism;

                CreateKeysFn(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> specifiedParallelism) {
                    this.specifiedParallelism = specifiedParallelism;
                }

                @DoFn.Setup
                public void setup() {
                    if (this.calculatedParallelism == null) {
                        if (this.specifiedParallelism != null) {
                            this.calculatedParallelism = (Integer)this.specifiedParallelism.get();
                        }
                        this.calculatedParallelism = (Integer)MoreObjects.firstNonNull((Object)this.calculatedParallelism, (Object)DEFAULT_PARALLELISM);
                        LOG.info("Parallelism set to: {}", (Object)this.calculatedParallelism);
                    }
                }

                @DoFn.ProcessElement
                public void processElement(/*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                // Could not load outer class - annotation placement on inner may be incorrect
                @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) {
                    context.output((Object)KV.of((Object)ThreadLocalRandom.current().nextInt(this.calculatedParallelism), (Object)((SplunkEvent)context.element())));
                }
            }
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setUrl(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setToken(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setBatchCount(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setParallelism(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Integer> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setDisableCertificateValidation(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Boolean> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setRootCaCertificatePath(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setEnableBatchLogs(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Boolean> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setEnableGzipHttpCompression(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Boolean> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Write build();
        }
    }
}

