/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.managed;

import com.google.auto.value.AutoValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.beam.model.pipeline.v1.ExternalTransforms;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.RowCoder;
import org.apache.beam.sdk.managed.AutoValue_Managed_ManagedTransform;
import org.apache.beam.sdk.managed.ManagedSchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.utils.YamlUtils;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.construction.BeamUrns;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.ProtocolMessageEnum;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class Managed {
    public static final @UnknownKeyFor @NonNull @Initialized String ICEBERG = "iceberg";
    public static final @UnknownKeyFor @NonNull @Initialized String ICEBERG_CDC = "iceberg_cdc";
    public static final @UnknownKeyFor @NonNull @Initialized String KAFKA = "kafka";
    public static final @UnknownKeyFor @NonNull @Initialized String BIGQUERY = "bigquery";
    public static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> READ_TRANSFORMS = ImmutableMap.builder().put((Object)"iceberg", (Object)BeamUrns.getUrn((ProtocolMessageEnum)ExternalTransforms.ManagedTransforms.Urns.ICEBERG_READ)).put((Object)"iceberg_cdc", (Object)BeamUrns.getUrn((ProtocolMessageEnum)ExternalTransforms.ManagedTransforms.Urns.ICEBERG_CDC_READ)).put((Object)"kafka", (Object)BeamUrns.getUrn((ProtocolMessageEnum)ExternalTransforms.ManagedTransforms.Urns.KAFKA_READ)).put((Object)"bigquery", (Object)BeamUrns.getUrn((ProtocolMessageEnum)ExternalTransforms.ManagedTransforms.Urns.BIGQUERY_READ)).build();
    public static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> WRITE_TRANSFORMS = ImmutableMap.builder().put((Object)"iceberg", (Object)BeamUrns.getUrn((ProtocolMessageEnum)ExternalTransforms.ManagedTransforms.Urns.ICEBERG_WRITE)).put((Object)"kafka", (Object)BeamUrns.getUrn((ProtocolMessageEnum)ExternalTransforms.ManagedTransforms.Urns.KAFKA_WRITE)).put((Object)"bigquery", (Object)BeamUrns.getUrn((ProtocolMessageEnum)ExternalTransforms.ManagedTransforms.Urns.BIGQUERY_WRITE)).build();

    public static @UnknownKeyFor @NonNull @Initialized ManagedTransform read(@UnknownKeyFor @NonNull @Initialized String source) {
        return new AutoValue_Managed_ManagedTransform.Builder().setIdentifier((String)Preconditions.checkNotNull((Object)READ_TRANSFORMS.get(source.toLowerCase()), (String)"An unsupported source was specified: '%s'. Please specify one of the following sources: %s", (Object)source, READ_TRANSFORMS.keySet())).setSupportedIdentifiers(new ArrayList<String>(READ_TRANSFORMS.values())).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized ManagedTransform write(@UnknownKeyFor @NonNull @Initialized String sink) {
        return new AutoValue_Managed_ManagedTransform.Builder().setIdentifier((String)Preconditions.checkNotNull((Object)WRITE_TRANSFORMS.get(sink.toLowerCase()), (String)"An unsupported sink was specified: '%s'. Please specify one of the following sinks: %s", (Object)sink, WRITE_TRANSFORMS.keySet())).setSupportedIdentifiers(new ArrayList<String>(WRITE_TRANSFORMS.values())).build();
    }

    @AutoValue
    public static abstract class ManagedTransform
    extends PTransform<PInput, PCollectionRowTuple> {
        public static final @UnknownKeyFor @NonNull @Initialized String INPUT = "input";

        abstract @UnknownKeyFor @NonNull @Initialized String getIdentifier();

        @Nullable
        abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> getConfig();

        @Nullable
        abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getConfigUrl();

        @VisibleForTesting
        abstract @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getSupportedIdentifiers();

        abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        public @UnknownKeyFor @NonNull @Initialized ManagedTransform withConfig(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> config) {
            return this.toBuilder().setConfig(config).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ManagedTransform withConfigUrl(@UnknownKeyFor @NonNull @Initialized String configUrl) {
            return this.toBuilder().setConfigUrl(configUrl).build();
        }

        @VisibleForTesting
        @UnknownKeyFor @NonNull @Initialized ManagedTransform withSupportedIdentifiers(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> supportedIdentifiers) {
            return this.toBuilder().setSupportedIdentifiers(supportedIdentifiers).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple expand(@UnknownKeyFor @NonNull @Initialized PInput input) {
            PCollectionRowTuple inputTuple = ManagedTransform.resolveInput(input);
            ManagedSchemaTransformProvider.ManagedConfig managedConfig = ManagedSchemaTransformProvider.ManagedConfig.builder().setTransformIdentifier(this.getIdentifier()).setConfig(YamlUtils.yamlStringFromMap(this.getConfig())).setConfigUrl(this.getConfigUrl()).build();
            SchemaTransform underlyingTransform = new ManagedSchemaTransformProvider(this.getSupportedIdentifiers()).from(managedConfig);
            return (PCollectionRowTuple)inputTuple.apply((PTransform)underlyingTransform);
        }

        @VisibleForTesting
        static @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple resolveInput(@UnknownKeyFor @NonNull @Initialized PInput input) {
            if (input instanceof PBegin) {
                return PCollectionRowTuple.empty((Pipeline)input.getPipeline());
            }
            if (input instanceof PCollection) {
                PCollection inputCollection = (PCollection)input;
                Preconditions.checkArgument((boolean)(inputCollection.getCoder() instanceof RowCoder), (String)"Input PCollection must contain Row elements with a set Schema (using .setRowSchema()). Instead, found collection %s with coder: %s.", (Object)inputCollection.getName(), (Object)inputCollection.getCoder());
                return PCollectionRowTuple.of((String)INPUT, (PCollection)inputCollection);
            }
            if (input instanceof PCollectionRowTuple) {
                return (PCollectionRowTuple)input;
            }
            throw new IllegalArgumentException("Unsupported input type: " + input.getClass());
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setIdentifier(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setConfig(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setConfigUrl(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String var1);

            @VisibleForTesting
            abstract @UnknownKeyFor @NonNull @Initialized Builder setSupportedIdentifiers(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized ManagedTransform build();
        }
    }
}

