/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.managed;

import com.google.auto.service.AutoService;
import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.managed.AutoValue_ManagedSchemaTransformProvider_ManagedConfig;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.NoSuchSchemaException;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaRegistry;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.TypedSchemaTransformProvider;
import org.apache.beam.sdk.schemas.utils.YamlUtils;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Predicates;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={SchemaTransformProvider.class})
public class ManagedSchemaTransformProvider
extends TypedSchemaTransformProvider<ManagedConfig> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(ManagedSchemaTransformProvider.class);
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized SchemaTransformProvider> schemaTransformProvidersCache = new HashMap<String, SchemaTransformProvider>();
    private @UnknownKeyFor @NonNull @Initialized boolean providersCached = false;
    @javax.annotation.Nullable
    private @UnknownKeyFor @Nullable @Initialized Collection<@UnknownKeyFor @NonNull @Initialized String> supportedIdentifiers;

    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "beam:transform:managed:v1";
    }

    public ManagedSchemaTransformProvider() {
        this(null);
    }

    ManagedSchemaTransformProvider(@javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized Collection<@UnknownKeyFor @NonNull @Initialized String> supportedIdentifiers) {
        this.supportedIdentifiers = supportedIdentifiers;
    }

    protected @UnknownKeyFor @NonNull @Initialized SchemaTransform from(@UnknownKeyFor @NonNull @Initialized ManagedConfig managedConfig) {
        managedConfig.validate();
        SchemaTransformProvider schemaTransformProvider = (SchemaTransformProvider)org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull((Object)this.getAllProviders().get(managedConfig.getTransformIdentifier()), (String)"Could not find a transform with the identifier %s. This could be either due to the dependency with the transform not being available in the classpath or due to the specified transform not being supported.", (Object)managedConfig.getTransformIdentifier());
        return new ManagedSchemaTransform(managedConfig, schemaTransformProvider);
    }

    @VisibleForTesting
    static @UnknownKeyFor @NonNull @Initialized Row getRowConfig(@UnknownKeyFor @NonNull @Initialized ManagedConfig config, @UnknownKeyFor @NonNull @Initialized Schema transformSchema) {
        HashMap configMap = config.resolveUnderlyingConfig();
        Map<String, String> aliases = ManagedSchemaTransformProvider.getAliases().get(config.getTransformIdentifier());
        if (aliases != null && configMap != null) {
            HashMap remappedConfig = new HashMap();
            for (Map.Entry entry : configMap.entrySet()) {
                String paramName = (String)entry.getKey();
                if (aliases.containsKey(paramName)) {
                    paramName = aliases.get(paramName);
                }
                remappedConfig.put(paramName, entry.getValue());
            }
            configMap = remappedConfig;
        }
        return YamlUtils.toBeamRow((Map)configMap, (Schema)transformSchema, (boolean)false);
    }

    public static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>> getAliases() {
        InputStream inputStream = (InputStream)Preconditions.checkStateNotNull((Object)((ClassLoader)Preconditions.checkStateNotNull((Object)ManagedSchemaTransformProvider.class.getClassLoader())).getResourceAsStream("config_aliases.yaml"));
        HashMap<String, Map<String, String>> aliases = new HashMap<String, Map<String, String>>();
        for (Map.Entry entry : YamlUtils.loadFromStream((InputStream)inputStream).entrySet()) {
            aliases.put((String)entry.getKey(), (Map)entry.getValue());
        }
        return aliases;
    }

    synchronized @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized SchemaTransformProvider> getAllProviders() {
        if (this.providersCached) {
            return this.schemaTransformProvidersCache;
        }
        try {
            for (SchemaTransformProvider schemaTransformProvider : ServiceLoader.load(SchemaTransformProvider.class)) {
                if (this.schemaTransformProvidersCache.containsKey(schemaTransformProvider.identifier())) {
                    throw new IllegalArgumentException("Found multiple SchemaTransformProvider implementations with the same identifier " + schemaTransformProvider.identifier());
                }
                if (this.supportedIdentifiers != null && !this.supportedIdentifiers.contains(schemaTransformProvider.identifier()) || schemaTransformProvider.identifier().equals("beam:transform:managed:v1")) continue;
                this.schemaTransformProvidersCache.put(schemaTransformProvider.identifier(), schemaTransformProvider);
            }
            this.providersCached = true;
            return this.schemaTransformProvidersCache;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    static class ManagedSchemaTransform
    extends SchemaTransform {
        private final @UnknownKeyFor @NonNull @Initialized ManagedConfig managedConfig;
        private final @UnknownKeyFor @NonNull @Initialized Row underlyingRowConfig;
        private final @UnknownKeyFor @NonNull @Initialized SchemaTransformProvider underlyingTransformProvider;

        ManagedSchemaTransform(@UnknownKeyFor @NonNull @Initialized ManagedConfig managedConfig, @UnknownKeyFor @NonNull @Initialized SchemaTransformProvider underlyingTransformProvider) {
            Row underlyingRowConfig;
            Schema transformConfigSchema = underlyingTransformProvider.configurationSchema();
            try {
                underlyingRowConfig = ManagedSchemaTransformProvider.getRowConfig(managedConfig, transformConfigSchema);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Encountered an error when retrieving a configuration", e);
            }
            this.underlyingRowConfig = underlyingRowConfig;
            this.underlyingTransformProvider = underlyingTransformProvider;
            this.managedConfig = managedConfig;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple expand(@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple input) {
            LOG.debug("Building transform \"{}\" with configuration: {}", (Object)this.underlyingTransformProvider.identifier(), (Object)this.underlyingRowConfig);
            return (PCollectionRowTuple)input.apply((PTransform)this.underlyingTransformProvider.from(this.underlyingRowConfig));
        }

        public @UnknownKeyFor @NonNull @Initialized ManagedConfig getManagedConfig() {
            return this.managedConfig;
        }

        @UnknownKeyFor @NonNull @Initialized Row getConfigurationRow() {
            try {
                return ((Row)SchemaRegistry.createDefault().getToRowFunction(ManagedConfig.class).apply((Object)this.managedConfig)).sorted().toSnakeCase();
            }
            catch (NoSuchSchemaException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @DefaultSchema(value=AutoValueSchema.class)
    @AutoValue
    @VisibleForTesting
    static abstract class ManagedConfig {
        ManagedConfig() {
        }

        public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
            return new AutoValue_ManagedSchemaTransformProvider_ManagedConfig.Builder();
        }

        @SchemaFieldDescription(value="Identifier of the underlying SchemaTransform to discover and instantiate.")
        public abstract @UnknownKeyFor @NonNull @Initialized String getTransformIdentifier();

        @SchemaFieldDescription(value="URL path to the YAML config file used to build the underlying SchemaTransform.")
        @javax.annotation.Nullable
        public abstract @UnknownKeyFor @Nullable @Initialized String getConfigUrl();

        @SchemaFieldDescription(value="YAML string config used to build the underlying SchemaTransform.")
        @javax.annotation.Nullable
        public abstract @UnknownKeyFor @Nullable @Initialized String getConfig();

        protected void validate() {
            boolean configExists = !Strings.isNullOrEmpty((String)this.getConfig());
            boolean configUrlExists = !Strings.isNullOrEmpty((String)this.getConfigUrl());
            List<Boolean> configs = Arrays.asList(configExists, configUrlExists);
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((1L == configs.stream().filter(Predicates.equalTo((Object)true)).count() ? 1 : 0) != 0, (Object)"Please specify a config or a config URL, but not both.");
        }

        private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> resolveUnderlyingConfig() {
            String yamlTransformConfig = this.getConfig();
            if (Strings.isNullOrEmpty((String)yamlTransformConfig)) {
                try {
                    MatchResult.Metadata fileMetaData = FileSystems.matchSingleFileSpec((String)((String)org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull((Object)this.getConfigUrl())));
                    ByteBuffer buffer = ByteBuffer.allocate((int)fileMetaData.sizeBytes());
                    FileSystems.open((ResourceId)fileMetaData.resourceId()).read(buffer);
                    yamlTransformConfig = new String(buffer.array(), StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return YamlUtils.yamlStringToMap((String)yamlTransformConfig);
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder setTransformIdentifier(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setConfigUrl(@javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setConfig(@javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized ManagedConfig build();
        }
    }
}

