/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.managed.testing;

import com.google.auto.service.AutoService;
import com.google.auto.value.AutoValue;
import java.io.Serializable;
import org.apache.beam.sdk.managed.testing.AutoValue_TestSchemaTransformProvider_Config;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.TypedSchemaTransformProvider;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoService(value={SchemaTransformProvider.class})
public class TestSchemaTransformProvider
extends TypedSchemaTransformProvider<Config> {
    private static final @UnknownKeyFor @NonNull @Initialized TestSchemaTransformProvider INSTANCE = new TestSchemaTransformProvider();
    public static final @UnknownKeyFor @NonNull @Initialized String IDENTIFIER = INSTANCE.identifier();
    public static final @UnknownKeyFor @NonNull @Initialized Schema SCHEMA = INSTANCE.configurationSchema();

    public @UnknownKeyFor @NonNull @Initialized SchemaTransform from(@UnknownKeyFor @NonNull @Initialized Config config) {
        final String extraString = config.getExtraString();
        final Integer extraInteger = config.getExtraInteger();
        return new SchemaTransform(){

            public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple expand(@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple input) {
                Schema schema = Schema.builder().addFields(input.get("input").getSchema().getFields()).addStringField("extra_string").addInt32Field("extra_integer").build();
                PCollection rows = ((PCollection)input.get("input").apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.rows()).via((SerializableFunction & Serializable)row -> Row.withSchema((Schema)schema).addValues(row.getValues()).addValue((Object)extraString).addValue((Object)extraInteger).build()))).setRowSchema(schema);
                return PCollectionRowTuple.of((String)"output", (PCollection)rows);
            }
        };
    }

    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "beam:test_schematransform:v1";
    }

    @DefaultSchema(value=AutoValueSchema.class)
    @AutoValue
    public static abstract class Config {
        public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
            return new AutoValue_TestSchemaTransformProvider_Config.Builder();
        }

        @SchemaFieldDescription(value="String to add to each row element.")
        public abstract @UnknownKeyFor @NonNull @Initialized String getExtraString();

        @SchemaFieldDescription(value="Integer to add to each row element.")
        public abstract @UnknownKeyFor @NonNull @Initialized Integer getExtraInteger();

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder setExtraString(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setExtraInteger(@UnknownKeyFor @NonNull @Initialized Integer var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Config build();
        }
    }
}

