/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testutils.metrics;

import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.metrics.DistributionResult;
import org.apache.beam.sdk.metrics.MetricNameFilter;
import org.apache.beam.sdk.metrics.MetricQueryResults;
import org.apache.beam.sdk.metrics.MetricResult;
import org.apache.beam.sdk.metrics.MetricsFilter;
import org.apache.beam.sdk.testutils.NamedTestResult;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsReader {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsReader.class);
    private static final long ERRONEOUS_METRIC_VALUE = -1L;
    private final PipelineResult result;
    private final String namespace;
    private final long now;

    @VisibleForTesting
    MetricsReader(PipelineResult result, String defaultNamespace, long now) {
        this.result = result;
        this.namespace = defaultNamespace;
        this.now = now;
    }

    public MetricsReader(PipelineResult result, String namespace) {
        this(result, namespace, System.currentTimeMillis());
    }

    public MetricsReader withNamespace(String namespace) {
        return new MetricsReader(this.result, namespace, this.now);
    }

    public long getCounterMetric(String name) {
        MetricQueryResults metrics = this.result.metrics().queryMetrics(MetricsFilter.builder().addNameFilter(MetricNameFilter.named((String)this.namespace, (String)name)).build());
        Iterable counters = metrics.getCounters();
        this.checkIfMetricResultIsUnique(name, counters);
        try {
            MetricResult metricResult = (MetricResult)counters.iterator().next();
            return (Long)metricResult.getAttempted();
        }
        catch (NoSuchElementException e) {
            LOG.error("Failed to get metric {}, from namespace {}", (Object)name, (Object)this.namespace);
            return -1L;
        }
    }

    public long getStartTimeMetric(String name) {
        Iterable<MetricResult<DistributionResult>> timeDistributions = this.getDistributions(name);
        return this.getLowestMin(timeDistributions);
    }

    public Collection<NamedTestResult> readAll(Set<Function<MetricsReader, NamedTestResult>> suppliers) {
        return suppliers.stream().map(supp -> (NamedTestResult)supp.apply(this)).collect(Collectors.toSet());
    }

    private Long getLowestMin(Iterable<MetricResult<DistributionResult>> distributions) {
        Optional<Long> lowestMin = StreamSupport.stream(distributions.spliterator(), true).map(element -> ((DistributionResult)element.getAttempted()).getMin()).filter(this::isCredible).min(Long::compareTo);
        return lowestMin.orElse(-1L);
    }

    public long getEndTimeMetric(String name) {
        Iterable<MetricResult<DistributionResult>> timeDistributions = this.getDistributions(name);
        return this.getGreatestMax(timeDistributions);
    }

    private Long getGreatestMax(Iterable<MetricResult<DistributionResult>> distributions) {
        Optional<Long> greatestMax = StreamSupport.stream(distributions.spliterator(), true).map(element -> ((DistributionResult)element.getAttempted()).getMax()).filter(this::isCredible).max(Long::compareTo);
        return greatestMax.orElse(-1L);
    }

    private Iterable<MetricResult<DistributionResult>> getDistributions(String name) {
        MetricQueryResults metrics = this.result.metrics().queryMetrics(MetricsFilter.builder().addNameFilter(MetricNameFilter.named((String)this.namespace, (String)name)).build());
        return metrics.getDistributions();
    }

    private <T> void checkIfMetricResultIsUnique(String name, Iterable<MetricResult<T>> metricResult) throws IllegalStateException {
        int resultCount = Iterables.size(metricResult);
        Preconditions.checkState((resultCount <= 1 ? 1 : 0) != 0, (String)"More than one metric result matches name: %s in namespace %s. Metric results count: %s", (Object)name, (Object)this.namespace, (Object)resultCount);
    }

    private boolean isCredible(long value) {
        return Math.abs(value - this.now) <= Duration.standardDays((long)10000L).getMillis();
    }

    public static MetricsReader ofResults(PipelineResult results, String namespace) {
        Preconditions.checkNotNull((Object)results);
        Preconditions.checkNotNull((Object)namespace);
        return new MetricsReader(results, namespace);
    }
}

