/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testutils.publishing;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.sdk.testutils.TestResult;
import org.apache.beam.sdk.testutils.publishing.BigQueryClient;

public class BigQueryResultsPublisher {
    private BigQueryClient client;
    private Map<String, String> schema;

    protected BigQueryResultsPublisher(BigQueryClient client, Map<String, String> schema) {
        this.client = client;
        this.schema = schema;
    }

    public static BigQueryResultsPublisher create(String dataset, Map<String, String> schema) {
        return new BigQueryResultsPublisher(BigQueryClient.create(dataset), schema);
    }

    public void publish(TestResult result, String tableName, long nowInMillis) {
        Map<String, Object> row = this.getRowOfSchema(result);
        row.put("timestamp", nowInMillis / 1000L);
        this.client.insertRow(row, this.schema, tableName);
    }

    public void publish(TestResult result, String tableName) {
        this.client.insertRow(this.getRowOfSchema(result), this.schema, tableName);
    }

    public void publish(Collection<? extends TestResult> results, String tableName) {
        List<Map<String, ?>> records = results.stream().map(this::getRowOfSchema).collect(Collectors.toList());
        this.client.insertAll(records, this.schema, tableName);
    }

    private Map<String, Object> getRowOfSchema(TestResult result) {
        return result.toMap().entrySet().stream().filter(element -> this.schema.containsKey(element.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

