/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testutils.publishing;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.apache.beam.sdk.testutils.NamedTestResult;
import org.apache.beam.sdk.testutils.publishing.InfluxDBSettings;
import org.apache.commons.compress.utils.Charsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.entity.GzipCompressingEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InfluxDBPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(InfluxDBPublisher.class);

    private InfluxDBPublisher() {
    }

    public static void publishNexmarkResults(Collection<Map<String, Object>> results, InfluxDBSettings settings, Map<String, String> tags) {
        InfluxDBPublisher.publishWithCheck(settings, () -> InfluxDBPublisher.publishNexmark(results, settings, tags));
    }

    public static void publishWithSettings(Collection<NamedTestResult> results, InfluxDBSettings settings) {
        InfluxDBPublisher.publishWithCheck(settings, () -> InfluxDBPublisher.publishCommon(results, settings));
    }

    private static void publishWithCheck(InfluxDBSettings settings, PublishFunction publishFunction) {
        Objects.requireNonNull(settings, "InfluxDB settings must not be null");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{settings.measurement, settings.database})) {
            try {
                publishFunction.publish();
            }
            catch (Exception exception) {
                LOG.warn("Unable to publish metrics due to error: {}", (Object)exception.getMessage());
            }
        } else {
            LOG.warn("Missing property -- measurement/database. Metrics won't be published.");
        }
    }

    private static void publishNexmark(Collection<Map<String, Object>> results, InfluxDBSettings settings, Map<String, String> tags) throws Exception {
        HttpClientBuilder builder = InfluxDBPublisher.provideHttpBuilder(settings);
        HttpPost postRequest = InfluxDBPublisher.providePOSTRequest(settings);
        StringBuilder metricBuilder = new StringBuilder();
        results.forEach(map -> {
            metricBuilder.append(map.get("measurement")).append(",").append(InfluxDBPublisher.getKV(map, "runner"));
            if (tags != null && !tags.isEmpty()) {
                tags.entrySet().stream().forEach(entry -> metricBuilder.append(",").append((String)entry.getKey()).append("=").append((String)entry.getValue()));
            }
            metricBuilder.append(" ").append(InfluxDBPublisher.getKV(map, "runtimeMs")).append(",").append(InfluxDBPublisher.getKV(map, "numResults")).append(" ").append(map.get("timestamp")).append('\n');
        });
        postRequest.setEntity((HttpEntity)new GzipCompressingEntity((HttpEntity)new ByteArrayEntity(metricBuilder.toString().getBytes(StandardCharsets.UTF_8))));
        InfluxDBPublisher.executeWithVerification(postRequest, builder);
    }

    private static String getKV(Map<String, Object> map, String key) {
        return key + "=" + map.get(key);
    }

    private static void publishCommon(Collection<NamedTestResult> results, InfluxDBSettings settings) throws Exception {
        HttpClientBuilder builder = InfluxDBPublisher.provideHttpBuilder(settings);
        HttpPost postRequest = InfluxDBPublisher.providePOSTRequest(settings);
        StringBuilder metricBuilder = new StringBuilder();
        results.stream().map(NamedTestResult::toMap).forEach(map -> metricBuilder.append(settings.measurement).append(",").append(InfluxDBPublisher.getKV(map, "test_id")).append(",").append(InfluxDBPublisher.getKV(map, "metric")).append(" ").append(InfluxDBPublisher.getKV(map, "value")).append('\n'));
        postRequest.setEntity((HttpEntity)new ByteArrayEntity(metricBuilder.toString().getBytes(StandardCharsets.UTF_8)));
        InfluxDBPublisher.executeWithVerification(postRequest, builder);
    }

    private static HttpClientBuilder provideHttpBuilder(InfluxDBSettings settings) {
        HttpClientBuilder builder = HttpClientBuilder.create();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{settings.userName, settings.userPassword})) {
            BasicCredentialsProvider provider = new BasicCredentialsProvider();
            provider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(settings.userName, settings.userPassword));
            builder.setDefaultCredentialsProvider((CredentialsProvider)provider);
        }
        return builder;
    }

    private static HttpPost providePOSTRequest(InfluxDBSettings settings) {
        String retentionPolicy = "rp" + (StringUtils.isBlank((CharSequence)settings.retentionPolicy) ? "" : "=" + settings.retentionPolicy);
        return new HttpPost(settings.host + "/write?db=" + settings.database + "&" + retentionPolicy + "&precision=s");
    }

    private static void executeWithVerification(HttpPost postRequest, HttpClientBuilder builder) throws IOException {
        try (CloseableHttpResponse response = builder.build().execute((HttpUriRequest)postRequest);){
            InfluxDBPublisher.is2xx((HttpResponse)response);
        }
    }

    private static void is2xx(HttpResponse response) throws IOException {
        int code = response.getStatusLine().getStatusCode();
        if (code < 200 || code >= 300) {
            throw new IOException("Response code: " + code + ". Reason: " + InfluxDBPublisher.getErrorMessage(response.getEntity()));
        }
    }

    private static String getErrorMessage(HttpEntity entity) throws IOException {
        Header encodingHeader = entity.getContentEncoding();
        Charset encoding = encodingHeader == null ? StandardCharsets.UTF_8 : Charsets.toCharset((String)encodingHeader.getValue());
        JsonElement errorElement = ((JsonObject)new Gson().fromJson(EntityUtils.toString((HttpEntity)entity, (Charset)encoding), JsonObject.class)).get("error");
        return Objects.isNull(errorElement) ? "[Unable to get error message]" : errorElement.toString();
    }

    @FunctionalInterface
    private static interface PublishFunction {
        public void publish() throws Exception;
    }
}

