/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testutils.publishing;

import org.apache.beam.repackaged.core.org.apache.commons.lang3.StringUtils;

public final class InfluxDBSettings {
    public final String host;
    public final String userName;
    public final String userPassword;
    public final String measurement;
    public final String database;
    public final String retentionPolicy;

    private InfluxDBSettings(String host, String userName, String userPassword, String measurement, String database, String retentionPolicy) {
        this.host = host;
        this.userName = userName;
        this.userPassword = userPassword;
        this.measurement = measurement;
        this.database = database;
        this.retentionPolicy = retentionPolicy;
    }

    public static Builder builder() {
        return new Builder();
    }

    public InfluxDBSettings copyWithMeasurement(String newMeasurement) {
        return new InfluxDBSettings(this.host, this.userName, this.userPassword, newMeasurement, this.database, this.retentionPolicy);
    }

    public static class Builder {
        private static final String DEFAULT_HOST = "http://localhost:8086";
        private static final String INFLUX_USER = "INFLUXDB_USER";
        private static final String INFLUX_PASSWORD = "INFLUXDB_USER_PASSWORD";
        private String host;
        private String measurement;
        private String database;
        private String retentionPolicy;

        public Builder withHost(String host) {
            this.host = host;
            return this;
        }

        public Builder withMeasurement(String measurement) {
            this.measurement = measurement;
            return this;
        }

        public Builder withDatabase(String database) {
            this.database = database;
            return this;
        }

        public Builder withRetentionPolicy(String retentionPolicy) {
            this.retentionPolicy = retentionPolicy;
            return this;
        }

        public InfluxDBSettings get() {
            String userName = System.getenv(INFLUX_USER);
            String userPassword = System.getenv(INFLUX_PASSWORD);
            String influxHost = StringUtils.isBlank((CharSequence)this.host) ? DEFAULT_HOST : this.host;
            return new InfluxDBSettings(influxHost, userName, userPassword, this.measurement, this.database, this.retentionPolicy);
        }
    }
}

