/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testutils.metrics;

import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.metrics.DistributionResult;
import org.apache.beam.sdk.metrics.MetricNameFilter;
import org.apache.beam.sdk.metrics.MetricQueryResults;
import org.apache.beam.sdk.metrics.MetricResult;
import org.apache.beam.sdk.metrics.MetricsFilter;
import org.apache.beam.sdk.testutils.NamedTestResult;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsReader {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(MetricsReader.class);
    private static final @UnknownKeyFor @NonNull @Initialized long ERRONEOUS_METRIC_VALUE = -1L;
    private final @UnknownKeyFor @NonNull @Initialized PipelineResult result;
    private final @UnknownKeyFor @NonNull @Initialized String namespace;
    private final @UnknownKeyFor @NonNull @Initialized long now;

    @VisibleForTesting
    MetricsReader(@UnknownKeyFor @NonNull @Initialized PipelineResult result, @UnknownKeyFor @NonNull @Initialized String defaultNamespace, @UnknownKeyFor @NonNull @Initialized long now) {
        this.result = result;
        this.namespace = defaultNamespace;
        this.now = now;
    }

    public MetricsReader(@UnknownKeyFor @NonNull @Initialized PipelineResult result, @UnknownKeyFor @NonNull @Initialized String namespace) {
        this(result, namespace, System.currentTimeMillis());
    }

    public @UnknownKeyFor @NonNull @Initialized MetricsReader withNamespace(@UnknownKeyFor @NonNull @Initialized String namespace) {
        return new MetricsReader(this.result, namespace, this.now);
    }

    public @UnknownKeyFor @NonNull @Initialized long getCounterMetric(@UnknownKeyFor @NonNull @Initialized String name) {
        MetricQueryResults metrics = this.result.metrics().queryMetrics(MetricsFilter.builder().addNameFilter(MetricNameFilter.named((String)this.namespace, (String)name)).build());
        Iterable counters = metrics.getCounters();
        this.checkIfMetricResultIsUnique(name, counters);
        try {
            MetricResult metricResult = (MetricResult)counters.iterator().next();
            return (Long)metricResult.getAttempted();
        }
        catch (NoSuchElementException e) {
            LOG.error("Failed to get metric {}, from namespace {}", (Object)name, (Object)this.namespace);
            return -1L;
        }
    }

    public @UnknownKeyFor @NonNull @Initialized long getStartTimeMetric(@UnknownKeyFor @NonNull @Initialized String name) {
        Iterable<MetricResult<DistributionResult>> timeDistributions = this.getDistributions(name);
        return this.getLowestMin(timeDistributions);
    }

    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized NamedTestResult> readAll(@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized MetricsReader, @UnknownKeyFor @NonNull @Initialized NamedTestResult>> suppliers) {
        return suppliers.stream().map(supp -> (NamedTestResult)supp.apply(this)).collect(Collectors.toSet());
    }

    private @UnknownKeyFor @NonNull @Initialized Long getLowestMin(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized DistributionResult>> distributions) {
        Optional<Long> lowestMin = StreamSupport.stream(distributions.spliterator(), true).map(element -> ((DistributionResult)element.getAttempted()).getMin()).filter(this::isCredible).min(Long::compareTo);
        return lowestMin.orElse(-1L);
    }

    public @UnknownKeyFor @NonNull @Initialized long getEndTimeMetric(@UnknownKeyFor @NonNull @Initialized String name) {
        Iterable<MetricResult<DistributionResult>> timeDistributions = this.getDistributions(name);
        return this.getGreatestMax(timeDistributions);
    }

    private @UnknownKeyFor @NonNull @Initialized Long getGreatestMax(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized DistributionResult>> distributions) {
        Optional<Long> greatestMax = StreamSupport.stream(distributions.spliterator(), true).map(element -> ((DistributionResult)element.getAttempted()).getMax()).filter(this::isCredible).max(Long::compareTo);
        return greatestMax.orElse(-1L);
    }

    private @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized DistributionResult>> getDistributions(@UnknownKeyFor @NonNull @Initialized String name) {
        MetricQueryResults metrics = this.result.metrics().queryMetrics(MetricsFilter.builder().addNameFilter(MetricNameFilter.named((String)this.namespace, (String)name)).build());
        return metrics.getDistributions();
    }

    private <T> void checkIfMetricResultIsUnique(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MetricResult<T>> metricResult) throws @UnknownKeyFor @NonNull @Initialized IllegalStateException {
        int resultCount = Iterables.size(metricResult);
        Preconditions.checkState((resultCount <= 1 ? 1 : 0) != 0, (String)"More than one metric result matches name: %s in namespace %s. Metric results count: %s", (Object)name, (Object)this.namespace, (Object)resultCount);
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isCredible(@UnknownKeyFor @NonNull @Initialized long value) {
        return Math.abs(value - this.now) <= Duration.standardDays((long)10000L).getMillis();
    }

    public static @UnknownKeyFor @NonNull @Initialized MetricsReader ofResults(@UnknownKeyFor @NonNull @Initialized PipelineResult results, @UnknownKeyFor @NonNull @Initialized String namespace) {
        Preconditions.checkNotNull((Object)results);
        Preconditions.checkNotNull((Object)namespace);
        return new MetricsReader(results, namespace);
    }
}

