/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testutils.publishing;

import org.apache.beam.repackaged.core.org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public final class InfluxDBSettings {
    public final @UnknownKeyFor @NonNull @Initialized String host;
    public final @UnknownKeyFor @NonNull @Initialized String userName;
    public final @UnknownKeyFor @NonNull @Initialized String userPassword;
    public final @UnknownKeyFor @NonNull @Initialized String measurement;
    public final @UnknownKeyFor @NonNull @Initialized String database;
    public final @UnknownKeyFor @NonNull @Initialized String retentionPolicy;

    private InfluxDBSettings(@UnknownKeyFor @NonNull @Initialized String host, @UnknownKeyFor @NonNull @Initialized String userName, @UnknownKeyFor @NonNull @Initialized String userPassword, @UnknownKeyFor @NonNull @Initialized String measurement, @UnknownKeyFor @NonNull @Initialized String database, @UnknownKeyFor @NonNull @Initialized String retentionPolicy) {
        this.host = host;
        this.userName = userName;
        this.userPassword = userPassword;
        this.measurement = measurement;
        this.database = database;
        this.retentionPolicy = retentionPolicy;
    }

    public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
        return new Builder();
    }

    public @UnknownKeyFor @NonNull @Initialized InfluxDBSettings copyWithMeasurement(@UnknownKeyFor @NonNull @Initialized String newMeasurement) {
        return new InfluxDBSettings(this.host, this.userName, this.userPassword, newMeasurement, this.database, this.retentionPolicy);
    }

    public static class Builder {
        private static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_HOST = "http://localhost:8086";
        private static final @UnknownKeyFor @NonNull @Initialized String INFLUX_USER = "INFLUXDB_USER";
        private static final @UnknownKeyFor @NonNull @Initialized String INFLUX_PASSWORD = "INFLUXDB_USER_PASSWORD";
        private @UnknownKeyFor @NonNull @Initialized String host;
        private @UnknownKeyFor @NonNull @Initialized String measurement;
        private @UnknownKeyFor @NonNull @Initialized String database;
        private @UnknownKeyFor @NonNull @Initialized String retentionPolicy;

        public @UnknownKeyFor @NonNull @Initialized Builder withHost(@UnknownKeyFor @NonNull @Initialized String host) {
            this.host = host;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder withMeasurement(@UnknownKeyFor @NonNull @Initialized String measurement) {
            this.measurement = measurement;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder withDatabase(@UnknownKeyFor @NonNull @Initialized String database) {
            this.database = database;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder withRetentionPolicy(@UnknownKeyFor @NonNull @Initialized String retentionPolicy) {
            this.retentionPolicy = retentionPolicy;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized InfluxDBSettings get() {
            String userName = System.getenv(INFLUX_USER);
            String userPassword = System.getenv(INFLUX_PASSWORD);
            String influxHost = StringUtils.isBlank((CharSequence)this.host) ? DEFAULT_HOST : this.host;
            return new InfluxDBSettings(influxHost, userName, userPassword, this.measurement, this.database, this.retentionPolicy);
        }
    }
}

