/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testutils;

import com.google.cloud.bigquery.LegacySQLTypeName;
import java.util.Map;
import org.apache.beam.sdk.testutils.TestResult;
import org.apache.beam.sdk.testutils.publishing.InfluxDBPublisher;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedTestResult
implements TestResult {
    private final @UnknownKeyFor @NonNull @Initialized String testId;
    private final @UnknownKeyFor @NonNull @Initialized String timestamp;
    private final @UnknownKeyFor @NonNull @Initialized String metric;
    private final @UnknownKeyFor @NonNull @Initialized double value;
    private static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> schema = ImmutableMap.builder().put((Object)"test_id", (Object)LegacySQLTypeName.STRING.name()).put((Object)"timestamp", (Object)LegacySQLTypeName.TIMESTAMP.name()).put((Object)"metric", (Object)LegacySQLTypeName.STRING.name()).put((Object)"value", (Object)LegacySQLTypeName.FLOAT.name()).build();
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(NamedTestResult.class);

    private NamedTestResult(@UnknownKeyFor @NonNull @Initialized String testId, @UnknownKeyFor @NonNull @Initialized String timestamp, @UnknownKeyFor @NonNull @Initialized String metric, @UnknownKeyFor @NonNull @Initialized double value) {
        this.testId = testId;
        this.timestamp = timestamp;
        this.metric = metric;
        this.value = value;
    }

    public static @UnknownKeyFor @NonNull @Initialized NamedTestResult create(@UnknownKeyFor @NonNull @Initialized String testId, @UnknownKeyFor @NonNull @Initialized String timestamp, @UnknownKeyFor @NonNull @Initialized String metric, @UnknownKeyFor @NonNull @Initialized double value) {
        if (value < 0.0 && value != -1.0) {
            LOG.warn("Reset invalid NamedTestResult value {} to -1.0.", (Object)value);
            value = -1.0;
        }
        return new NamedTestResult(testId, timestamp, metric, value);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> toMap() {
        return ImmutableMap.builder().putAll(this.tags()).putAll(this.fields()).put((Object)"timestamp", (Object)this.timestamp).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> getSchema() {
        return schema;
    }

    public @UnknownKeyFor @NonNull @Initialized String getMetric() {
        return this.metric;
    }

    public @UnknownKeyFor @NonNull @Initialized double getValue() {
        return this.value;
    }

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> tags() {
        return ImmutableMap.of((Object)"test_id", (Object)this.testId, (Object)"metric", (Object)this.metric);
    }

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Number> fields() {
        return ImmutableMap.of((Object)"value", (Object)this.value);
    }

    public @UnknownKeyFor @NonNull @Initialized InfluxDBPublisher.DataPoint toInfluxDBDataPoint(@UnknownKeyFor @NonNull @Initialized String measurement) {
        return InfluxDBPublisher.dataPoint(measurement, this.tags(), this.fields(), null);
    }
}

