/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testutils.metrics;

import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.testutils.NamedTestResult;
import org.apache.beam.sdk.testutils.metrics.MetricsReader;
import org.apache.beam.sdk.testutils.publishing.ConsoleResultPublisher;
import org.apache.beam.sdk.testutils.publishing.InfluxDBPublisher;
import org.apache.beam.sdk.testutils.publishing.InfluxDBSettings;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class IOITMetrics {
    private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized MetricsReader, @UnknownKeyFor @NonNull @Initialized NamedTestResult>> metricSuppliers;
    private final @UnknownKeyFor @NonNull @Initialized PipelineResult result;
    private final @UnknownKeyFor @NonNull @Initialized String namespace;
    private final @UnknownKeyFor @NonNull @Initialized String uuid;
    private final @UnknownKeyFor @NonNull @Initialized String timestamp;

    public IOITMetrics(@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized MetricsReader, @UnknownKeyFor @NonNull @Initialized NamedTestResult>> metricSuppliers, @UnknownKeyFor @NonNull @Initialized PipelineResult result, @UnknownKeyFor @NonNull @Initialized String namespace, @UnknownKeyFor @NonNull @Initialized String uuid, @UnknownKeyFor @NonNull @Initialized String timestamp) {
        this.metricSuppliers = metricSuppliers;
        this.result = result;
        this.namespace = namespace;
        this.uuid = uuid;
        this.timestamp = timestamp;
    }

    public void publishToInflux(@UnknownKeyFor @NonNull @Initialized InfluxDBSettings settings) {
        MetricsReader reader = new MetricsReader(this.result, this.namespace);
        Collection<NamedTestResult> namedTestResults = reader.readAll(this.metricSuppliers);
        IOITMetrics.publishToInflux(this.uuid, this.timestamp, namedTestResults, settings);
    }

    public static void publishToInflux(@UnknownKeyFor @NonNull @Initialized String uuid, @UnknownKeyFor @NonNull @Initialized String timestamp, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized NamedTestResult> results, @UnknownKeyFor @NonNull @Initialized InfluxDBSettings settings) {
        ConsoleResultPublisher.publish(results, uuid, timestamp);
        InfluxDBPublisher.publishWithSettings(results, settings);
    }
}

