/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transformservice.launcher;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.beam.sdk.transformservice.launcher.TransformServiceLauncher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TransformServiceLauncherTest {
    @Test
    public void testLauncherCreatesCredentialsDir() throws IOException {
        String projectName = UUID.randomUUID().toString();
        Path expectedTempDir = Paths.get(System.getProperty("java.io.tmpdir"), projectName);
        File file = expectedTempDir.toFile();
        file.deleteOnExit();
        TransformServiceLauncher.forProject((String)projectName, (int)12345, null);
        Path expectedCredentialsDir = Paths.get(expectedTempDir.toString(), "credentials_dir");
        Assert.assertTrue((boolean)expectedCredentialsDir.toFile().exists());
    }

    @Test
    public void testLauncherCreatesDependenciesDir() throws IOException {
        String projectName = UUID.randomUUID().toString();
        Path expectedTempDir = Paths.get(System.getProperty("java.io.tmpdir"), projectName);
        File file = expectedTempDir.toFile();
        file.deleteOnExit();
        TransformServiceLauncher.forProject((String)projectName, (int)12345, null);
        Path expectedCredentialsDir = Paths.get(expectedTempDir.toString(), "dependencies_dir");
        Assert.assertTrue((boolean)expectedCredentialsDir.toFile().exists());
    }

    @Test
    public void testLauncherInstallsDependencies() throws IOException {
        String projectName = UUID.randomUUID().toString();
        Path expectedTempDir = Paths.get(System.getProperty("java.io.tmpdir"), projectName);
        File file = expectedTempDir.toFile();
        file.deleteOnExit();
        File requirementsFile = Paths.get(System.getProperty("java.io.tmpdir"), "requirements" + UUID.randomUUID().toString() + ".txt").toFile();
        requirementsFile.deleteOnExit();
        try (OutputStreamWriter fout = new OutputStreamWriter((OutputStream)new FileOutputStream(requirementsFile.getAbsolutePath()), StandardCharsets.UTF_8);){
            fout.write("pypipackage1\n");
            fout.write("pypipackage2\n");
        }
        TransformServiceLauncher.forProject((String)projectName, (int)12345, (String)requirementsFile.getAbsolutePath());
        Path expectedUpdatedRequirementsFile = Paths.get(expectedTempDir.toString(), "dependencies_dir", "requirements.txt");
        Assert.assertTrue((boolean)expectedUpdatedRequirementsFile.toFile().exists());
        ArrayList<String> expectedUpdatedRequirementsFileLines = new ArrayList<String>();
        try (BufferedReader bufReader = Files.newBufferedReader(expectedUpdatedRequirementsFile, StandardCharsets.UTF_8);){
            String line = bufReader.readLine();
            while (line != null) {
                expectedUpdatedRequirementsFileLines.add(line);
                line = bufReader.readLine();
            }
        }
        Assert.assertEquals((long)2L, (long)expectedUpdatedRequirementsFileLines.size());
        Assert.assertTrue((boolean)expectedUpdatedRequirementsFileLines.contains("pypipackage1"));
        Assert.assertTrue((boolean)expectedUpdatedRequirementsFileLines.contains("pypipackage2"));
    }

    @Test
    public void testLauncherInstallsLocalDependencies() throws IOException {
        String projectName = UUID.randomUUID().toString();
        Path expectedTempDir = Paths.get(System.getProperty("java.io.tmpdir"), projectName);
        File file = expectedTempDir.toFile();
        file.deleteOnExit();
        String dependency1FileName = "dep_" + UUID.randomUUID().toString();
        File dependency1 = Paths.get(System.getProperty("java.io.tmpdir"), dependency1FileName).toFile();
        dependency1.deleteOnExit();
        try (OutputStreamWriter fout = new OutputStreamWriter((OutputStream)new FileOutputStream(dependency1.getAbsolutePath()), StandardCharsets.UTF_8);){
            fout.write("tempdata\n");
        }
        String dependency2FileName = "dep_" + UUID.randomUUID().toString();
        File dependency2 = Paths.get(System.getProperty("java.io.tmpdir"), dependency2FileName).toFile();
        dependency2.deleteOnExit();
        try (OutputStreamWriter fout = new OutputStreamWriter((OutputStream)new FileOutputStream(dependency2.getAbsolutePath()), StandardCharsets.UTF_8);){
            fout.write("tempdata\n");
        }
        File requirementsFile = Paths.get(System.getProperty("java.io.tmpdir"), "requirements" + UUID.randomUUID().toString() + ".txt").toFile();
        requirementsFile.deleteOnExit();
        try (OutputStreamWriter fout = new OutputStreamWriter((OutputStream)new FileOutputStream(requirementsFile.getAbsolutePath()), StandardCharsets.UTF_8);){
            fout.write(dependency1.getAbsolutePath() + "\n");
            fout.write(dependency2.getAbsolutePath() + "\n");
            fout.write("pypipackage\n");
        }
        TransformServiceLauncher.forProject((String)projectName, (int)12345, (String)requirementsFile.getAbsolutePath());
        Path expectedUpdatedRequirementsFile = Paths.get(expectedTempDir.toString(), "dependencies_dir", "requirements.txt");
        Assert.assertTrue((boolean)expectedUpdatedRequirementsFile.toFile().exists());
        ArrayList<String> expectedUpdatedRequirementsFileLines = new ArrayList<String>();
        try (BufferedReader bufReader = Files.newBufferedReader(expectedUpdatedRequirementsFile, StandardCharsets.UTF_8);){
            String line = bufReader.readLine();
            while (line != null) {
                expectedUpdatedRequirementsFileLines.add(line);
                line = bufReader.readLine();
            }
        }
        Assert.assertEquals((long)3L, (long)expectedUpdatedRequirementsFileLines.size());
        Assert.assertTrue((boolean)expectedUpdatedRequirementsFileLines.contains(dependency1FileName));
        Assert.assertTrue((boolean)expectedUpdatedRequirementsFileLines.contains(dependency2FileName));
        Assert.assertTrue((boolean)expectedUpdatedRequirementsFileLines.contains("pypipackage"));
        Assert.assertTrue((boolean)Paths.get(expectedTempDir.toString(), "dependencies_dir", dependency1FileName).toFile().exists());
        Assert.assertTrue((boolean)Paths.get(expectedTempDir.toString(), "dependencies_dir", dependency2FileName).toFile().exists());
    }
}

