/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.vendor.sdk.v2.sdk.extensions.protobuf;

import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.logicaltypes.EnumerationType;
import org.apache.beam.sdk.schemas.logicaltypes.OneOfType;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.Descriptors;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.Duration;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.DynamicMessage;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.Message;
import org.apache.beam.vendor.grpc.v1p26p0.com.google.protobuf.Timestamp;
import org.apache.beam.vendor.sdk.v2.sdk.extensions.protobuf.ProtoDomain;
import org.apache.beam.vendor.sdk.v2.sdk.extensions.protobuf.ProtoSchemaTranslator;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Experimental(value=Experimental.Kind.SCHEMAS)
public class ProtoDynamicMessageSchema<@UnknownKeyFor T>
implements Serializable {
    public static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 1L;
    private final @UnknownKeyFor @NonNull @Initialized Context context;
    private transient @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized Row> toRowFunction;
    private transient @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, T> fromRowFunction;
    private transient @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Convert> converters;

    private ProtoDynamicMessageSchema(@UnknownKeyFor @NonNull @Initialized String messageName, @UnknownKeyFor @NonNull @Initialized ProtoDomain domain) {
        this.context = new DescriptorContext(messageName, domain);
        this.readResolve();
    }

    private ProtoDynamicMessageSchema(@UnknownKeyFor @NonNull @Initialized Context context) {
        this.context = context;
        this.readResolve();
    }

    public static @UnknownKeyFor @NonNull @Initialized ProtoDynamicMessageSchema forDescriptor(@UnknownKeyFor @NonNull @Initialized ProtoDomain domain, @UnknownKeyFor @NonNull @Initialized String messageName) {
        return new ProtoDynamicMessageSchema(messageName, domain);
    }

    public static @UnknownKeyFor @NonNull @Initialized ProtoDynamicMessageSchema<@UnknownKeyFor @NonNull @Initialized DynamicMessage> forDescriptor(@UnknownKeyFor @NonNull @Initialized ProtoDomain domain, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.Descriptor descriptor) {
        return new ProtoDynamicMessageSchema<DynamicMessage>(descriptor.getFullName(), domain);
    }

    static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized ProtoDynamicMessageSchema<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> forContext(@UnknownKeyFor @NonNull @Initialized Context context, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.Field field) {
        return new ProtoDynamicMessageSchema(context.getSubContext(field));
    }

    static @UnknownKeyFor @NonNull @Initialized ProtoDynamicMessageSchema<@UnknownKeyFor @NonNull @Initialized Message> forSchema(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        return new ProtoDynamicMessageSchema<Message>(new Context<Message>(schema, Message.class));
    }

    private @UnknownKeyFor @NonNull @Initialized Object readResolve() {
        this.converters = this.createConverters(this.context.getSchema());
        this.toRowFunction = new MessageToRowFunction();
        this.fromRowFunction = new RowToMessageFunction();
        return this;
    }

    @UnknownKeyFor @NonNull @Initialized Convert createConverter(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.Field field) {
        Schema.FieldType fieldType = field.getType();
        if (fieldType.getNullable().booleanValue()) {
            Schema.Field valueField = ProtoSchemaTranslator.withFieldNumber(Schema.Field.of((String)"value", (Schema.FieldType)Schema.FieldType.BOOLEAN), 1);
            switch (fieldType.getTypeName()) {
                case BYTE: 
                case INT16: 
                case INT32: 
                case INT64: 
                case FLOAT: 
                case DOUBLE: 
                case STRING: 
                case BOOLEAN: {
                    return new WrapperConvert(field, new PrimitiveConvert(valueField));
                }
                case BYTES: {
                    return new WrapperConvert(field, new BytesConvert(valueField));
                }
                case LOGICAL_TYPE: {
                    String identifier;
                    switch (identifier = field.getType().getLogicalType().getIdentifier()) {
                        case "Uint32": 
                        case "Uint64": {
                            return new WrapperConvert(field, new PrimitiveConvert(valueField));
                        }
                    }
                }
            }
        }
        switch (fieldType.getTypeName()) {
            case BYTE: 
            case INT16: 
            case INT32: 
            case INT64: 
            case FLOAT: 
            case DOUBLE: 
            case STRING: 
            case BOOLEAN: {
                return new PrimitiveConvert(field);
            }
            case BYTES: {
                return new BytesConvert(field);
            }
            case ARRAY: 
            case ITERABLE: {
                return new ArrayConvert(this, field);
            }
            case MAP: {
                return new MapConvert(this, field);
            }
            case LOGICAL_TYPE: {
                String identifier;
                switch (identifier = field.getType().getLogicalType().getIdentifier()) {
                    case "Fixed32": 
                    case "Fixed64": 
                    case "SFixed32": 
                    case "SFixed64": 
                    case "Sint32": 
                    case "Sint64": 
                    case "Uint32": 
                    case "Uint64": {
                        return new LogicalTypeConvert(field, fieldType.getLogicalType());
                    }
                    case "beam:logical_type:nanos_instant:v1": {
                        return new TimestampConvert(field);
                    }
                    case "beam:logical_type:nanos_duration:v1": {
                        return new DurationConvert(field);
                    }
                    case "Enum": {
                        return new EnumConvert(field, fieldType.getLogicalType());
                    }
                    case "OneOf": {
                        return new OneOfConvert(this, field, fieldType.getLogicalType());
                    }
                }
                throw new IllegalStateException("Unexpected logical type : " + identifier);
            }
            case ROW: {
                return new MessageConvert(this, field);
            }
        }
        throw new IllegalStateException("Unexpected value: " + fieldType);
    }

    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Convert> createConverters(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        ArrayList<Convert> fieldOverlays = new ArrayList<Convert>();
        for (Schema.Field field : schema.getFields()) {
            fieldOverlays.add(this.createConverter(field));
        }
        return fieldOverlays;
    }

    public @UnknownKeyFor @NonNull @Initialized Schema getSchema() {
        return this.context.getSchema();
    }

    public @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized Row> getToRowFunction() {
        return this.toRowFunction;
    }

    public @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, T> getFromRowFunction() {
        return this.fromRowFunction;
    }

    private class RowToMessageFunction
    implements SerializableFunction<Row, T> {
        private RowToMessageFunction() {
        }

        public T apply(@UnknownKeyFor @NonNull @Initialized Row input) {
            DynamicMessage.Builder builder = ProtoDynamicMessageSchema.this.context.invokeNewBuilder();
            Iterator values = input.getValues().iterator();
            Iterator convertIterator = ProtoDynamicMessageSchema.this.converters.iterator();
            for (int i = 0; i < input.getValues().size(); ++i) {
                Convert convert = (Convert)convertIterator.next();
                Object value = values.next();
                convert.setOnProtoMessage((Message.Builder)builder, value);
            }
            return builder.build();
        }
    }

    private class MessageToRowFunction
    implements SerializableFunction<T, Row> {
        private MessageToRowFunction() {
        }

        public @UnknownKeyFor @NonNull @Initialized Row apply(T input) {
            Schema schema = ProtoDynamicMessageSchema.this.context.getSchema();
            Row.Builder builder = Row.withSchema((Schema)schema);
            for (Convert convert : ProtoDynamicMessageSchema.this.converters) {
                builder.addValue(convert.getFromProtoMessage((Message)input));
            }
            return builder.build();
        }
    }

    static class LogicalTypeConvert
    extends Convert<Object, Object> {
        private // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.LogicalType logicalType;

        LogicalTypeConvert(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.Field field, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.LogicalType logicalType) {
            super(field);
            this.logicalType = logicalType;
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized Object getFromProtoMessage(@UnknownKeyFor @NonNull @Initialized Message message) {
            Descriptors.FieldDescriptor fieldDescriptor = this.getFieldDescriptor(message);
            return this.convertFromProtoValue(message.getField(fieldDescriptor));
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized Object convertFromProtoValue(@UnknownKeyFor @NonNull @Initialized Object object) {
            return this.logicalType.toBaseType(object);
        }

        @Override
        void setOnProtoMessage(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Message.Builder message, @UnknownKeyFor @NonNull @Initialized Object value) {
            message.setField(this.getFieldDescriptor(message), value);
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized Object convertToProtoValue(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Descriptors.FieldDescriptor fieldDescriptor, @UnknownKeyFor @NonNull @Initialized Object value) {
            return value;
        }
    }

    static class NullableConvert
    extends Convert<Object, Object> {
        private @UnknownKeyFor @NonNull @Initialized Convert fieldOverlay;

        NullableConvert(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.Field field, @UnknownKeyFor @NonNull @Initialized Convert fieldOverlay) {
            super(field);
            this.fieldOverlay = fieldOverlay;
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized Object getFromProtoMessage(@UnknownKeyFor @NonNull @Initialized Message message) {
            if (message.hasField(this.getFieldDescriptor(message))) {
                return this.fieldOverlay.getFromProtoMessage(message);
            }
            return null;
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized Object convertFromProtoValue(@UnknownKeyFor @NonNull @Initialized Object object) {
            throw new IllegalStateException("Value conversion can't be done outside a protobuf message");
        }

        @Override
        void setOnProtoMessage(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Message.Builder message, @UnknownKeyFor @NonNull @Initialized Object value) {
            if (value != null) {
                this.fieldOverlay.setOnProtoMessage(message, value);
            }
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized Object convertToProtoValue(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Descriptors.FieldDescriptor fieldDescriptor, @UnknownKeyFor @NonNull @Initialized Object value) {
            throw new IllegalStateException("Value conversion can't be done outside a protobuf message");
        }
    }

    static class OneOfConvert
    extends Convert<OneOfType.Value, OneOfType.Value> {
        @UnknownKeyFor @NonNull @Initialized OneOfType logicalType;
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized Convert> oneOfConvert = new HashMap<Integer, Convert>();

        OneOfConvert(@UnknownKeyFor @NonNull @Initialized ProtoDynamicMessageSchema protoSchema, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.Field field, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.LogicalType logicalType) {
            super(field);
            this.logicalType = (OneOfType)logicalType;
            for (Schema.Field oneOfField : this.logicalType.getOneOfSchema().getFields()) {
                int fieldNumber = ProtoSchemaTranslator.getFieldNumber(oneOfField);
                this.oneOfConvert.put(fieldNumber, new NullableConvert(oneOfField, protoSchema.createConverter(oneOfField.withNullable(false))));
            }
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized Object getFromProtoMessage(@UnknownKeyFor @NonNull @Initialized Message message) {
            for (Map.Entry<Integer, Convert> entry : this.oneOfConvert.entrySet()) {
                Object value = entry.getValue().getFromProtoMessage(message);
                if (value == null) continue;
                return this.logicalType.createValue(entry.getKey().intValue(), value);
            }
            return null;
        }

        @Override
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized OneOfType.Value convertFromProtoValue(@UnknownKeyFor @NonNull @Initialized Object in) {
            throw new IllegalStateException("Value conversion can't be done outside a protobuf message");
        }

        @Override
        void setOnProtoMessage(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Message.Builder message, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized OneOfType.Value oneOf) {
            int caseIndex = oneOf.getCaseType().getValue();
            this.oneOfConvert.get(caseIndex).setOnProtoMessage(message, oneOf.getValue());
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized Object convertToProtoValue(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Descriptors.FieldDescriptor fieldDescriptor, @UnknownKeyFor @NonNull @Initialized Object value) {
            throw new IllegalStateException("Value conversion can't be done outside a protobuf message");
        }
    }

    static class EnumConvert
    extends Convert<Object, Object> {
        @UnknownKeyFor @NonNull @Initialized EnumerationType logicalType;

        EnumConvert(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.Field field, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.LogicalType logicalType) {
            super(field);
            this.logicalType = (EnumerationType)logicalType;
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized Object getFromProtoMessage(@UnknownKeyFor @NonNull @Initialized Message message) {
            Descriptors.FieldDescriptor fieldDescriptor = this.getFieldDescriptor(message);
            return this.convertFromProtoValue(message.getField(fieldDescriptor));
        }

        @Override
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized EnumerationType.Value convertFromProtoValue(@UnknownKeyFor @NonNull @Initialized Object in) {
            return this.logicalType.valueOf(((Descriptors.EnumValueDescriptor)in).getNumber());
        }

        @Override
        void setOnProtoMessage(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Message.Builder message, @UnknownKeyFor @NonNull @Initialized Object value) {
            Descriptors.FieldDescriptor fieldDescriptor = this.getFieldDescriptor(message);
            message.setField(fieldDescriptor, this.convertToProtoValue(fieldDescriptor, value));
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized Object convertToProtoValue(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Descriptors.FieldDescriptor fieldDescriptor, @UnknownKeyFor @NonNull @Initialized Object value) {
            Descriptors.EnumDescriptor enumType = fieldDescriptor.getEnumType();
            return enumType.findValueByNumber(((EnumerationType.Value)value).getValue());
        }
    }

    static class ArrayConvert
    extends Convert<List, List> {
        private @UnknownKeyFor @NonNull @Initialized Convert element;

        ArrayConvert(@UnknownKeyFor @NonNull @Initialized ProtoDynamicMessageSchema protoSchema, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.Field field) {
            super(field);
            Schema.FieldType collectionElementType = field.getType().getCollectionElementType();
            this.element = protoSchema.createConverter(Schema.Field.of((String)"ELEMENT", (Schema.FieldType)collectionElementType));
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized List getFromProtoMessage(@UnknownKeyFor @NonNull @Initialized Message message) {
            Descriptors.FieldDescriptor fieldDescriptor = this.getFieldDescriptor(message);
            return this.convertFromProtoValue(message.getField(fieldDescriptor));
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized List convertFromProtoValue(@UnknownKeyFor @NonNull @Initialized Object value) {
            List list = (List)value;
            ArrayList arrayList = new ArrayList();
            list.forEach(entry -> arrayList.add(this.element.convertFromProtoValue(entry)));
            return arrayList;
        }

        @Override
        void setOnProtoMessage(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Message.Builder message, @UnknownKeyFor @NonNull @Initialized List list) {
            if (list != null) {
                Descriptors.FieldDescriptor fieldDescriptor = this.getFieldDescriptor(message);
                ArrayList targetList = new ArrayList();
                list.forEach(e -> targetList.add(this.element.convertToProtoValue(fieldDescriptor, e)));
                message.setField(fieldDescriptor, targetList);
            }
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized Object convertToProtoValue(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Descriptors.FieldDescriptor fieldDescriptor, @UnknownKeyFor @NonNull @Initialized Object value) {
            return value;
        }
    }

    static class MapConvert
    extends Convert<Map, Map> {
        private @UnknownKeyFor @NonNull @Initialized Convert key;
        private @UnknownKeyFor @NonNull @Initialized Convert value;

        MapConvert(@UnknownKeyFor @NonNull @Initialized ProtoDynamicMessageSchema protoSchema, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.Field field) {
            super(field);
            Schema.FieldType fieldType = field.getType();
            this.key = protoSchema.createConverter(Schema.Field.of((String)"KEY", (Schema.FieldType)fieldType.getMapKeyType()));
            this.value = protoSchema.createConverter(Schema.Field.of((String)"VALUE", (Schema.FieldType)fieldType.getMapValueType()));
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized Map getFromProtoMessage(@UnknownKeyFor @NonNull @Initialized Message message) {
            List list = (List)message.getField(this.getFieldDescriptor(message));
            HashMap rowMap = new HashMap();
            if (list.size() == 0) {
                return rowMap;
            }
            list.forEach(entryMessage -> {
                Descriptors.Descriptor entryDescriptor = entryMessage.getDescriptorForType();
                Descriptors.FieldDescriptor keyFieldDescriptor = entryDescriptor.findFieldByName("key");
                Descriptors.FieldDescriptor valueFieldDescriptor = entryDescriptor.findFieldByName("value");
                rowMap.put(this.key.convertFromProtoValue(entryMessage.getField(keyFieldDescriptor)), this.value.convertFromProtoValue(entryMessage.getField(valueFieldDescriptor)));
            });
            return rowMap;
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized Map convertFromProtoValue(@UnknownKeyFor @NonNull @Initialized Object object) {
            throw new RuntimeException("?");
        }

        @Override
        void setOnProtoMessage(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Message.Builder message, @UnknownKeyFor @NonNull @Initialized Map map) {
            if (map != null) {
                Descriptors.FieldDescriptor fieldDescriptor = this.getFieldDescriptor(message);
                ArrayList messageMap = new ArrayList();
                map.forEach((k, v) -> {
                    DynamicMessage.Builder builder = DynamicMessage.newBuilder((Descriptors.Descriptor)fieldDescriptor.getMessageType());
                    Descriptors.FieldDescriptor keyFieldDescriptor = fieldDescriptor.getMessageType().findFieldByName("key");
                    builder.setField(keyFieldDescriptor, this.key.convertToProtoValue(keyFieldDescriptor, k));
                    Descriptors.FieldDescriptor valueFieldDescriptor = fieldDescriptor.getMessageType().findFieldByName("value");
                    builder.setField(valueFieldDescriptor, this.value.convertToProtoValue(valueFieldDescriptor, v));
                    messageMap.add(builder.build());
                });
                message.setField(fieldDescriptor, messageMap);
            }
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized Object convertToProtoValue(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Descriptors.FieldDescriptor fieldDescriptor, @UnknownKeyFor @NonNull @Initialized Object value) {
            return value;
        }
    }

    static class MessageConvert
    extends Convert<Object, Object> {
        private final @UnknownKeyFor @NonNull @Initialized SerializableFunction fromRowFunction;
        private final @UnknownKeyFor @NonNull @Initialized SerializableFunction toRowFunction;

        MessageConvert(@UnknownKeyFor @NonNull @Initialized ProtoDynamicMessageSchema rootProtoSchema, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.Field field) {
            super(field);
            ProtoDynamicMessageSchema<?> protoSchema = ProtoDynamicMessageSchema.forContext(rootProtoSchema.context, field);
            this.toRowFunction = protoSchema.getToRowFunction();
            this.fromRowFunction = protoSchema.getFromRowFunction();
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized Object getFromProtoMessage(@UnknownKeyFor @NonNull @Initialized Message message) {
            Descriptors.FieldDescriptor fieldDescriptor = this.getFieldDescriptor(message);
            if (message.hasField(fieldDescriptor)) {
                return this.convertFromProtoValue(message.getField(fieldDescriptor));
            }
            return null;
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized Object convertFromProtoValue(@UnknownKeyFor @NonNull @Initialized Object object) {
            return this.toRowFunction.apply(object);
        }

        @Override
        void setOnProtoMessage(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Message.Builder message, @UnknownKeyFor @NonNull @Initialized Object value) {
            if (value != null) {
                Descriptors.FieldDescriptor fieldDescriptor = this.getFieldDescriptor(message);
                message.setField(fieldDescriptor, this.convertToProtoValue(fieldDescriptor, value));
            }
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized Object convertToProtoValue(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Descriptors.FieldDescriptor fieldDescriptor, @UnknownKeyFor @NonNull @Initialized Object value) {
            return this.fromRowFunction.apply(value);
        }
    }

    static class DurationConvert
    extends Convert<Object, Object> {
        DurationConvert(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.Field field) {
            super(field);
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized Object getFromProtoMessage(@UnknownKeyFor @NonNull @Initialized Message message) {
            Descriptors.FieldDescriptor fieldDescriptor = this.getFieldDescriptor(message);
            if (message.hasField(fieldDescriptor)) {
                Message wrapper = (Message)message.getField(fieldDescriptor);
                return this.convertFromProtoValue(wrapper);
            }
            return null;
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized java.time.Duration convertFromProtoValue(@UnknownKeyFor @NonNull @Initialized Object object) {
            Message timestamp = (Message)object;
            Descriptors.Descriptor timestampDescriptor = timestamp.getDescriptorForType();
            Descriptors.FieldDescriptor secondField = timestampDescriptor.findFieldByNumber(1);
            Descriptors.FieldDescriptor nanoField = timestampDescriptor.findFieldByNumber(2);
            long second = (Long)timestamp.getField(secondField);
            int nano = (Integer)timestamp.getField(nanoField);
            return java.time.Duration.ofSeconds(second, nano);
        }

        @Override
        void setOnProtoMessage(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Message.Builder message, @UnknownKeyFor @NonNull @Initialized Object value) {
            if (value != null) {
                Descriptors.FieldDescriptor fieldDescriptor = this.getFieldDescriptor(message);
                message.setField(fieldDescriptor, this.convertToProtoValue(fieldDescriptor, value));
            }
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized Object convertToProtoValue(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Descriptors.FieldDescriptor fieldDescriptor, @UnknownKeyFor @NonNull @Initialized Object value) {
            java.time.Duration duration = (java.time.Duration)value;
            return Duration.newBuilder().setSeconds(duration.getSeconds()).setNanos(duration.getNano()).build();
        }
    }

    static class TimestampConvert
    extends Convert<Object, Object> {
        TimestampConvert(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.Field field) {
            super(field);
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized Object getFromProtoMessage(@UnknownKeyFor @NonNull @Initialized Message message) {
            Descriptors.FieldDescriptor fieldDescriptor = this.getFieldDescriptor(message);
            if (message.hasField(fieldDescriptor)) {
                Message wrapper = (Message)message.getField(fieldDescriptor);
                return this.convertFromProtoValue(wrapper);
            }
            return null;
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized Object convertFromProtoValue(@UnknownKeyFor @NonNull @Initialized Object object) {
            Message timestamp = (Message)object;
            Descriptors.Descriptor timestampDescriptor = timestamp.getDescriptorForType();
            Descriptors.FieldDescriptor secondField = timestampDescriptor.findFieldByNumber(1);
            Descriptors.FieldDescriptor nanoField = timestampDescriptor.findFieldByNumber(2);
            long second = (Long)timestamp.getField(secondField);
            int nano = (Integer)timestamp.getField(nanoField);
            return Instant.ofEpochSecond(second, nano);
        }

        @Override
        void setOnProtoMessage(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Message.Builder message, @UnknownKeyFor @NonNull @Initialized Object value) {
            if (value != null) {
                Descriptors.FieldDescriptor fieldDescriptor = this.getFieldDescriptor(message);
                message.setField(fieldDescriptor, this.convertToProtoValue(fieldDescriptor, value));
            }
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized Object convertToProtoValue(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Descriptors.FieldDescriptor fieldDescriptor, @UnknownKeyFor @NonNull @Initialized Object value) {
            Instant ts = (Instant)value;
            return Timestamp.newBuilder().setSeconds(ts.getEpochSecond()).setNanos(ts.getNano()).build();
        }
    }

    static class WrapperConvert
    extends Convert<Object, Object> {
        private @UnknownKeyFor @NonNull @Initialized Convert valueConvert;

        WrapperConvert(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.Field field, @UnknownKeyFor @NonNull @Initialized Convert valueConvert) {
            super(field);
            this.valueConvert = valueConvert;
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized Object getFromProtoMessage(@UnknownKeyFor @NonNull @Initialized Message message) {
            if (message.hasField(this.getFieldDescriptor(message))) {
                Message wrapper = (Message)message.getField(this.getFieldDescriptor(message));
                return this.valueConvert.getFromProtoMessage(wrapper);
            }
            return null;
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized Object convertFromProtoValue(@UnknownKeyFor @NonNull @Initialized Object object) {
            return object;
        }

        @Override
        void setOnProtoMessage(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Message.Builder message, @UnknownKeyFor @NonNull @Initialized Object value) {
            if (value != null) {
                DynamicMessage.Builder builder = DynamicMessage.newBuilder((Descriptors.Descriptor)this.getFieldDescriptor(message).getMessageType());
                this.valueConvert.setOnProtoMessage((Message.Builder)builder, value);
                message.setField(this.getFieldDescriptor(message), (Object)builder.build());
            }
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized Object convertToProtoValue(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Descriptors.FieldDescriptor fieldDescriptor, @UnknownKeyFor @NonNull @Initialized Object value) {
            return value;
        }
    }

    static class BytesConvert
    extends PrimitiveConvert {
        BytesConvert(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.Field field) {
            super(field);
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized Object convertFromProtoValue(@UnknownKeyFor @NonNull @Initialized Object object) {
            return ((ByteString)object).toByteArray();
        }

        @Override
        void setOnProtoMessage(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Message.Builder message, @UnknownKeyFor @NonNull @Initialized Object value) {
            if (value != null && ((byte[])value).length > 0) {
                Descriptors.FieldDescriptor fieldDescriptor = this.getFieldDescriptor(message);
                message.setField(fieldDescriptor, this.convertToProtoValue(fieldDescriptor, value));
            }
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized Object convertToProtoValue(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Descriptors.FieldDescriptor fieldDescriptor, @UnknownKeyFor @NonNull @Initialized Object value) {
            if (value != null) {
                return ByteString.copyFrom((byte[])((byte[])value));
            }
            return null;
        }
    }

    static class PrimitiveConvert
    extends Convert<Object, Object> {
        PrimitiveConvert(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.Field field) {
            super(field);
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized Object getFromProtoMessage(@UnknownKeyFor @NonNull @Initialized Message message) {
            Descriptors.FieldDescriptor fieldDescriptor = this.getFieldDescriptor(message);
            return this.convertFromProtoValue(message.getField(fieldDescriptor));
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized Object convertFromProtoValue(@UnknownKeyFor @NonNull @Initialized Object object) {
            return object;
        }

        @Override
        void setOnProtoMessage(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Message.Builder message, @UnknownKeyFor @NonNull @Initialized Object value) {
            message.setField(this.getFieldDescriptor(message), value);
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized Object convertToProtoValue(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Descriptors.FieldDescriptor fieldDescriptor, @UnknownKeyFor @NonNull @Initialized Object value) {
            return value;
        }
    }

    static abstract class Convert<@UnknownKeyFor ValueT, @UnknownKeyFor InT> {
        private @UnknownKeyFor @NonNull @Initialized int number;

        Convert(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.Field field) {
            Schema.Options options = field.getOptions();
            this.number = options.hasOption("beam:option:proto:meta:number") ? (Integer)options.getValue("beam:option:proto:meta:number") : -1;
        }

        // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Descriptors.FieldDescriptor getFieldDescriptor(@UnknownKeyFor @NonNull @Initialized Message message) {
            return message.getDescriptorForType().findFieldByNumber(this.number);
        }

        // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Descriptors.FieldDescriptor getFieldDescriptor(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Message.Builder message) {
            return message.getDescriptorForType().findFieldByNumber(this.number);
        }

        abstract @UnknownKeyFor @NonNull @Initialized Object getFromProtoMessage(@UnknownKeyFor @NonNull @Initialized Message var1);

        abstract ValueT convertFromProtoValue(@UnknownKeyFor @NonNull @Initialized Object var1);

        abstract void setOnProtoMessage(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Message.Builder var1, InT var2);

        abstract @UnknownKeyFor @NonNull @Initialized Object convertToProtoValue(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Descriptors.FieldDescriptor var1, @UnknownKeyFor @NonNull @Initialized Object var2);
    }

    static class DescriptorContext
    extends Context<DynamicMessage> {
        private final @UnknownKeyFor @NonNull @Initialized String messageName;
        private final @UnknownKeyFor @NonNull @Initialized ProtoDomain domain;
        private transient // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Descriptors.Descriptor descriptor;

        DescriptorContext(@UnknownKeyFor @NonNull @Initialized String messageName, @UnknownKeyFor @NonNull @Initialized ProtoDomain domain) {
            super(ProtoSchemaTranslator.getSchema(domain.getDescriptor(messageName)), DynamicMessage.class);
            this.messageName = messageName;
            this.domain = domain;
        }

        @Override
        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DynamicMessage.Builder invokeNewBuilder() {
            if (this.descriptor == null) {
                this.descriptor = this.domain.getDescriptor(this.messageName);
            }
            return DynamicMessage.newBuilder((Descriptors.Descriptor)this.descriptor);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Context getSubContext(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.Field field) {
            String messageName = (String)field.getType().getRowSchema().getOptions().getValue("beam:option:proto:meta:type_name");
            return new DescriptorContext(messageName, this.domain);
        }
    }

    static class Context<@UnknownKeyFor T>
    implements Serializable {
        private final @UnknownKeyFor @NonNull @Initialized Schema schema;
        private @UnknownKeyFor @NonNull @Initialized Class<T> baseClass;

        Context(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized Class<T> baseClass) {
            this.schema = schema;
            this.baseClass = baseClass;
        }

        public @UnknownKeyFor @NonNull @Initialized Schema getSchema() {
            return this.schema;
        }

        public @UnknownKeyFor @NonNull @Initialized Class<T> getBaseClass() {
            return this.baseClass;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DynamicMessage.Builder invokeNewBuilder() {
            throw new IllegalStateException("Should not be calling invokeNewBuilder");
        }

        public @UnknownKeyFor @NonNull @Initialized Context getSubContext(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.Field field) {
            return new Context<Message>(field.getType().getRowSchema(), Message.class);
        }
    }
}

