/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.collections;

import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.common.collections.BlockingMpscQueue;
import org.junit.Assert;
import org.junit.Test;

public class BlockingMpscQueueTest {
    @Test
    public void basicTest() throws Exception {
        int i;
        int size = 15;
        BlockingMpscQueue queue = new BlockingMpscQueue(15);
        for (i = 0; i < 15; ++i) {
            queue.put(i);
            Assert.assertEquals((long)(15 - i), (long)queue.remainingCapacity());
        }
        Assert.assertEquals((long)15L, (long)queue.size());
        for (i = 0; i < 15; ++i) {
            Integer n = (Integer)queue.take();
            Assert.assertTrue((n != null ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)0L, (long)queue.size());
        Integer res = (Integer)queue.poll(100L, TimeUnit.MILLISECONDS);
        Assert.assertNull((Object)res);
    }

    @Test
    public void testOffer() throws Exception {
        int size = 16;
        BlockingMpscQueue queue = new BlockingMpscQueue(16);
        for (int i = 0; i < 16; ++i) {
            Assert.assertTrue((boolean)queue.offer(1, 100L, TimeUnit.MILLISECONDS));
        }
        Assert.assertEquals((long)16L, (long)queue.size());
        Assert.assertFalse((boolean)queue.offer(1, 100L, TimeUnit.MILLISECONDS));
        Assert.assertEquals((long)16L, (long)queue.size());
    }

    @Test
    public void testDrain() throws Exception {
        int size = 10;
        BlockingMpscQueue queue = new BlockingMpscQueue(10);
        for (int i = 0; i < 10; ++i) {
            queue.put(i);
        }
        ArrayList list = new ArrayList(10);
        queue.drainTo(list);
        Assert.assertEquals((long)10L, (long)list.size());
        Assert.assertEquals((long)0L, (long)queue.size());
        Integer res = (Integer)queue.poll(100L, TimeUnit.MILLISECONDS);
        Assert.assertNull((Object)res);
    }

    @Test
    public void testDrainWithLimit() throws Exception {
        int size = 10;
        BlockingMpscQueue queue = new BlockingMpscQueue(10);
        for (int i = 0; i < 10; ++i) {
            queue.put(i);
        }
        ArrayList list = new ArrayList();
        queue.drainTo(list, 5);
        Assert.assertEquals((long)5L, (long)list.size());
        Assert.assertEquals((long)5L, (long)queue.size());
    }
}

