/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.net;

import java.net.URI;
import org.apache.bookkeeper.common.net.ServiceURI;
import org.junit.Assert;
import org.junit.Test;

public class ServiceURITest {
    private static void assertServiceUri(String serviceUri, String expectedServiceName, String[] expectedServiceInfo, String expectedServiceUser, String[] expectedServiceHosts, String expectedServicePath) {
        ServiceURI serviceURI = ServiceURI.create((String)serviceUri);
        Assert.assertEquals((Object)expectedServiceName, (Object)serviceURI.getServiceName());
        Assert.assertArrayEquals((Object[])expectedServiceInfo, (Object[])serviceURI.getServiceInfos());
        Assert.assertEquals((Object)expectedServiceUser, (Object)serviceURI.getServiceUser());
        Assert.assertArrayEquals((Object[])expectedServiceHosts, (Object[])serviceURI.getServiceHosts());
        Assert.assertEquals((Object)expectedServicePath, (Object)serviceURI.getServicePath());
    }

    @Test
    public void testInvalidServiceUris() {
        String[] uris;
        for (String uri : uris = new String[]{"://localhost:2181/path/to/namespace", "bk:///path/to/namespace", "bk://localhost:2181:3181/path/to/namespace", "bk://localhost:xyz/path/to/namespace", "bk://localhost:-2181/path/to/namespace"}) {
            this.testInvalidServiceUri(uri);
        }
    }

    @Test(expected=NullPointerException.class)
    public void testNullServiceUriString() {
        ServiceURI.create((String)null);
    }

    @Test(expected=NullPointerException.class)
    public void testNullServiceUriInstance() {
        ServiceURI.create((URI)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEmptyServiceUriString() {
        ServiceURI.create((String)"");
    }

    private void testInvalidServiceUri(String serviceUri) {
        try {
            ServiceURI.create((String)serviceUri);
            Assert.fail((String)("Should fail to parse service uri : " + serviceUri));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMissingServiceName() {
        String serviceUri = "//localhost:2181/path/to/namespace";
        ServiceURITest.assertServiceUri(serviceUri, null, new String[0], null, new String[]{"localhost:2181"}, "/path/to/namespace");
    }

    @Test
    public void testEmptyPath() {
        String serviceUri = "bk://localhost:2181";
        ServiceURITest.assertServiceUri(serviceUri, "bk", new String[0], null, new String[]{"localhost:2181"}, "");
    }

    @Test
    public void testRootPath() {
        String serviceUri = "bk://localhost:2181/";
        ServiceURITest.assertServiceUri(serviceUri, "bk", new String[0], null, new String[]{"localhost:2181"}, "/");
    }

    @Test
    public void testUserInfo() {
        String serviceUri = "bk://bookkeeper@localhost:2181/path/to/namespace";
        ServiceURITest.assertServiceUri(serviceUri, "bk", new String[0], "bookkeeper", new String[]{"localhost:2181"}, "/path/to/namespace");
    }

    @Test
    public void testMultipleHostsSemiColon() {
        String serviceUri = "bk://host1:2181;host2:2181;host3:2181/path/to/namespace";
        ServiceURITest.assertServiceUri(serviceUri, "bk", new String[0], null, new String[]{"host1:2181", "host2:2181", "host3:2181"}, "/path/to/namespace");
    }

    @Test
    public void testMultipleHostsComma() {
        String serviceUri = "bk://host1:2181,host2:2181,host3:2181/path/to/namespace";
        ServiceURITest.assertServiceUri(serviceUri, "bk", new String[0], null, new String[]{"host1:2181", "host2:2181", "host3:2181"}, "/path/to/namespace");
    }

    @Test
    public void testMultipleHostsWithoutPorts() {
        String serviceUri = "bk://host1,host2,host3/path/to/namespace";
        ServiceURITest.assertServiceUri(serviceUri, "bk", new String[0], null, new String[]{"host1:4181", "host2:4181", "host3:4181"}, "/path/to/namespace");
    }

    @Test
    public void testMultipleHostsMixedPorts() {
        String serviceUri = "bk://host1:3181,host2,host3:2181/path/to/namespace";
        ServiceURITest.assertServiceUri(serviceUri, "bk", new String[0], null, new String[]{"host1:3181", "host2:4181", "host3:2181"}, "/path/to/namespace");
    }

    @Test
    public void testMultipleHostsMixed() {
        String serviceUri = "bk://host1:2181,host2,host3:2181/path/to/namespace";
        ServiceURITest.assertServiceUri(serviceUri, "bk", new String[0], null, new String[]{"host1:2181", "host2:4181", "host3:2181"}, "/path/to/namespace");
    }

    @Test
    public void testUserInfoWithMultipleHosts() {
        String serviceUri = "bk://bookkeeper@host1:2181;host2:2181;host3:2181/path/to/namespace";
        ServiceURITest.assertServiceUri(serviceUri, "bk", new String[0], "bookkeeper", new String[]{"host1:2181", "host2:2181", "host3:2181"}, "/path/to/namespace");
    }

    @Test
    public void testServiceInfoPlus() {
        String serviceUri = "bk+ssl://host:2181/path/to/namespace";
        ServiceURITest.assertServiceUri(serviceUri, "bk", new String[]{"ssl"}, null, new String[]{"host:2181"}, "/path/to/namespace");
    }

    @Test
    public void testServiceInfoMinus() {
        String serviceUri = "bk-ssl://host:2181/path/to/namespace";
        ServiceURITest.assertServiceUri(serviceUri, "bk-ssl", new String[0], null, new String[]{"host:2181"}, "/path/to/namespace");
    }

    @Test
    public void testServiceInfoDlogMinus() {
        String serviceUri = "distributedlog-bk://host:2181/path/to/namespace";
        ServiceURITest.assertServiceUri(serviceUri, "distributedlog", new String[]{"bk"}, null, new String[]{"host:2181"}, "/path/to/namespace");
    }
}

