/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.testing.executors;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;

public class MockClock
extends Clock {
    private final ZoneId zoneId;
    private Instant now = Instant.ofEpochMilli(0L);

    public MockClock() {
        this(ZoneId.systemDefault());
    }

    private MockClock(ZoneId zoneId) {
        this.zoneId = zoneId;
    }

    @Override
    public ZoneId getZone() {
        return this.zoneId;
    }

    @Override
    public MockClock withZone(ZoneId zone) {
        return new MockClock(zone);
    }

    @Override
    public Instant instant() {
        return this.now;
    }

    public void advance(Duration duration) {
        this.now = this.now.plus(duration);
    }
}

