/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.util;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.common.util.MemoryLimitController;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MemoryLimitControllerTest {
    private ExecutorService executor;

    @Before
    public void setup() {
        this.executor = Executors.newCachedThreadPool();
    }

    @After
    public void teardown() {
        this.executor.shutdownNow();
    }

    @Test
    public void testLimit() throws Exception {
        MemoryLimitController mlc = new MemoryLimitController(100L);
        for (int i = 0; i < 101; ++i) {
            mlc.reserveMemory(1L);
        }
        Assert.assertEquals((long)101L, (long)mlc.currentUsage());
        Assert.assertFalse((boolean)mlc.tryReserveMemory(1L));
        mlc.releaseMemory(1L);
        Assert.assertEquals((long)100L, (long)mlc.currentUsage());
        Assert.assertTrue((boolean)mlc.tryReserveMemory(1L));
        Assert.assertEquals((long)101L, (long)mlc.currentUsage());
    }

    @Test
    public void testBlocking() throws Exception {
        MemoryLimitController mlc = new MemoryLimitController(100L);
        for (int i = 0; i < 101; ++i) {
            mlc.reserveMemory(1L);
        }
        CountDownLatch l1 = new CountDownLatch(1);
        this.executor.submit(() -> {
            try {
                mlc.reserveMemory(1L);
                l1.countDown();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        CountDownLatch l2 = new CountDownLatch(1);
        this.executor.submit(() -> {
            try {
                mlc.reserveMemory(1L);
                l2.countDown();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        CountDownLatch l3 = new CountDownLatch(1);
        this.executor.submit(() -> {
            try {
                mlc.reserveMemory(1L);
                l3.countDown();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        Assert.assertFalse((boolean)l1.await(100L, TimeUnit.MILLISECONDS));
        Assert.assertFalse((boolean)l2.await(100L, TimeUnit.MILLISECONDS));
        Assert.assertFalse((boolean)l3.await(100L, TimeUnit.MILLISECONDS));
        Assert.assertEquals((long)101L, (long)mlc.currentUsage());
        mlc.releaseMemory(3L);
        Assert.assertTrue((boolean)l1.await(1L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)l2.await(1L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)l3.await(1L, TimeUnit.SECONDS));
        Assert.assertEquals((long)101L, (long)mlc.currentUsage());
    }

    @Test
    public void testStepRelease() throws Exception {
        MemoryLimitController mlc = new MemoryLimitController(100L);
        for (int i = 0; i < 101; ++i) {
            mlc.reserveMemory(1L);
        }
        CountDownLatch l1 = new CountDownLatch(1);
        this.executor.submit(() -> {
            try {
                mlc.reserveMemory(1L);
                l1.countDown();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        CountDownLatch l2 = new CountDownLatch(1);
        this.executor.submit(() -> {
            try {
                mlc.reserveMemory(1L);
                l2.countDown();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        CountDownLatch l3 = new CountDownLatch(1);
        this.executor.submit(() -> {
            try {
                mlc.reserveMemory(1L);
                l3.countDown();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        Assert.assertFalse((boolean)l1.await(100L, TimeUnit.MILLISECONDS));
        Assert.assertFalse((boolean)l2.await(100L, TimeUnit.MILLISECONDS));
        Assert.assertFalse((boolean)l3.await(100L, TimeUnit.MILLISECONDS));
        Assert.assertEquals((long)101L, (long)mlc.currentUsage());
        mlc.releaseMemory(1L);
        mlc.releaseMemory(1L);
        mlc.releaseMemory(1L);
        Assert.assertTrue((boolean)l1.await(1L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)l2.await(1L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)l3.await(1L, TimeUnit.SECONDS));
        Assert.assertEquals((long)101L, (long)mlc.currentUsage());
    }
}

